/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api;

import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.IHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jmessage.api.chatroom.ChatRoomClient;
import cn.jmessage.api.chatroom.ChatRoomListResult;
import cn.jmessage.api.chatroom.ChatRoomMemberList;
import cn.jmessage.api.chatroom.CreateChatRoomResult;
import cn.jmessage.api.common.JMessageConfig;
import cn.jmessage.api.common.model.Members;
import cn.jmessage.api.common.model.NoDisturbPayload;
import cn.jmessage.api.common.model.RegisterInfo;
import cn.jmessage.api.common.model.RegisterPayload;
import cn.jmessage.api.common.model.UserPayload;
import cn.jmessage.api.common.model.chatroom.ChatRoomPayload;
import cn.jmessage.api.common.model.cross.CrossBlacklist;
import cn.jmessage.api.common.model.cross.CrossFriendPayload;
import cn.jmessage.api.common.model.cross.CrossGroup;
import cn.jmessage.api.common.model.cross.CrossNoDisturb;
import cn.jmessage.api.common.model.friend.FriendNote;
import cn.jmessage.api.common.model.group.GroupPayload;
import cn.jmessage.api.common.model.group.GroupShieldPayload;
import cn.jmessage.api.common.model.message.MessageBody;
import cn.jmessage.api.common.model.message.MessagePayload;
import cn.jmessage.api.crossapp.CrossAppClient;
import cn.jmessage.api.group.CreateGroupResult;
import cn.jmessage.api.group.GroupClient;
import cn.jmessage.api.group.GroupInfoResult;
import cn.jmessage.api.group.GroupListResult;
import cn.jmessage.api.group.MemberListResult;
import cn.jmessage.api.message.MessageClient;
import cn.jmessage.api.message.MessageListResult;
import cn.jmessage.api.message.MessageType;
import cn.jmessage.api.message.SendMessageResult;
import cn.jmessage.api.reportv2.GroupStatListResult;
import cn.jmessage.api.reportv2.MessageStatListResult;
import cn.jmessage.api.reportv2.ReportClient;
import cn.jmessage.api.reportv2.UserStatListResult;
import cn.jmessage.api.resource.DownloadResult;
import cn.jmessage.api.resource.ResourceClient;
import cn.jmessage.api.resource.UploadResult;
import cn.jmessage.api.sensitiveword.SensitiveWordClient;
import cn.jmessage.api.sensitiveword.SensitiveWordListResult;
import cn.jmessage.api.sensitiveword.SensitiveWordStatusResult;
import cn.jmessage.api.user.UserClient;
import cn.jmessage.api.user.UserGroupsResult;
import cn.jmessage.api.user.UserInfoResult;
import cn.jmessage.api.user.UserListResult;
import cn.jmessage.api.user.UserStateListResult;
import cn.jmessage.api.user.UserStateResult;
import java.util.Set;

public class JMessageClient {
    private final UserClient _userClient;
    private final GroupClient _groupClient;
    private final MessageClient _messageClient;
    private final ResourceClient _resourceClient;
    private final CrossAppClient _crossAppClient;
    private final SensitiveWordClient _sensitiveWordClient;
    private final ChatRoomClient _chatRoomClient;
    private final ReportClient _reportClient;
    private final int _sendVersion;

    public JMessageClient(String appkey, String masterSecret) {
        this(appkey, masterSecret, null, JMessageConfig.getInstance());
    }

    public JMessageClient(String appkey, String masterSecret, int maxRetryTimes) {
        this(appkey, masterSecret, null, JMessageConfig.getInstance().setMaxRetryTimes(maxRetryTimes));
    }

    public JMessageClient(String appkey, String masterSecret, HttpProxy proxy) {
        this(appkey, masterSecret, proxy, JMessageConfig.getInstance());
    }

    public JMessageClient(String appkey, String masterSecret, String hostname) {
        this(appkey, masterSecret, null, JMessageConfig.getInstance().setApiHostName(hostname));
    }

    public JMessageClient(String appkey, String masterSecret, HttpProxy proxy, JMessageConfig config) {
        this._userClient = new UserClient(appkey, masterSecret, proxy, config);
        this._groupClient = new GroupClient(appkey, masterSecret, proxy, config);
        this._messageClient = new MessageClient(appkey, masterSecret, proxy, config);
        this._crossAppClient = new CrossAppClient(appkey, masterSecret, proxy, config);
        this._resourceClient = new ResourceClient(appkey, masterSecret, proxy, config);
        this._sensitiveWordClient = new SensitiveWordClient(appkey, masterSecret, proxy, config);
        this._chatRoomClient = new ChatRoomClient(appkey, masterSecret, proxy, config);
        this._reportClient = new ReportClient(appkey, masterSecret, proxy, config);
        this._sendVersion = (Integer)config.get("send.version");
    }

    public String registerUsers(RegisterInfo[] users) throws APIConnectionException, APIRequestException {
        RegisterPayload payload = RegisterPayload.newBuilder().addUsers(users).build();
        return this._userClient.registerUsers((RegisterPayload)payload).responseContent;
    }

    public String registerAdmins(String username, String password) throws APIConnectionException, APIRequestException {
        RegisterInfo payload = RegisterInfo.newBuilder().setUsername(username).setPassword(password).build();
        return this._userClient.registerAdmins((RegisterInfo)payload).responseContent;
    }

    public UserInfoResult getUserInfo(String username) throws APIConnectionException, APIRequestException {
        return this._userClient.getUserInfo(username);
    }

    public UserStateResult getUserState(String username) throws APIConnectionException, APIRequestException {
        return this._userClient.getUserState(username);
    }

    public UserStateListResult[] getUsersState(String ... users) throws APIConnectionException, APIRequestException {
        return this._userClient.getUsersState(users);
    }

    public void updateUserPassword(String username, String password) throws APIConnectionException, APIRequestException {
        this._userClient.updatePassword(username, password);
    }

    public void updateUserInfo(String username, String nickname, String birthday, String signature, int gender, String region, String address, String avatar) throws APIConnectionException, APIRequestException {
        UserPayload payload = UserPayload.newBuilder().setNickname(nickname).setBirthday(birthday).setSignature(signature).setGender(gender).setRegion(region).setAddress(address).setAvatar(avatar).build();
        this._userClient.updateUserInfo(username, payload);
    }

    public void updateUserInfo(String username, UserPayload payload) throws APIConnectionException, APIRequestException {
        this._userClient.updateUserInfo(username, payload);
    }

    public UserListResult getUserList(int start, int count) throws APIConnectionException, APIRequestException {
        return this._userClient.getUserList(start, count);
    }

    public UserListResult getAdminListByAppkey(int start, int count) throws APIConnectionException, APIRequestException {
        return this._userClient.getAdminListByAppkey(start, count);
    }

    public UserInfoResult[] getBlackList(String username) throws APIConnectionException, APIRequestException {
        return this._userClient.getBlackList(username);
    }

    public ResponseWrapper addBlackList(String username, String ... users) throws APIConnectionException, APIRequestException {
        return this._userClient.addBlackList(username, users);
    }

    public ResponseWrapper removeBlacklist(String username, String ... users) throws APIConnectionException, APIRequestException {
        return this._userClient.removeBlackList(username, users);
    }

    public UserGroupsResult getGroupListByUser(String username) throws APIConnectionException, APIRequestException {
        return this._userClient.getGroupList(username);
    }

    public void deleteUser(String username) throws APIConnectionException, APIRequestException {
        this._userClient.deleteUser(username);
    }

    public ResponseWrapper setNoDisturb(String username, NoDisturbPayload payload) throws APIConnectionException, APIRequestException {
        return this._userClient.setNoDisturb(username, payload);
    }

    public ResponseWrapper addFriends(String username, String ... users) throws APIConnectionException, APIRequestException {
        return this._userClient.addFriends(username, users);
    }

    public ResponseWrapper deleteFriends(String username, String ... users) throws APIConnectionException, APIRequestException {
        return this._userClient.deleteFriends(username, users);
    }

    public ResponseWrapper updateFriendsNote(String username, FriendNote[] array) throws APIConnectionException, APIRequestException {
        return this._userClient.updateFriendsNote(username, array);
    }

    public UserInfoResult[] getFriendsInfo(String username) throws APIConnectionException, APIRequestException {
        return this._userClient.getFriendsInfo(username);
    }

    public ResponseWrapper setGroupShield(GroupShieldPayload payload, String username) throws APIConnectionException, APIRequestException {
        return this._userClient.setGroupShield(payload, username);
    }

    public ResponseWrapper forbidUser(String username, boolean disable) throws APIConnectionException, APIRequestException {
        return this._userClient.forbidUser(username, disable);
    }

    public GroupInfoResult getGroupInfo(long gid) throws APIConnectionException, APIRequestException {
        return this._groupClient.getGroupInfo(gid);
    }

    public MemberListResult getGroupMembers(long gid) throws APIConnectionException, APIRequestException {
        return this._groupClient.getGroupMembers(gid);
    }

    public GroupListResult getGroupListByAppkey(int start, int count) throws APIConnectionException, APIRequestException {
        return this._groupClient.getGroupListByAppkey(start, count);
    }

    public CreateGroupResult createGroup(String owner, String gname, String desc, String avatar, int flag, String ... userlist) throws APIConnectionException, APIRequestException {
        Members members = Members.newBuilder().addMember(userlist).build();
        GroupPayload payload = GroupPayload.newBuilder().setOwner(owner).setName(gname).setDesc(desc).setMembers(members).setAvatar(avatar).setFlag(flag).build();
        return this._groupClient.createGroup(payload);
    }

    public void addOrRemoveMembers(long gid, String[] addList, String[] removeList) throws APIConnectionException, APIRequestException {
        Members add = Members.newBuilder().addMember(addList).build();
        Members remove = Members.newBuilder().addMember(removeList).build();
        this._groupClient.addOrRemoveMembers(gid, add, remove);
    }

    public void deleteGroup(long gid) throws APIConnectionException, APIRequestException {
        this._groupClient.deleteGroup(gid);
    }

    public void updateGroupInfo(long gid, String groupName, String groupDesc, String avatar) throws APIConnectionException, APIRequestException {
        this._groupClient.updateGroupInfo(gid, groupName, groupDesc, avatar);
    }

    public void changeGroupAdmin(long gid, String appKey, String username) throws APIConnectionException, APIRequestException {
        this._groupClient.changeGroupAdmin(gid, appKey, username);
    }

    public SendMessageResult sendMessage(Integer version, String targetType, String targetId, String fromType, String fromId, MessageType messageType, MessageBody messageBody) throws APIConnectionException, APIRequestException {
        MessagePayload payload = MessagePayload.newBuilder().setVersion(version).setTargetType(targetType).setTargetId(targetId).setFromType(fromType).setFromId(fromId).setMessageType(messageType).setMessageBody(messageBody).build();
        return this._messageClient.sendMessage(payload);
    }

    public SendMessageResult sendMessage(MessagePayload payload) throws APIConnectionException, APIRequestException {
        return this._messageClient.sendMessage(payload);
    }

    public SendMessageResult sendSingleTextByAdmin(String targetId, String fromId, MessageBody body) throws APIConnectionException, APIRequestException {
        return this.sendMessage(this._sendVersion, "single", targetId, "admin", fromId, MessageType.TEXT, body);
    }

    public SendMessageResult sendGroupTextByAdmin(String targetId, String fromId, MessageBody body) throws APIConnectionException, APIRequestException {
        return this.sendMessage(this._sendVersion, "group", targetId, "admin", fromId, MessageType.TEXT, body);
    }

    public MessageListResult getMessageList(int count, String begin_time, String end_time) throws APIConnectionException, APIRequestException {
        return this._messageClient.getMessageList(count, begin_time, end_time);
    }

    public MessageListResult getMessageListByCursor(String cursor) throws APIConnectionException, APIRequestException {
        return this._messageClient.getMessageListByCursor(cursor);
    }

    public MessageListResult getUserMessages(String username, int count, String begin_time, String end_time) throws APIConnectionException, APIRequestException {
        return this._messageClient.getUserMessages(username, count, begin_time, end_time);
    }

    public MessageListResult getUserMessagesByCursor(String username, String cursor) throws APIConnectionException, APIRequestException {
        return this._messageClient.getUserMessagesByCursor(username, cursor);
    }

    public ResponseWrapper retractMessage(String username, long msgId) throws APIConnectionException, APIRequestException {
        return this._messageClient.retractMessage(username, msgId);
    }

    public DownloadResult downloadFile(String mediaId) throws APIConnectionException, APIRequestException {
        return this._resourceClient.downloadFile(mediaId);
    }

    public UploadResult uploadFile(String path, String fileType) throws APIConnectionException, APIRequestException {
        return this._resourceClient.uploadFile(path, fileType);
    }

    public ResponseWrapper addOrRemoveCrossGroupMember(long gid, CrossGroup[] groups) throws APIConnectionException, APIRequestException {
        return this._crossAppClient.addOrRemoveCrossGroupMembers(gid, groups);
    }

    public MemberListResult getCrossGroupMembers(long gid) throws APIConnectionException, APIRequestException {
        return this._crossAppClient.getCrossGroupMembers(gid);
    }

    public ResponseWrapper addCrossBlacklist(String username, CrossBlacklist[] blacklists) throws APIConnectionException, APIRequestException {
        return this._crossAppClient.addCrossBlacklist(username, blacklists);
    }

    public ResponseWrapper deleteCrossBlacklist(String username, CrossBlacklist[] blacklists) throws APIConnectionException, APIRequestException {
        return this._crossAppClient.deleteCrossBlacklist(username, blacklists);
    }

    public UserInfoResult[] getCrossBlacklist(String username) throws APIConnectionException, APIRequestException {
        return this._crossAppClient.getCrossBlacklist(username);
    }

    public ResponseWrapper setCrossNoDisturb(String username, CrossNoDisturb[] array) throws APIConnectionException, APIRequestException {
        return this._crossAppClient.setCrossNoDisturb(username, array);
    }

    public ResponseWrapper addCrossFriends(String username, CrossFriendPayload payload) throws APIConnectionException, APIRequestException {
        return this._crossAppClient.addCrossFriends(username, payload);
    }

    public ResponseWrapper deleteCrossFriends(String username, CrossFriendPayload payload) throws APIConnectionException, APIRequestException {
        return this._crossAppClient.deleteCrossFriends(username, payload);
    }

    public ResponseWrapper addSensitiveWords(String ... words) throws APIConnectionException, APIRequestException {
        return this._sensitiveWordClient.addSensitiveWords(words);
    }

    public ResponseWrapper addSensitiveWords(Set<String> words) throws APIConnectionException, APIRequestException {
        return this._sensitiveWordClient.addSensitiveWords(words);
    }

    public ResponseWrapper updateSensitiveWord(String newWord, String oldWord) throws APIConnectionException, APIRequestException {
        return this._sensitiveWordClient.updateSensitiveWord(newWord, oldWord);
    }

    public ResponseWrapper deleteSensitiveWord(String word) throws APIConnectionException, APIRequestException {
        return this._sensitiveWordClient.deleteSensitiveWord(word);
    }

    public SensitiveWordListResult getSensitiveWordList(int start, int count) throws APIConnectionException, APIRequestException {
        return this._sensitiveWordClient.getSensitiveWordList(start, count);
    }

    public ResponseWrapper updateSensitiveWordStatus(int status) throws APIConnectionException, APIRequestException {
        return this._sensitiveWordClient.updateSensitiveWordStatus(status);
    }

    public SensitiveWordStatusResult getSensitiveWordStatus() throws APIConnectionException, APIRequestException {
        return this._sensitiveWordClient.getSensitiveWordStatus();
    }

    public CreateChatRoomResult createChatRoom(ChatRoomPayload payload) throws APIConnectionException, APIRequestException {
        return this._chatRoomClient.createChatRoom(payload);
    }

    public ChatRoomListResult getBatchChatRoomInfo(long ... roomIds) throws APIConnectionException, APIRequestException {
        return this._chatRoomClient.getBatchChatRoomInfo(roomIds);
    }

    public ChatRoomListResult getUserChatRoomInfo(String username) throws APIConnectionException, APIRequestException {
        return this._chatRoomClient.getUserChatRoomInfo(username);
    }

    public ChatRoomListResult getAppChatRoomInfo(int start, int count) throws APIConnectionException, APIRequestException {
        return this._chatRoomClient.getAppChatRoomInfo(start, count);
    }

    public ResponseWrapper updateChatRoomInfo(long roomId, String ownerUsername, String name, String desc) throws APIConnectionException, APIRequestException {
        return this._chatRoomClient.updateChatRoomInfo(roomId, ownerUsername, name, desc);
    }

    public ResponseWrapper deleteChatRoom(long roomId) throws APIConnectionException, APIRequestException {
        return this._chatRoomClient.deleteChatRoom(roomId);
    }

    public ResponseWrapper updateUserSpeakStatus(long roomId, String username, int flag) throws APIConnectionException, APIRequestException {
        return this._chatRoomClient.updateUserSpeakStatus(roomId, username, flag);
    }

    public ChatRoomMemberList getChatRoomMembers(long roomId, int start, int count) throws APIConnectionException, APIRequestException {
        return this._chatRoomClient.getChatRoomMembers(roomId, start, count);
    }

    public ResponseWrapper addChatRoomMember(long roomId, String ... members) throws APIConnectionException, APIRequestException {
        return this._chatRoomClient.addChatRoomMember(roomId, members);
    }

    public ResponseWrapper addChatRoomMember(long roomId, Members members) throws APIConnectionException, APIRequestException {
        return this._chatRoomClient.addChatRoomMember(roomId, members);
    }

    public ResponseWrapper removeChatRoomMembers(long roomId, String ... members) throws APIConnectionException, APIRequestException {
        return this._chatRoomClient.removeChatRoomMembers(roomId, members);
    }

    public ResponseWrapper removeChatRoomMembers(long roomId, Members members) throws APIConnectionException, APIRequestException {
        return this._chatRoomClient.removeChatRoomMembers(roomId, members);
    }

    public MessageListResult v2GetMessageList(int count, String begin_time, String end_time) throws APIConnectionException, APIRequestException {
        return this._reportClient.v2GetMessageList(count, begin_time, end_time);
    }

    public MessageListResult v2GetMessageListByCursor(String cursor) throws APIConnectionException, APIRequestException {
        return this._reportClient.v2GetMessageListByCursor(cursor);
    }

    public MessageListResult v2GetUserMessages(String username, int count, String begin_time, String end_time) throws APIConnectionException, APIRequestException {
        return this._reportClient.v2GetUserMessages(username, count, begin_time, end_time);
    }

    public MessageListResult v2GetUserMessagesByCursor(String username, String cursor) throws APIConnectionException, APIRequestException {
        return this._reportClient.v2GetUserMessagesByCursor(username, cursor);
    }

    public UserStatListResult getUserStatistic(String startTime, int duration) throws APIConnectionException, APIRequestException {
        return this._reportClient.getUserStatistic(startTime, duration);
    }

    public MessageStatListResult getMessageStatistic(String timeUnit, String start, int duration) throws APIConnectionException, APIRequestException {
        return this._reportClient.getMessageStatistic(timeUnit, start, duration);
    }

    public GroupStatListResult getGroupStatistic(String start, int duration) throws APIConnectionException, APIRequestException {
        return this._reportClient.getGroupStatistic(start, duration);
    }

    public void setHttpClient(IHttpClient httpClient) {
        this._userClient.setHttpClient(httpClient);
        this._sensitiveWordClient.setHttpClient(httpClient);
        this._groupClient.setHttpClient(httpClient);
        this._messageClient.setHttpClient(httpClient);
        this._resourceClient.setHttpClient(httpClient);
        this._crossAppClient.setHttpClient(httpClient);
        this._chatRoomClient.setHttpClient(httpClient);
        this._reportClient.setHttpClient(httpClient);
    }
}

