/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.chatroom;

import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.chatroom.ChatRoomListResult;
import cn.jmessage.api.chatroom.ChatRoomMemberList;
import cn.jmessage.api.chatroom.CreateChatRoomResult;
import cn.jmessage.api.common.BaseClient;
import cn.jmessage.api.common.JMessageConfig;
import cn.jmessage.api.common.model.Members;
import cn.jmessage.api.common.model.chatroom.ChatRoomPayload;
import cn.jmessage.api.utils.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class ChatRoomClient
extends BaseClient {
    private String mChatRoomPath;
    private String mUserPath;

    public ChatRoomClient(String appKey, String masterSecret) {
        this(appKey, masterSecret, null, JMessageConfig.getInstance());
    }

    public ChatRoomClient(String appKey, String masterSecret, HttpProxy proxy) {
        this(appKey, masterSecret, proxy, JMessageConfig.getInstance());
    }

    public ChatRoomClient(String appKey, String masterSecret, HttpProxy proxy, JMessageConfig config) {
        super(appKey, masterSecret, proxy, config);
        this.mChatRoomPath = (String)config.get("im.chat.room.path");
        this.mUserPath = (String)config.get("im.user.path");
    }

    public CreateChatRoomResult createChatRoom(ChatRoomPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"ChatRoomPayload should not be null");
        ResponseWrapper responseWrapper = this._httpClient.sendPost(this._baseUrl + this.mChatRoomPath, payload.toString());
        return (CreateChatRoomResult)CreateChatRoomResult.fromResponse((ResponseWrapper)responseWrapper, CreateChatRoomResult.class);
    }

    public ChatRoomListResult getBatchChatRoomInfo(long ... roomIds) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((roomIds != null && roomIds.length > 0 ? 1 : 0) != 0, (Object)"Room ids should not be null");
        JsonArray array = new JsonArray();
        for (long id : roomIds) {
            array.add((JsonElement)new JsonPrimitive((Number)id));
        }
        ResponseWrapper responseWrapper = this._httpClient.sendPost(this._baseUrl + this.mChatRoomPath + "/batch", array.toString());
        return ChatRoomListResult.fromResponse(responseWrapper);
    }

    public ChatRoomListResult getUserChatRoomInfo(String username) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        ResponseWrapper responseWrapper = this._httpClient.sendGet(this._baseUrl + this.mUserPath + "/" + username + "/chatroom");
        return ChatRoomListResult.fromResponse(responseWrapper);
    }

    public ChatRoomListResult getAppChatRoomInfo(int start, int count) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((start >= 0 && count > 0 ? 1 : 0) != 0, (Object)"Illegal argument");
        ResponseWrapper responseWrapper = this._httpClient.sendGet(this._baseUrl + this.mChatRoomPath + "?start=" + start + "&count=" + count);
        return (ChatRoomListResult)ChatRoomListResult.fromResponse((ResponseWrapper)responseWrapper, ChatRoomListResult.class);
    }

    public ResponseWrapper updateChatRoomInfo(long roomId, String ownerUsername, String name, String desc) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((roomId > 0L ? 1 : 0) != 0, (Object)"room id is invalid");
        StringUtils.checkUsername(ownerUsername);
        Preconditions.checkArgument((null != name ? 1 : 0) != 0, (Object)"Chat room name is null");
        Preconditions.checkArgument((null != desc ? 1 : 0) != 0, (Object)"Description is null");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("owner_username", ownerUsername);
        jsonObject.addProperty("name", name);
        jsonObject.addProperty("description", desc);
        return this._httpClient.sendPut(this._baseUrl + this.mChatRoomPath + "/" + roomId, this._gson.toJson((JsonElement)jsonObject));
    }

    public ResponseWrapper deleteChatRoom(long roomId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((roomId > 0L ? 1 : 0) != 0, (Object)"room id is invalid");
        return this._httpClient.sendDelete(this._baseUrl + this.mChatRoomPath + "/" + roomId);
    }

    public ResponseWrapper updateUserSpeakStatus(long roomId, String username, int flag) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((roomId > 0L ? 1 : 0) != 0, (Object)"room id is invalid");
        StringUtils.checkUsername(username);
        Preconditions.checkArgument((flag == 0 || flag == 1 ? 1 : 0) != 0, (Object)"flag should be 0 or 1");
        return this._httpClient.sendPut(this._baseUrl + this.mChatRoomPath + "/" + roomId + "/forbidden/" + username + "?status=" + flag, null);
    }

    public ChatRoomMemberList getChatRoomMembers(long roomId, int start, int count) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((roomId > 0L ? 1 : 0) != 0, (Object)"room id is invalid");
        Preconditions.checkArgument((start >= 0 && count > 0 ? 1 : 0) != 0, (Object)"Illegal argument");
        ResponseWrapper responseWrapper = this._httpClient.sendGet(this._baseUrl + this.mChatRoomPath + "/" + roomId + "/members" + "?start=" + start + "&count=" + count);
        return (ChatRoomMemberList)ChatRoomMemberList.fromResponse((ResponseWrapper)responseWrapper, ChatRoomMemberList.class);
    }

    public ResponseWrapper addChatRoomMember(long roomId, String ... members) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((roomId > 0L ? 1 : 0) != 0, (Object)"room id is invalid");
        Preconditions.checkArgument((members != null && members.length > 0 ? 1 : 0) != 0, (Object)"member should not be empty");
        JsonArray array = new JsonArray();
        for (String username : members) {
            array.add((JsonElement)new JsonPrimitive(username));
        }
        return this._httpClient.sendPut(this._baseUrl + this.mChatRoomPath + "/" + roomId + "/members", array.toString());
    }

    public ResponseWrapper addChatRoomMember(long roomId, Members members) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((roomId > 0L ? 1 : 0) != 0, (Object)"room id is invalid");
        Preconditions.checkArgument((members != null ? 1 : 0) != 0, (Object)"members should not be empty");
        return this._httpClient.sendPut(this._baseUrl + this.mChatRoomPath + "/" + roomId + "/members", members.toString());
    }

    public ResponseWrapper removeChatRoomMembers(long roomId, String ... members) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((roomId > 0L ? 1 : 0) != 0, (Object)"room id is invalid");
        Preconditions.checkArgument((members != null && members.length > 0 ? 1 : 0) != 0, (Object)"member should not be empty");
        JsonArray array = new JsonArray();
        for (String username : members) {
            array.add((JsonElement)new JsonPrimitive(username));
        }
        return this._httpClient.sendDelete(this._baseUrl + this.mChatRoomPath + "/" + roomId + "/members", array.toString());
    }

    public ResponseWrapper removeChatRoomMembers(long roomId, Members members) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((roomId > 0L ? 1 : 0) != 0, (Object)"room id is invalid");
        Preconditions.checkArgument((members != null ? 1 : 0) != 0, (Object)"members should not be empty");
        return this._httpClient.sendDelete(this._baseUrl + this.mChatRoomPath + "/" + roomId + "/members", members.toString());
    }
}

