/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.common.model;

import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jmessage.api.common.model.IModel;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

public class UserPayload
implements IModel {
    public static final String NICKNAME = "nickname";
    public static final String BIRTHDAY = "birthday";
    public static final String SIGNATURE = "signature";
    public static final String GENDER = "gender";
    public static final String REGION = "region";
    public static final String ADDRESS = "address";
    public static final String AVATAR = "avatar";
    private static final String EXTRAS = "extras";
    private static Gson _gson = new Gson();
    private String nickname;
    private String birthday;
    private String signature;
    private int gender;
    private String region;
    private String address;
    private String avatar;
    private final Map<String, String> extras;
    private final Map<String, Number> numberExtras;
    private final Map<String, Boolean> booleanExtras;
    private final Map<String, JsonObject> jsonExtras;

    private UserPayload(String nickname, String birthday, String signature, int gender, String region, String address, String avatar, Map<String, String> extras, Map<String, Number> numberExtras, Map<String, Boolean> booleanExtras, Map<String, JsonObject> jsonExtras) {
        this.nickname = nickname;
        this.birthday = birthday;
        this.signature = signature;
        this.gender = gender;
        this.region = region;
        this.address = address;
        this.avatar = avatar;
        this.extras = extras;
        this.numberExtras = numberExtras;
        this.booleanExtras = booleanExtras;
        this.jsonExtras = jsonExtras;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.nickname) {
            json.addProperty(NICKNAME, this.nickname);
        }
        if (null != this.birthday) {
            json.addProperty(BIRTHDAY, this.birthday);
        }
        if (-1 != this.gender) {
            json.addProperty(GENDER, (Number)this.gender);
        }
        if (null != this.signature) {
            json.addProperty(SIGNATURE, this.signature);
        }
        if (null != this.region) {
            json.addProperty(REGION, this.region);
        }
        if (null != this.address) {
            json.addProperty(ADDRESS, this.address);
        }
        if (null != this.avatar) {
            json.addProperty(AVATAR, this.avatar);
        }
        JsonObject extrasObject = null;
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras) {
            extrasObject = new JsonObject();
        }
        if (null != this.extras) {
            for (String key : this.extras.keySet()) {
                if (this.extras.get(key) != null) {
                    extrasObject.add(key, (JsonElement)new JsonPrimitive(this.extras.get(key)));
                    continue;
                }
                extrasObject.add(key, (JsonElement)JsonNull.INSTANCE);
            }
        }
        if (null != this.numberExtras) {
            for (String key : this.numberExtras.keySet()) {
                extrasObject.add(key, (JsonElement)new JsonPrimitive(this.numberExtras.get(key)));
            }
        }
        if (null != this.booleanExtras) {
            for (String key : this.booleanExtras.keySet()) {
                extrasObject.add(key, (JsonElement)new JsonPrimitive(this.booleanExtras.get(key)));
            }
        }
        if (null != this.jsonExtras) {
            for (String key : this.jsonExtras.keySet()) {
                extrasObject.add(key, (JsonElement)this.jsonExtras.get(key));
            }
        }
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras) {
            json.add(EXTRAS, (JsonElement)extrasObject);
        }
        return json;
    }

    public String toString() {
        return _gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String nickname;
        private String birthday;
        private String signature;
        private int gender = -1;
        private String region;
        private String address;
        private String avatar;
        private Map<String, String> extrasBuilder;
        private Map<String, Number> numberExtrasBuilder;
        private Map<String, Boolean> booleanExtrasBuilder;
        protected Map<String, JsonObject> jsonExtrasBuilder;

        public Builder setNickname(String nickname) {
            this.nickname = nickname;
            return this;
        }

        public Builder setBirthday(String birthday) {
            this.birthday = birthday;
            return this;
        }

        public Builder setSignature(String signature) {
            this.signature = signature;
            return this;
        }

        public Builder setGender(int gender) {
            this.gender = gender;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public Builder setAvatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public Builder addExtra(String key, String value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap<String, String>();
            }
            this.extrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtras(Map<String, String> extras) {
            Preconditions.checkArgument((null != extras ? 1 : 0) != 0, (Object)"extras should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap<String, String>();
            }
            for (String key : extras.keySet()) {
                this.extrasBuilder.put(key, extras.get(key));
            }
            return this;
        }

        public Builder addExtra(String key, Number value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.numberExtrasBuilder) {
                this.numberExtrasBuilder = new HashMap<String, Number>();
            }
            this.numberExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtra(String key, Boolean value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.booleanExtrasBuilder) {
                this.booleanExtrasBuilder = new HashMap<String, Boolean>();
            }
            this.booleanExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtra(String key, JsonObject value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.jsonExtrasBuilder) {
                this.jsonExtrasBuilder = new HashMap<String, JsonObject>();
            }
            this.jsonExtrasBuilder.put(key, value);
            return this;
        }

        public UserPayload build() {
            if (null != this.nickname) {
                Preconditions.checkArgument((this.nickname.getBytes().length <= 64 ? 1 : 0) != 0, (Object)"The length of nickname must less than 64 bytes.");
                Preconditions.checkArgument((!StringUtils.isLineBroken((String)this.nickname) ? 1 : 0) != 0, (Object)"The nickname must not contain line feed character.");
            }
            if (null != this.birthday) {
                Preconditions.checkArgument((boolean)ServiceHelper.isValidBirthday((String)this.birthday), (Object)"Invalid birthday.");
            }
            if (null != this.signature) {
                Preconditions.checkArgument((this.signature.getBytes().length <= 250 ? 1 : 0) != 0, (Object)"The length of signature must not more than 250 bytes.");
            }
            Preconditions.checkArgument((this.gender >= -1 && this.gender <= 2 ? 1 : 0) != 0, (Object)"Invalid gender. 0 for unknown , 1 for male and 2 for female.");
            if (null != this.region) {
                Preconditions.checkArgument((this.region.getBytes().length <= 250 ? 1 : 0) != 0, (Object)"The length of region must not more than 250 bytes.");
            }
            if (null != this.address) {
                Preconditions.checkArgument((this.address.getBytes().length <= 250 ? 1 : 0) != 0, (Object)"The length of address must not more than 250 bytes.");
            }
            return new UserPayload(this.nickname, this.birthday, this.signature, this.gender, this.region, this.address, this.avatar, this.extrasBuilder, this.numberExtrasBuilder, this.booleanExtrasBuilder, this.jsonExtrasBuilder);
        }
    }
}

