/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.common.model.cross;

import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.model.IModel;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class CrossNoDisturb
implements IModel {
    private static String APP_KEY = "appkey";
    private static String SINGLE = "single";
    private static String ADD = "add";
    private static String REMOVE = "remove";
    private static String GROUP = "group";
    private static Gson gson = new Gson();
    private String appKey;
    private String[] add_single_users;
    private String[] remove_single_users;
    private Long[] add_group_ids;
    private Long[] remove_group_ids;

    private CrossNoDisturb(String appKey, String[] add_single_users, String[] remove_single_users, Long[] add_group_ids, Long[] remove_group_ids) {
        this.appKey = appKey;
        this.add_single_users = add_single_users;
        this.remove_single_users = remove_single_users;
        this.add_group_ids = add_group_ids;
        this.remove_group_ids = remove_group_ids;
    }

    @Override
    public JsonElement toJSON() {
        JsonArray jsonArray1;
        JsonArray jsonArray;
        JsonObject jsonObject;
        JsonObject json = new JsonObject();
        if (null != this.appKey) {
            json.addProperty(APP_KEY, this.appKey);
        }
        if (null != this.add_single_users) {
            jsonObject = new JsonObject();
            jsonArray = new JsonArray();
            for (String username : this.add_single_users) {
                jsonArray.add((JsonElement)new JsonPrimitive(username));
            }
            jsonObject.add(ADD, (JsonElement)jsonArray);
            if (null != this.remove_single_users) {
                jsonArray1 = new JsonArray();
                for (String username : this.remove_single_users) {
                    jsonArray1.add((JsonElement)new JsonPrimitive(username));
                }
                jsonObject.add(REMOVE, (JsonElement)jsonArray1);
            }
            json.add(SINGLE, (JsonElement)jsonObject);
        } else if (null != this.remove_single_users) {
            jsonObject = new JsonObject();
            jsonArray = new JsonArray();
            for (String username : this.remove_single_users) {
                jsonArray.add((JsonElement)new JsonPrimitive(username));
            }
            jsonObject.add(REMOVE, (JsonElement)jsonArray);
            json.add(SINGLE, (JsonElement)jsonObject);
        }
        if (null != this.add_group_ids) {
            jsonObject = new JsonObject();
            jsonArray = new JsonArray();
            for (Long groupId : this.add_group_ids) {
                jsonArray.add((JsonElement)new JsonPrimitive((Number)groupId));
            }
            jsonObject.add(ADD, (JsonElement)jsonArray);
            if (null != this.remove_group_ids) {
                jsonArray1 = new JsonArray();
                for (Long groupId : this.remove_group_ids) {
                    jsonArray1.add((JsonElement)new JsonPrimitive((Number)groupId));
                }
                jsonObject.add(REMOVE, (JsonElement)jsonArray1);
            }
            json.add(GROUP, (JsonElement)jsonObject);
        } else if (null != this.remove_group_ids) {
            jsonObject = new JsonObject();
            jsonArray = new JsonArray();
            for (Long groupId : this.remove_group_ids) {
                jsonArray.add((JsonElement)new JsonPrimitive((Number)groupId));
            }
            jsonObject.add(REMOVE, (JsonElement)jsonArray);
            json.add(GROUP, (JsonElement)jsonObject);
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String appKey;
        private String[] add_single_users;
        private String[] remove_single_users;
        private Long[] add_group_ids;
        private Long[] remove_group_ids;
        private int global = 0;

        public Builder setAppKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder setAddSingleUsers(String ... add_single_users) {
            this.add_single_users = add_single_users;
            return this;
        }

        public Builder setRemoveSingleUsers(String ... remove_single_users) {
            this.remove_single_users = remove_single_users;
            return this;
        }

        public Builder setAddGroupIds(Long ... add_group_ids) {
            this.add_group_ids = add_group_ids;
            return this;
        }

        public Builder setRemoveGroupIds(Long ... remove_group_ids) {
            this.remove_group_ids = remove_group_ids;
            return this;
        }

        public Builder setGlobal(int global) {
            this.global = global;
            return this;
        }

        public CrossNoDisturb build() {
            Preconditions.checkArgument((null != this.appKey ? 1 : 0) != 0, (Object)"appkey must not be null");
            return new CrossNoDisturb(this.appKey, this.add_single_users, this.remove_single_users, this.add_group_ids, this.remove_group_ids);
        }
    }
}

