/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.common.model.group;

import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.model.IModel;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;

public class GroupShieldPayload
implements IModel {
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private static final Gson gson = new Gson();
    private List<Long> addList;
    private List<Long> removeList;

    public GroupShieldPayload(List<Long> addList, List<Long> removeList) {
        this.addList = addList;
        this.removeList = removeList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonArray jsonArray;
        JsonObject jsonObject = new JsonObject();
        if (null != this.addList && this.addList.size() > 0) {
            jsonArray = new JsonArray();
            for (long id : this.addList) {
                jsonArray.add((JsonElement)new JsonPrimitive((Number)id));
            }
            jsonObject.add(ADD, (JsonElement)jsonArray);
        }
        if (null != this.removeList && this.removeList.size() > 0) {
            jsonArray = new JsonArray();
            for (long id : this.removeList) {
                jsonArray.add((JsonElement)new JsonPrimitive((Number)id));
            }
            jsonObject.add(REMOVE, (JsonElement)jsonArray);
        }
        return jsonObject;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private List<Long> addList = new ArrayList<Long>();
        private List<Long> removeList = new ArrayList<Long>();

        public Builder addGroupShield(Long ... gid) {
            Long[] arr$ = gid;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                long id = arr$[i$];
                this.addList.add(id);
            }
            return this;
        }

        public Builder setAddGroupShield(List<Long> list) {
            Preconditions.checkArgument((null != list ? 1 : 0) != 0, (Object)"group id list is null");
            this.addList = list;
            return this;
        }

        public Builder removeGroupShield(long ... ids) {
            for (long id : ids) {
                this.removeList.add(id);
            }
            return this;
        }

        public Builder setRemoveGroupShield(List<Long> list) {
            Preconditions.checkArgument((null != list ? 1 : 0) != 0, (Object)"group id list is null");
            this.removeList = list;
            return this;
        }

        public GroupShieldPayload build() {
            return new GroupShieldPayload(this.addList, this.removeList);
        }
    }
}

