/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.common.model.cross;

import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.model.IModel;
import cn.jmessage.api.common.model.cross.CrossBlacklist;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;

public class CrossBlacklistPayload
implements IModel {
    private static Gson gson = new Gson();
    private JsonArray array;

    private CrossBlacklistPayload(JsonArray array) {
        this.array = array;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        return this.array;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private JsonArray array = new JsonArray();

        public Builder setCrossBlacklists(CrossBlacklist ... blacklists) {
            if (null == blacklists) {
                return this;
            }
            for (CrossBlacklist blacklist : blacklists) {
                this.array.add(blacklist.toJSON());
            }
            return this;
        }

        public CrossBlacklistPayload build() {
            Preconditions.checkArgument((0 != this.array.size() ? 1 : 0) != 0, (Object)"The array must not be empty.");
            Preconditions.checkArgument((this.array.size() <= 500 ? 1 : 0) != 0, (Object)"The array size must not over 500");
            return new CrossBlacklistPayload(this.array);
        }
    }
}

