/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.common.model.message;

import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.model.IModel;
import cn.jmessage.api.common.model.message.MessageBody;
import cn.jmessage.api.common.model.message.Notification;
import cn.jmessage.api.message.MessageType;
import cn.jmessage.api.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class MessagePayload
implements IModel {
    private static final String VERSION = "version";
    private static final String TARGET_TYPE = "target_type";
    private static final String FROM_TYPE = "from_type";
    private static final String MSG_TYPE = "msg_type";
    private static final String TARGET_ID = "target_id";
    private static final String FROM_ID = "from_id";
    private static final String TARGET_APP_KEY = "target_appkey";
    private static final String FROM_NAME = "from_name";
    private static final String TARGET_NAME = "target_name";
    private static final String MSG_BODY = "msg_body";
    private static final String NO_OFFLINE = "no_offline";
    private static final String NO_NOTIFICATION = "no_notification";
    private static final String NOTIFICATION = "notification";
    private static Gson gson = new Gson();
    private Integer mVersion;
    private String mTargetType;
    private String mTargetId;
    private String mFromType;
    private String mFromId;
    private String mTargetAppKey;
    private String mFromName;
    private String mTargetName;
    private boolean mNoOffline = false;
    private boolean mNoNotification = false;
    private MessageType mMsgType;
    private MessageBody mMsgBody;
    private Notification mNotification;

    public MessagePayload(Integer version, String targetType, String targetId, String fromType, String fromId, String targetAppKey, String fromName, String targetName, boolean noOffline, boolean noNotification, MessageType msgType, MessageBody msgBody, Notification notification) {
        this.mVersion = version;
        this.mTargetType = targetType;
        this.mTargetId = targetId;
        this.mFromType = fromType;
        this.mFromId = fromId;
        this.mTargetAppKey = targetAppKey;
        this.mFromName = fromName;
        this.mTargetName = targetName;
        this.mNoOffline = noOffline;
        this.mNoNotification = noNotification;
        this.mMsgType = msgType;
        this.mMsgBody = msgBody;
        this.mNotification = notification;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.mVersion) {
            json.addProperty(VERSION, (Number)this.mVersion);
        }
        if (null != this.mTargetType) {
            json.addProperty(TARGET_TYPE, this.mTargetType);
        }
        if (null != this.mTargetId) {
            json.addProperty(TARGET_ID, this.mTargetId);
        }
        if (null != this.mFromType) {
            json.addProperty(FROM_TYPE, this.mFromType);
        }
        if (null != this.mFromId) {
            json.addProperty(FROM_ID, this.mFromId);
        }
        if (null != this.mTargetAppKey) {
            json.addProperty(TARGET_APP_KEY, this.mTargetAppKey);
        }
        if (null != this.mFromName) {
            json.addProperty(FROM_NAME, this.mFromName);
        }
        if (null != this.mTargetName) {
            json.addProperty(TARGET_NAME, this.mTargetName);
        }
        if (this.mNoOffline) {
            json.addProperty(NO_OFFLINE, Boolean.valueOf(this.mNoOffline));
        }
        if (this.mNoNotification) {
            json.addProperty(NO_NOTIFICATION, Boolean.valueOf(this.mNoNotification));
        }
        if (null != this.mMsgType) {
            json.addProperty(MSG_TYPE, this.mMsgType.getValue());
        }
        if (null != this.mMsgBody) {
            json.add(MSG_BODY, this.mMsgBody.toJSON());
        }
        if (null != this.mNotification) {
            json.add(NOTIFICATION, this.mNotification.toJSON());
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private Integer mVersion;
        private String mTargetType;
        private String mTargetId;
        private String mFromType;
        private String mFromId;
        private String mTargetAppKey;
        private String mFromName;
        private String mTargetName;
        private boolean mNoOffline = false;
        private boolean mNoNotification = false;
        private MessageType mMsgType;
        private MessageBody mMsgBody;
        private Notification mNotification;

        public Builder setVersion(Integer version) {
            this.mVersion = version;
            return this;
        }

        public Builder setTargetType(String targetType) {
            this.mTargetType = targetType.trim();
            return this;
        }

        public Builder setTargetId(String targetId) {
            this.mTargetId = targetId.trim();
            return this;
        }

        public Builder setFromType(String fromType) {
            this.mFromType = fromType.trim();
            return this;
        }

        public Builder setFromId(String fromId) {
            this.mFromId = fromId.trim();
            return this;
        }

        public Builder setTargetAppKey(String appKey) {
            this.mTargetAppKey = appKey;
            return this;
        }

        public Builder setFromName(String name) {
            this.mFromName = name;
            return this;
        }

        public Builder setTargetName(String name) {
            this.mTargetName = name;
            return this;
        }

        public Builder setNoOffline(boolean noOffline) {
            this.mNoOffline = noOffline;
            return this;
        }

        public Builder setNoNotification(boolean noNotification) {
            this.mNoNotification = noNotification;
            return this;
        }

        public Builder setMessageType(MessageType msgType) {
            this.mMsgType = msgType;
            return this;
        }

        public Builder setMessageBody(MessageBody msgBody) {
            this.mMsgBody = msgBody;
            return this;
        }

        public Builder setNotification(Notification notification) {
            this.mNotification = notification;
            return this;
        }

        public MessagePayload build() {
            Preconditions.checkArgument((null != this.mVersion ? 1 : 0) != 0, (Object)"The version must not be empty!");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(this.mTargetType), (Object)"The target type must not be empty!");
            StringUtils.checkUsername(this.mTargetId);
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(this.mFromType), (Object)"The from type must not be empty!");
            StringUtils.checkUsername(this.mFromId);
            Preconditions.checkArgument((this.mMsgType != null ? 1 : 0) != 0, (Object)"The message type must not be empty!");
            Preconditions.checkArgument((null != this.mMsgBody ? 1 : 0) != 0, (Object)"The message body must not be empty!");
            return new MessagePayload(this.mVersion, this.mTargetType, this.mTargetId, this.mFromType, this.mFromId, this.mTargetAppKey, this.mFromName, this.mTargetName, this.mNoOffline, this.mNoNotification, this.mMsgType, this.mMsgBody, this.mNotification);
        }
    }
}

