/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.reportv2;

import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.BaseClient;
import cn.jmessage.api.common.JMessageConfig;
import cn.jmessage.api.message.MessageListResult;
import cn.jmessage.api.reportv2.GroupStatListResult;
import cn.jmessage.api.reportv2.MessageStatListResult;
import cn.jmessage.api.reportv2.UserStatListResult;
import cn.jmessage.api.utils.StringUtils;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ReportClient
extends BaseClient {
    private String mBaseReportPath;
    private String mV2MessagePath;
    private String mV2UserPath;
    private String mV2GroupPath;
    private String mV2StatisticPath;

    public ReportClient(String appKey, String masterSecret) {
        this(appKey, masterSecret, null, JMessageConfig.getInstance());
    }

    public ReportClient(String appKey, String masterSecret, HttpProxy proxy) {
        this(appKey, masterSecret, proxy, JMessageConfig.getInstance());
    }

    public ReportClient(String appKey, String masterSecret, HttpProxy proxy, JMessageConfig config) {
        super(appKey, masterSecret, proxy, config);
        this.mBaseReportPath = (String)config.get("im.api.report.host.name");
        this.mV2MessagePath = (String)config.get("im.v2.message.path");
        this.mV2UserPath = (String)config.get("im.v2.user.path");
        this.mV2GroupPath = (String)config.get("im.v2.group.path");
        this.mV2StatisticPath = (String)config.get("im.v2.statistic.path");
    }

    public MessageListResult v2GetMessageList(int count, String begin_time, String end_time) throws APIConnectionException, APIRequestException {
        if (count <= 0 || count > 1000) {
            throw new IllegalArgumentException("count must more than 0 and less than 1001");
        }
        String requestUrl = this.mBaseReportPath + this.mV2MessagePath + "?count=" + count;
        String beginEncoded = null;
        String endEncoded = null;
        if (null != begin_time && StringUtils.isNotEmpty(begin_time) && null != end_time && StringUtils.isNotEmpty(end_time)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date beginDate = format.parse(begin_time);
                Date endDate = format.parse(end_time);
                if (endDate.getTime() - beginDate.getTime() < 0L) {
                    throw new IllegalArgumentException("end time must lager than begin time");
                }
                if (endDate.getTime() - beginDate.getTime() > 604800000L) {
                    throw new IllegalArgumentException("end time lager than begin time over 7 days");
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            try {
                beginEncoded = URLEncoder.encode(begin_time, "utf-8");
                endEncoded = URLEncoder.encode(end_time, "utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("begin time or end time is null or empty");
        }
        requestUrl = requestUrl + "&begin_time=" + beginEncoded + "&end_time=" + endEncoded;
        ResponseWrapper response = this._httpClient.sendGet(requestUrl);
        return (MessageListResult)MessageListResult.fromResponse((ResponseWrapper)response, MessageListResult.class);
    }

    public MessageListResult v2GetMessageListByCursor(String cursor) throws APIConnectionException, APIRequestException {
        if (null != cursor) {
            String requestUrl = this.mBaseReportPath + this.mV2MessagePath + "?cursor=" + cursor;
            ResponseWrapper response = this._httpClient.sendGet(requestUrl);
            return (MessageListResult)MessageListResult.fromResponse((ResponseWrapper)response, MessageListResult.class);
        }
        throw new IllegalArgumentException("the cursor parameter should not be null");
    }

    public MessageListResult v2GetUserMessages(String username, int count, String begin_time, String end_time) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        if (count <= 0 || count > 1000) {
            throw new IllegalArgumentException("count must more than 0 and less than 1001");
        }
        String requestUrl = this.mBaseReportPath + this.mV2UserPath + "/" + username + "/messages?count=" + count;
        String beginEncoded = null;
        String endEncoded = null;
        if (null != begin_time && StringUtils.isNotEmpty(begin_time) && null != end_time && StringUtils.isNotEmpty(end_time)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date beginDate = format.parse(begin_time);
                Date endDate = format.parse(end_time);
                if (endDate.getTime() - beginDate.getTime() < 0L) {
                    throw new IllegalArgumentException("end time must lager than begin time");
                }
                if (endDate.getTime() - beginDate.getTime() > 604800000L) {
                    throw new IllegalArgumentException("end time lager than begin time over 7 days");
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            try {
                beginEncoded = URLEncoder.encode(begin_time, "utf-8");
                endEncoded = URLEncoder.encode(end_time, "utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("begin time or end time is null or empty");
        }
        requestUrl = requestUrl + "&begin_time=" + beginEncoded + "&end_time=" + endEncoded;
        ResponseWrapper response = this._httpClient.sendGet(requestUrl);
        return (MessageListResult)MessageListResult.fromResponse((ResponseWrapper)response, MessageListResult.class);
    }

    public MessageListResult v2GetUserMessagesByCursor(String username, String cursor) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        if (null != cursor) {
            String requestUrl = this.mBaseReportPath + this.mV2UserPath + "/" + username + "/messages?cursor=" + cursor;
            ResponseWrapper response = this._httpClient.sendGet(requestUrl);
            return (MessageListResult)MessageListResult.fromResponse((ResponseWrapper)response, MessageListResult.class);
        }
        throw new IllegalArgumentException("the cursor parameter should not be null");
    }

    public MessageListResult v2GetGroupMessageList(long groupId, int count, String begin_time, String end_time) throws APIConnectionException, APIRequestException {
        if (count <= 0 || count > 1000) {
            throw new IllegalArgumentException("count must more than 0 and less than 1001");
        }
        String requestUrl = this.mBaseReportPath + this.mV2GroupPath + "/" + groupId + "/messages?count=" + count;
        String beginEncoded = null;
        String endEncoded = null;
        if (null != begin_time && StringUtils.isNotEmpty(begin_time) && null != end_time && StringUtils.isNotEmpty(end_time)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date beginDate = format.parse(begin_time);
                Date endDate = format.parse(end_time);
                if (endDate.getTime() - beginDate.getTime() < 0L) {
                    throw new IllegalArgumentException("end time must lager than begin time");
                }
                if (endDate.getTime() - beginDate.getTime() > 604800000L) {
                    throw new IllegalArgumentException("end time lager than begin time over 7 days");
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            try {
                beginEncoded = URLEncoder.encode(begin_time, "utf-8");
                endEncoded = URLEncoder.encode(end_time, "utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("begin time or end time is null or empty");
        }
        requestUrl = requestUrl + "&begin_time=" + beginEncoded + "&end_time=" + endEncoded;
        ResponseWrapper response = this._httpClient.sendGet(requestUrl);
        return (MessageListResult)MessageListResult.fromResponse((ResponseWrapper)response, MessageListResult.class);
    }

    public UserStatListResult getUserStatistic(String startTime, int duration) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((boolean)this.verifyDateFormat("DAY", startTime), (Object)"Illegal date format");
        Preconditions.checkArgument((0 <= duration && duration <= 60 ? 1 : 0) != 0, (Object)" 0 <= duration <= 60");
        String url = this.mBaseReportPath + this.mV2StatisticPath + "/users?time_unit=DAY&start=" + startTime + "&duration=" + duration;
        ResponseWrapper responseWrapper = this._httpClient.sendGet(url);
        return UserStatListResult.fromResponse(responseWrapper);
    }

    public MessageStatListResult getMessageStatistic(String timeUnit, String start, int duration) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((boolean)this.verifyDateFormat(timeUnit, start), (Object)"Time format error, please check your argument");
        if (timeUnit.equals("HOUR")) {
            Preconditions.checkArgument((0 <= duration && duration <= 24 ? 1 : 0) != 0, (Object)"time unit is HOUR, duration must between 0 and 24 ");
        } else if (timeUnit.equals("DAY")) {
            Preconditions.checkArgument((0 <= duration && duration <= 60 ? 1 : 0) != 0, (Object)"time unit is DAY, duration must between 0 and 60");
        } else if (timeUnit.equals("MONTH")) {
            Preconditions.checkArgument((0 <= duration && duration <= 2 ? 1 : 0) != 0, (Object)"time unit is MONTH, duration must between 0 and 2");
        } else {
            throw new IllegalArgumentException("Time unit error");
        }
        String url = this.mBaseReportPath + this.mV2StatisticPath + "/messages?time_unit=" + timeUnit + "&start=" + start + "&duration=" + duration;
        ResponseWrapper responseWrapper = this._httpClient.sendGet(url);
        return (MessageStatListResult)MessageStatListResult.fromResponse((ResponseWrapper)responseWrapper, MessageStatListResult.class);
    }

    public GroupStatListResult getGroupStatistic(String start, int duration) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((boolean)this.verifyDateFormat("DAY", start), (Object)"Illegal date format");
        Preconditions.checkArgument((0 <= duration && duration <= 60 ? 1 : 0) != 0, (Object)" 0 <= duration <= 60");
        String url = this.mBaseReportPath + this.mV2StatisticPath + "/groups?time_unit=DAY&start=" + start + "&duration=" + duration;
        ResponseWrapper responseWrapper = this._httpClient.sendGet(url);
        return GroupStatListResult.fromResponse(responseWrapper);
    }

    private boolean verifyDateFormat(String timeUnit, String formatStr) {
        try {
            String format = timeUnit.equals("HOUR") ? "yyyy-MM-dd HH" : (timeUnit.equals("DAY") ? "yyyy-MM-dd" : "yyyy-MM");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
            simpleDateFormat.parse(formatStr);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }
}

