/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.factory;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.face.config.FaceRecConfig;
import cn.smartjavaai.face.enums.FaceRecModelEnum;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.model.facerec.CommonFaceRecModel;
import cn.smartjavaai.face.model.facerec.FaceRecModel;
import cn.smartjavaai.face.model.facerec.SeetaFace6FaceRecModel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceRecModelFactory {
    private static final Logger log = LoggerFactory.getLogger(FaceRecModelFactory.class);
    private static volatile FaceRecModelFactory instance;
    private static final ConcurrentHashMap<FaceRecModelEnum, FaceRecModel> modelMap;
    private static final Map<FaceRecModelEnum, Class<? extends FaceRecModel>> registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FaceRecModelFactory getInstance() {
        if (instance != null) return instance;
        Class<FaceRecModelFactory> clazz = FaceRecModelFactory.class;
        synchronized (FaceRecModelFactory.class) {
            if (instance != null) return instance;
            instance = new FaceRecModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void registerAlgorithm(FaceRecModelEnum recModelEnum, Class<? extends FaceRecModel> clazz) {
        registry.put(recModelEnum, clazz);
    }

    public FaceRecModel getModel(FaceRecConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new FaceException("\u672a\u914d\u7f6e\u4eba\u8138\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum(), k -> this.createFaceModel(config));
    }

    private FaceRecModel createFaceModel(FaceRecConfig config) {
        Class<? extends FaceRecModel> clazz = registry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new FaceException("Unsupported model");
        }
        FaceRecModel algorithm = null;
        try {
            algorithm = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new FaceException(e);
        }
        algorithm.loadModel(config);
        return algorithm;
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<FaceRecModelEnum, Class<? extends FaceRecModel>>();
        FaceRecModelFactory.registerAlgorithm(FaceRecModelEnum.FACENET_MODEL, CommonFaceRecModel.class);
        FaceRecModelFactory.registerAlgorithm(FaceRecModelEnum.INSIGHT_FACE_IRSE50_MODEL, CommonFaceRecModel.class);
        FaceRecModelFactory.registerAlgorithm(FaceRecModelEnum.INSIGHT_FACE_MOBILE_FACENET_MODEL, CommonFaceRecModel.class);
        FaceRecModelFactory.registerAlgorithm(FaceRecModelEnum.ELASTIC_FACE_MODEL, CommonFaceRecModel.class);
        FaceRecModelFactory.registerAlgorithm(FaceRecModelEnum.SEETA_FACE6_MODEL, SeetaFace6FaceRecModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

