/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.attribute;

import cn.smartjavaai.common.entity.DetectionInfo;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.entity.Point;
import cn.smartjavaai.common.entity.face.FaceAttribute;
import cn.smartjavaai.common.entity.face.FaceInfo;
import cn.smartjavaai.common.entity.face.HeadPose;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.common.enums.face.EyeStatus;
import cn.smartjavaai.common.enums.face.GenderType;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.common.utils.PoolUtils;
import cn.smartjavaai.face.config.FaceAttributeConfig;
import cn.smartjavaai.face.context.PredictorContext;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.model.attribute.FaceAttributeModel;
import cn.smartjavaai.face.seetaface.NativeLoader;
import cn.smartjavaai.face.utils.FaceUtils;
import com.seeta.pool.AgePredictorPool;
import com.seeta.pool.EyeStateDetectorPool;
import com.seeta.pool.FaceDetectorPool;
import com.seeta.pool.FaceLandmarkerPool;
import com.seeta.pool.GenderPredictorPool;
import com.seeta.pool.MaskDetectorPool;
import com.seeta.pool.PoseEstimatorPool;
import com.seeta.pool.SeetaConfSetting;
import com.seeta.sdk.AgePredictor;
import com.seeta.sdk.EyeStateDetector;
import com.seeta.sdk.FaceDetector;
import com.seeta.sdk.FaceLandmarker;
import com.seeta.sdk.GenderPredictor;
import com.seeta.sdk.MaskDetector;
import com.seeta.sdk.PoseEstimator;
import com.seeta.sdk.SeetaDevice;
import com.seeta.sdk.SeetaImageData;
import com.seeta.sdk.SeetaModelSetting;
import com.seeta.sdk.SeetaPointF;
import com.seeta.sdk.SeetaRect;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.ObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Seetaface6FaceAttributeModel
implements FaceAttributeModel {
    private static final Logger log = LoggerFactory.getLogger(Seetaface6FaceAttributeModel.class);
    private FaceDetectorPool faceDetectorPool;
    private GenderPredictorPool genderPredictorPool;
    private FaceLandmarkerPool faceLandmarkerPool;
    private AgePredictorPool agePredictorPool;
    private EyeStateDetectorPool eyeStateDetectorPool;
    private MaskDetectorPool maskDetectorPool;
    private PoseEstimatorPool poseEstimatorPool;
    private FaceAttributeConfig config;

    @Override
    public void loadModel(FaceAttributeConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new FaceException("modelPath is null");
        }
        this.config = config;
        NativeLoader.loadNativeLibraries(config.getDevice());
        log.debug("Loading seetaFace6 library successfully.");
        String[] faceDetectorModelPath = new String[]{config.getModelPath() + File.separator + "face_detector.csta"};
        String[] faceLandmarkerModelPath = new String[]{config.getModelPath() + File.separator + "face_landmarker_pts5.csta"};
        String[] genderPredictorModelPath = new String[]{config.getModelPath() + File.separator + "gender_predictor.csta"};
        String[] agePredictorModelPath = new String[]{config.getModelPath() + File.separator + "age_predictor.csta"};
        String[] eyeStateDetectorModelPath = new String[]{config.getModelPath() + File.separator + "eye_state.csta"};
        String[] maskDetectorModelPath = new String[]{config.getModelPath() + File.separator + "mask_detector.csta"};
        String[] poseEstimatorModelPath = new String[]{config.getModelPath() + File.separator + "pose_estimation.csta"};
        SeetaDevice device = SeetaDevice.SEETA_DEVICE_AUTO;
        int gpuId = 0;
        if (Objects.nonNull(config.getDevice())) {
            SeetaDevice seetaDevice = device = config.getDevice() == DeviceEnum.CPU ? SeetaDevice.SEETA_DEVICE_CPU : SeetaDevice.SEETA_DEVICE_GPU;
            if (config.getGpuId() >= 0 && device == SeetaDevice.SEETA_DEVICE_GPU) {
                gpuId = config.getGpuId();
            }
        }
        try {
            SeetaModelSetting faceDetectorPoolSetting = new SeetaModelSetting(gpuId, faceDetectorModelPath, device);
            SeetaConfSetting faceDetectorPoolConfSetting = new SeetaConfSetting(faceDetectorPoolSetting);
            SeetaModelSetting faceLandmarkerPoolSetting = new SeetaModelSetting(gpuId, faceLandmarkerModelPath, device);
            SeetaConfSetting faceLandmarkerPoolConfSetting = new SeetaConfSetting(faceLandmarkerPoolSetting);
            SeetaModelSetting genderPredictorPoolSetting = new SeetaModelSetting(gpuId, genderPredictorModelPath, device);
            SeetaConfSetting genderPredictorPoolConfSetting = new SeetaConfSetting(genderPredictorPoolSetting);
            SeetaModelSetting agePredictorPoolSetting = new SeetaModelSetting(gpuId, agePredictorModelPath, device);
            SeetaConfSetting agePredictorPoolConfSetting = new SeetaConfSetting(agePredictorPoolSetting);
            SeetaModelSetting eyeStateDetectorPoolSetting = new SeetaModelSetting(gpuId, eyeStateDetectorModelPath, device);
            SeetaConfSetting eyeStateDetectorPoolConfSetting = new SeetaConfSetting(eyeStateDetectorPoolSetting);
            SeetaModelSetting maskDetectorPoolSetting = new SeetaModelSetting(gpuId, maskDetectorModelPath, device);
            SeetaConfSetting maskDetectorPoolConfSetting = new SeetaConfSetting(maskDetectorPoolSetting);
            SeetaModelSetting poseEstimatorPoolSetting = new SeetaModelSetting(gpuId, poseEstimatorModelPath, device);
            SeetaConfSetting poseEstimatorPoolConfSetting = new SeetaConfSetting(poseEstimatorPoolSetting);
            this.faceDetectorPool = new FaceDetectorPool(faceDetectorPoolConfSetting);
            this.faceLandmarkerPool = new FaceLandmarkerPool(faceLandmarkerPoolConfSetting);
            this.genderPredictorPool = new GenderPredictorPool(genderPredictorPoolConfSetting);
            this.agePredictorPool = new AgePredictorPool(agePredictorPoolConfSetting);
            this.eyeStateDetectorPool = new EyeStateDetectorPool(eyeStateDetectorPoolConfSetting);
            this.maskDetectorPool = new MaskDetectorPool(maskDetectorPoolConfSetting);
            this.poseEstimatorPool = new PoseEstimatorPool(poseEstimatorPoolConfSetting);
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.faceDetectorPool.setMaxTotal(predictorPoolSize);
            this.faceLandmarkerPool.setMaxTotal(predictorPoolSize);
            this.genderPredictorPool.setMaxTotal(predictorPoolSize);
            this.agePredictorPool.setMaxTotal(predictorPoolSize);
            this.eyeStateDetectorPool.setMaxTotal(predictorPoolSize);
            this.maskDetectorPool.setMaxTotal(predictorPoolSize);
            this.poseEstimatorPool.setMaxTotal(predictorPoolSize);
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
        }
        catch (FileNotFoundException e) {
            throw new FaceException(e);
        }
    }

    @Override
    public DetectionResponse detect(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.detect(image);
    }

    @Override
    public DetectionResponse detect(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            return this.detect(ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public DetectionResponse detect(BufferedImage image) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        PredictorContext predictorContext = new PredictorContext();
        FaceLandmarker faceLandmarker = null;
        FaceDetector detectPredictor = null;
        ArrayList<SeetaPointF[]> seetaPointFSList = new ArrayList<SeetaPointF[]>();
        ArrayList<FaceAttribute> faceAttributeList = new ArrayList<FaceAttribute>();
        try {
            detectPredictor = (FaceDetector)this.faceDetectorPool.borrowObject();
            faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
            predictorContext.genderPredictor = this.config.isEnableGender() ? (GenderPredictor)this.genderPredictorPool.borrowObject() : null;
            predictorContext.agePredictor = this.config.isEnableAge() ? (AgePredictor)this.agePredictorPool.borrowObject() : null;
            predictorContext.maskDetector = this.config.isEnableMask() ? (MaskDetector)this.maskDetectorPool.borrowObject() : null;
            predictorContext.eyeStateDetector = this.config.isEnableEyeStatus() ? (EyeStateDetector)this.eyeStateDetectorPool.borrowObject() : null;
            predictorContext.poseEstimator = this.config.isEnableHeadPose() ? (PoseEstimator)this.poseEstimatorPool.borrowObject() : null;
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((BufferedImage)image);
            DetectionResponse seetaResult = detectPredictor.Detect(imageData);
            if (Objects.isNull(seetaResult)) {
                throw new FaceException("\u65e0\u4eba\u8138\u6570\u636e");
            }
            for (SeetaRect seetaRect : seetaResult) {
                SeetaPointF[] landmarks = new SeetaPointF[faceLandmarker.number()];
                faceLandmarker.mark(imageData, seetaRect, landmarks);
                seetaPointFSList.add(landmarks);
                FaceAttribute faceAttribute = this.detect(imageData, seetaRect, landmarks, predictorContext);
                faceAttributeList.add(faceAttribute);
            }
            DetectionResponse detectionResponse = FaceUtils.convertToFaceAttributeResponse((SeetaRect[])seetaResult, seetaPointFSList, faceAttributeList);
            return detectionResponse;
        }
        catch (Exception e) {
            throw new FaceException("\u4eba\u8138\u5c5e\u6027\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            PoolUtils.returnToPool((ObjectPool)this.faceDetectorPool, (Object)detectPredictor);
            PoolUtils.returnToPool((ObjectPool)this.faceLandmarkerPool, (Object)faceLandmarker);
            PoolUtils.returnToPool((ObjectPool)this.genderPredictorPool, (Object)predictorContext.genderPredictor);
            PoolUtils.returnToPool((ObjectPool)this.agePredictorPool, (Object)predictorContext.agePredictor);
            PoolUtils.returnToPool((ObjectPool)this.maskDetectorPool, (Object)predictorContext.maskDetector);
            PoolUtils.returnToPool((ObjectPool)this.eyeStateDetectorPool, (Object)predictorContext.eyeStateDetector);
            PoolUtils.returnToPool((ObjectPool)this.poseEstimatorPool, (Object)predictorContext.poseEstimator);
        }
    }

    private FaceAttribute detect(SeetaImageData imageData, SeetaRect seetaRect, SeetaPointF[] landmarks, PredictorContext predictorContext) {
        FaceAttribute faceAttribute = new FaceAttribute();
        GenderType genderType = null;
        if (this.config.isEnableGender()) {
            GenderPredictor.GENDER[] gender = new GenderPredictor.GENDER[1];
            boolean isSuccess = predictorContext.genderPredictor.PredictGenderWithCrop(imageData, landmarks, gender);
            genderType = isSuccess ? FaceUtils.convertToGenderType(gender[0]) : GenderType.UNKNOWN;
        }
        EyeStatus leftEyeStatus = null;
        EyeStatus rightEyeStatus = null;
        if (this.config.isEnableEyeStatus()) {
            EyeStateDetector.EYE_STATE[] eyeState = predictorContext.eyeStateDetector.detect(imageData, landmarks);
            leftEyeStatus = FaceUtils.convertToEyeStatus(eyeState[0]);
            rightEyeStatus = FaceUtils.convertToEyeStatus(eyeState[1]);
        }
        Integer age = 0;
        if (this.config.isEnableAge()) {
            age = predictorContext.agePredictor.predictAgeWithCrop(imageData, landmarks);
        }
        Boolean wearingMask = null;
        if (this.config.isEnableMask()) {
            float[] score = new float[1];
            wearingMask = predictorContext.maskDetector.detect(imageData, seetaRect, score);
        }
        if (this.config.isEnableHeadPose()) {
            float[] yaw = new float[1];
            float[] pitch = new float[1];
            float[] roll = new float[1];
            predictorContext.poseEstimator.Estimate(imageData, seetaRect, yaw, pitch, roll);
            faceAttribute.setHeadPose(new HeadPose(Float.valueOf(yaw[0]), Float.valueOf(pitch[0]), Float.valueOf(roll[0])));
        }
        faceAttribute.setGenderType(genderType);
        faceAttribute.setAge(age);
        faceAttribute.setLeftEyeStatus(leftEyeStatus);
        faceAttribute.setRightEyeStatus(rightEyeStatus);
        faceAttribute.setWearingMask(wearingMask);
        return faceAttribute;
    }

    @Override
    public List<FaceAttribute> detect(String imagePath, DetectionResponse faceDetectionResponse) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.detect(image, faceDetectionResponse);
    }

    @Override
    public List<FaceAttribute> detect(byte[] imageData, DetectionResponse faceDetectionResponse) {
        if (Objects.isNull(imageData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            return this.detect(ImageIO.read(new ByteArrayInputStream(imageData)), faceDetectionResponse);
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public List<FaceAttribute> detect(BufferedImage image, DetectionResponse faceDetectionResponse) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        if (Objects.isNull(faceDetectionResponse) || Objects.isNull(faceDetectionResponse.getDetectionInfoList()) || faceDetectionResponse.getDetectionInfoList().isEmpty()) {
            throw new FaceException("\u65e0\u4eba\u8138\u6570\u636e");
        }
        PredictorContext predictorContext = new PredictorContext();
        FaceLandmarker faceLandmarker = null;
        ArrayList<FaceAttribute> faceAttributeList = new ArrayList<FaceAttribute>();
        try {
            faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
            predictorContext.genderPredictor = this.config.isEnableGender() ? (GenderPredictor)this.genderPredictorPool.borrowObject() : null;
            predictorContext.agePredictor = this.config.isEnableAge() ? (AgePredictor)this.agePredictorPool.borrowObject() : null;
            predictorContext.maskDetector = this.config.isEnableMask() ? (MaskDetector)this.maskDetectorPool.borrowObject() : null;
            predictorContext.eyeStateDetector = this.config.isEnableEyeStatus() ? (EyeStateDetector)this.eyeStateDetectorPool.borrowObject() : null;
            predictorContext.poseEstimator = this.config.isEnableHeadPose() ? (PoseEstimator)this.poseEstimatorPool.borrowObject() : null;
            for (DetectionInfo detectionInfo : faceDetectionResponse.getDetectionInfoList()) {
                SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
                imageData.data = ImageUtils.getMatrixBGR((BufferedImage)image);
                SeetaRect seetaRect = FaceUtils.convertToSeetaRect(detectionInfo.getDetectionRectangle());
                SeetaPointF[] landmarks = null;
                FaceInfo faceInfo = detectionInfo.getFaceInfo();
                if (faceInfo == null || faceInfo.getKeyPoints() == null || faceInfo.getKeyPoints().isEmpty()) {
                    landmarks = new SeetaPointF[faceLandmarker.number()];
                    faceLandmarker.mark(imageData, seetaRect, landmarks);
                } else {
                    landmarks = FaceUtils.convertToSeetaPointF(faceInfo.getKeyPoints());
                }
                FaceAttribute faceAttribute = this.detect(imageData, seetaRect, landmarks, predictorContext);
                faceAttributeList.add(faceAttribute);
            }
        }
        catch (Exception e) {
            throw new FaceException("\u6d3b\u4f53\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (faceLandmarker != null) {
                try {
                    this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
            PoolUtils.returnToPool((ObjectPool)this.genderPredictorPool, (Object)predictorContext.genderPredictor);
            PoolUtils.returnToPool((ObjectPool)this.agePredictorPool, (Object)predictorContext.agePredictor);
            PoolUtils.returnToPool((ObjectPool)this.maskDetectorPool, (Object)predictorContext.maskDetector);
            PoolUtils.returnToPool((ObjectPool)this.eyeStateDetectorPool, (Object)predictorContext.eyeStateDetector);
            PoolUtils.returnToPool((ObjectPool)this.poseEstimatorPool, (Object)predictorContext.poseEstimator);
        }
        return faceAttributeList;
    }

    @Override
    public FaceAttribute detect(String imagePath, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.detect(image, faceDetectionRectangle, keyPoints);
    }

    @Override
    public FaceAttribute detect(byte[] imageData, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints) {
        if (Objects.isNull(imageData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            return this.detect(ImageIO.read(new ByteArrayInputStream(imageData)), faceDetectionRectangle, keyPoints);
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public FaceAttribute detect(BufferedImage image, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        if (Objects.isNull(faceDetectionRectangle)) {
            throw new FaceException("\u65e0\u4eba\u8138\u6570\u636e");
        }
        PredictorContext predictorContext = new PredictorContext();
        try {
            FaceAttribute faceAttribute;
            predictorContext.genderPredictor = this.config.isEnableGender() ? (GenderPredictor)this.genderPredictorPool.borrowObject() : null;
            predictorContext.agePredictor = this.config.isEnableAge() ? (AgePredictor)this.agePredictorPool.borrowObject() : null;
            predictorContext.maskDetector = this.config.isEnableMask() ? (MaskDetector)this.maskDetectorPool.borrowObject() : null;
            predictorContext.eyeStateDetector = this.config.isEnableEyeStatus() ? (EyeStateDetector)this.eyeStateDetectorPool.borrowObject() : null;
            predictorContext.poseEstimator = this.config.isEnableHeadPose() ? (PoseEstimator)this.poseEstimatorPool.borrowObject() : null;
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((BufferedImage)image);
            SeetaRect seetaRect = FaceUtils.convertToSeetaRect(faceDetectionRectangle);
            SeetaPointF[] landmarks = null;
            if (keyPoints == null || keyPoints.isEmpty()) {
                throw new FaceException("\u4eba\u8138\u5173\u952e\u70b9keyPoints\u4e3a\u7a7a");
            }
            landmarks = FaceUtils.convertToSeetaPointF(keyPoints);
            FaceAttribute faceAttribute2 = faceAttribute = this.detect(imageData, seetaRect, landmarks, predictorContext);
            return faceAttribute2;
        }
        catch (Exception e) {
            throw new FaceException("\u6d3b\u4f53\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            PoolUtils.returnToPool((ObjectPool)this.genderPredictorPool, (Object)predictorContext.genderPredictor);
            PoolUtils.returnToPool((ObjectPool)this.agePredictorPool, (Object)predictorContext.agePredictor);
            PoolUtils.returnToPool((ObjectPool)this.maskDetectorPool, (Object)predictorContext.maskDetector);
            PoolUtils.returnToPool((ObjectPool)this.eyeStateDetectorPool, (Object)predictorContext.eyeStateDetector);
            PoolUtils.returnToPool((ObjectPool)this.poseEstimatorPool, (Object)predictorContext.poseEstimator);
        }
    }

    @Override
    public FaceAttribute detectTopFace(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.detectTopFace(image);
    }

    @Override
    public FaceAttribute detectTopFace(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            return this.detectTopFace(ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public FaceAttribute detectTopFace(BufferedImage image) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        FaceLandmarker faceLandmarker = null;
        FaceDetector detectPredictor = null;
        PredictorContext predictorContext = new PredictorContext();
        try {
            FaceAttribute faceAttribute;
            detectPredictor = (FaceDetector)this.faceDetectorPool.borrowObject();
            faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
            predictorContext.genderPredictor = this.config.isEnableGender() ? (GenderPredictor)this.genderPredictorPool.borrowObject() : null;
            predictorContext.agePredictor = this.config.isEnableAge() ? (AgePredictor)this.agePredictorPool.borrowObject() : null;
            predictorContext.maskDetector = this.config.isEnableMask() ? (MaskDetector)this.maskDetectorPool.borrowObject() : null;
            predictorContext.eyeStateDetector = this.config.isEnableEyeStatus() ? (EyeStateDetector)this.eyeStateDetectorPool.borrowObject() : null;
            predictorContext.poseEstimator = this.config.isEnableHeadPose() ? (PoseEstimator)this.poseEstimatorPool.borrowObject() : null;
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((BufferedImage)image);
            SeetaRect[] seetaResult = detectPredictor.Detect(imageData);
            if (Objects.isNull(seetaResult)) {
                throw new FaceException("\u65e0\u4eba\u8138\u6570\u636e");
            }
            SeetaPointF[] landmarks = new SeetaPointF[faceLandmarker.number()];
            faceLandmarker.mark(imageData, seetaResult[0], landmarks);
            FaceAttribute faceAttribute2 = faceAttribute = this.detect(imageData, seetaResult[0], landmarks, predictorContext);
            return faceAttribute2;
        }
        catch (Exception e) {
            throw new FaceException("\u6d3b\u4f53\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (detectPredictor != null) {
                try {
                    this.faceDetectorPool.returnObject((Object)detectPredictor);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
            if (faceLandmarker != null) {
                try {
                    this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
            PoolUtils.returnToPool((ObjectPool)this.genderPredictorPool, (Object)predictorContext.genderPredictor);
            PoolUtils.returnToPool((ObjectPool)this.agePredictorPool, (Object)predictorContext.agePredictor);
            PoolUtils.returnToPool((ObjectPool)this.maskDetectorPool, (Object)predictorContext.maskDetector);
            PoolUtils.returnToPool((ObjectPool)this.eyeStateDetectorPool, (Object)predictorContext.eyeStateDetector);
            PoolUtils.returnToPool((ObjectPool)this.poseEstimatorPool, (Object)predictorContext.poseEstimator);
        }
    }

    public FaceDetectorPool getFaceDetectorPool() {
        return this.faceDetectorPool;
    }

    public GenderPredictorPool getGenderPredictorPool() {
        return this.genderPredictorPool;
    }

    public FaceLandmarkerPool getFaceLandmarkerPool() {
        return this.faceLandmarkerPool;
    }

    public AgePredictorPool getAgePredictorPool() {
        return this.agePredictorPool;
    }

    public EyeStateDetectorPool getEyeStateDetectorPool() {
        return this.eyeStateDetectorPool;
    }

    public MaskDetectorPool getMaskDetectorPool() {
        return this.maskDetectorPool;
    }

    public PoseEstimatorPool getPoseEstimatorPool() {
        return this.poseEstimatorPool;
    }

    @Override
    public void close() throws Exception {
        if (Objects.nonNull(this.faceDetectorPool)) {
            this.faceDetectorPool.close();
        }
        if (Objects.nonNull(this.genderPredictorPool)) {
            this.genderPredictorPool.close();
        }
        if (Objects.nonNull(this.faceLandmarkerPool)) {
            this.faceLandmarkerPool.close();
        }
        if (Objects.nonNull(this.agePredictorPool)) {
            this.agePredictorPool.close();
        }
        if (Objects.nonNull(this.eyeStateDetectorPool)) {
            this.eyeStateDetectorPool.close();
        }
        if (Objects.nonNull(this.maskDetectorPool)) {
            this.maskDetectorPool.close();
        }
        if (Objects.nonNull(this.poseEstimatorPool)) {
            this.poseEstimatorPool.close();
        }
    }
}

