/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.expression.criterial;

import ai.djl.Device;
import ai.djl.modality.Classifications;
import ai.djl.modality.cv.Image;
import ai.djl.repository.zoo.Criteria;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.Translator;
import ai.djl.util.Progress;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.face.config.FaceExpressionConfig;
import cn.smartjavaai.face.enums.ExpressionModelEnum;
import cn.smartjavaai.face.model.expression.translator.DenseNetEmotionTranslator;
import cn.smartjavaai.face.model.expression.translator.FrEmotionTranslator;
import java.nio.file.Paths;
import java.util.Objects;

public class EmotionCriteriaFactory {
    public static Criteria<Image, Classifications> createCriteria(FaceExpressionConfig config) {
        Device device = null;
        if (!Objects.isNull(config.getDevice())) {
            device = config.getDevice() == DeviceEnum.CPU ? Device.cpu() : Device.gpu((int)config.getGpuId());
        }
        Criteria criteria = null;
        if (config.getModelEnum() == ExpressionModelEnum.DensNet121) {
            criteria = Criteria.builder().optEngine("PyTorch").setTypes(Image.class, Classifications.class).optModelPath(Paths.get(config.getModelPath(), new String[0])).optTranslator((Translator)new DenseNetEmotionTranslator(224)).optProgress((Progress)new ProgressBar()).optDevice(device).build();
        } else if (config.getModelEnum() == ExpressionModelEnum.FrEmotion) {
            criteria = Criteria.builder().optEngine("OnnxRuntime").setTypes(Image.class, Classifications.class).optModelPath(Paths.get(config.getModelPath(), new String[0])).optTranslator((Translator)new FrEmotionTranslator(224)).optProgress((Progress)new ProgressBar()).optDevice(device).build();
        }
        return criteria;
    }
}

