/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.facerec;

import cn.smartjavaai.common.entity.DetectionInfo;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.entity.face.FaceSearchResult;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.face.config.FaceRecConfig;
import cn.smartjavaai.face.entity.FaceRegisterInfo;
import cn.smartjavaai.face.entity.FaceResult;
import cn.smartjavaai.face.entity.FaceSearchParams;
import cn.smartjavaai.face.enums.SimilarityType;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.model.facerec.FaceRecModel;
import cn.smartjavaai.face.seetaface.NativeLoader;
import cn.smartjavaai.face.utils.FaceUtils;
import cn.smartjavaai.face.vector.config.MilvusConfig;
import cn.smartjavaai.face.vector.config.SQLiteConfig;
import cn.smartjavaai.face.vector.core.VectorDBClient;
import cn.smartjavaai.face.vector.core.VectorDBFactory;
import cn.smartjavaai.face.vector.entity.FaceVector;
import cn.smartjavaai.face.vector.exception.VectorDBException;
import com.seeta.pool.FaceDatabasePool;
import com.seeta.pool.FaceDetectorPool;
import com.seeta.pool.FaceLandmarkerPool;
import com.seeta.pool.FaceRecognizerPool;
import com.seeta.pool.SeetaConfSetting;
import com.seeta.sdk.FaceDetector;
import com.seeta.sdk.FaceLandmarker;
import com.seeta.sdk.FaceRecognizer;
import com.seeta.sdk.SeetaDevice;
import com.seeta.sdk.SeetaImageData;
import com.seeta.sdk.SeetaModelSetting;
import com.seeta.sdk.SeetaPointF;
import io.milvus.param.MetricType;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeetaFace6FaceRecModel
implements FaceRecModel {
    private static final Logger log = LoggerFactory.getLogger(SeetaFace6FaceRecModel.class);
    private static final int DIMENSION = 1024;
    private FaceRecConfig config;
    private FaceDetectorPool faceDetectorPool;
    private FaceRecognizerPool faceRecognizerPool;
    private FaceLandmarkerPool faceLandmarkerPool;
    private FaceDatabasePool faceDatabasePool;
    private VectorDBClient vectorDBClient = null;
    private static volatile boolean isLoadCompleted = false;
    public static final boolean NORMALIZE_SIMILARITY = false;

    @Override
    public void loadModel(FaceRecConfig config) {
        this.config = config;
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new FaceException("modelPath is null");
        }
        NativeLoader.loadNativeLibraries(config.getDevice());
        log.debug("Loading seetaFace6 library successfully.");
        String[] faceDetectorModelPath = new String[]{config.getModelPath() + File.separator + "face_detector.csta"};
        String[] faceRecognizerModelPath = new String[]{config.getModelPath() + File.separator + "face_recognizer.csta"};
        String[] faceLandmarkerModelPath = new String[]{config.getModelPath() + File.separator + "face_landmarker_pts5.csta"};
        SeetaDevice device = SeetaDevice.SEETA_DEVICE_AUTO;
        int gpuId = config.getGpuId();
        if (Objects.nonNull(config.getDevice())) {
            device = config.getDevice() == DeviceEnum.CPU ? SeetaDevice.SEETA_DEVICE_CPU : SeetaDevice.SEETA_DEVICE_GPU;
        }
        try {
            SeetaModelSetting faceDetectorPoolSetting = new SeetaModelSetting(gpuId, faceDetectorModelPath, device);
            SeetaConfSetting faceDetectorPoolConfSetting = new SeetaConfSetting(faceDetectorPoolSetting);
            SeetaModelSetting faceRecognizerPoolSetting = new SeetaModelSetting(gpuId, faceRecognizerModelPath, device);
            SeetaConfSetting faceRecognizerPoolConfSetting = new SeetaConfSetting(faceRecognizerPoolSetting);
            SeetaModelSetting faceLandmarkerPoolSetting = new SeetaModelSetting(gpuId, faceLandmarkerModelPath, device);
            SeetaConfSetting faceLandmarkerPoolConfSetting = new SeetaConfSetting(faceLandmarkerPoolSetting);
            SeetaModelSetting faceDatabasePoolSetting = new SeetaModelSetting(gpuId, faceRecognizerModelPath, device);
            SeetaConfSetting faceDatabasePoolConfSetting = new SeetaConfSetting(faceDatabasePoolSetting);
            this.faceDetectorPool = new FaceDetectorPool(faceDetectorPoolConfSetting);
            this.faceRecognizerPool = new FaceRecognizerPool(faceRecognizerPoolConfSetting);
            this.faceLandmarkerPool = new FaceLandmarkerPool(faceLandmarkerPoolConfSetting);
            this.faceDatabasePool = new FaceDatabasePool(faceDatabasePoolConfSetting);
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.faceDetectorPool.setMaxTotal(predictorPoolSize);
            this.faceRecognizerPool.setMaxTotal(predictorPoolSize);
            this.faceLandmarkerPool.setMaxTotal(predictorPoolSize);
            this.faceDatabasePool.setMaxTotal(predictorPoolSize);
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
            if (config.getVectorDBConfig() != null && config.getVectorDBConfig().getType() != null) {
                SQLiteConfig sqliteConfig;
                if (config.getVectorDBConfig() instanceof MilvusConfig) {
                    MilvusConfig milvusConfig = (MilvusConfig)config.getVectorDBConfig();
                    milvusConfig.setDimension(1024);
                    if (Objects.isNull(milvusConfig.getMetricType())) {
                        milvusConfig.setMetricType(MetricType.COSINE);
                    }
                } else if (config.getVectorDBConfig() instanceof SQLiteConfig && Objects.isNull((Object)(sqliteConfig = (SQLiteConfig)config.getVectorDBConfig()).getSimilarityType())) {
                    sqliteConfig.setSimilarityType(SimilarityType.COSINE);
                }
                this.vectorDBClient = VectorDBFactory.createClient(config.getVectorDBConfig());
                if (config.isAutoLoadFace()) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                log.debug("start load face...");
                                SeetaFace6FaceRecModel.this.vectorDBClient.initialize();
                                isLoadCompleted = true;
                                log.debug("Load face success!");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new FaceException(e);
        }
    }

    @Override
    public float calculSimilar(float[] feature1, float[] feature2) {
        if (Objects.isNull(feature1) || Objects.isNull(feature2)) {
            throw new FaceException("\u7279\u5f81\u5411\u91cf\u65e0\u6548");
        }
        FaceRecognizer faceRecognizer = null;
        try {
            faceRecognizer = (FaceRecognizer)this.faceRecognizerPool.borrowObject();
            float f = faceRecognizer.CalculateSimilarity(feature1, feature2);
            return f;
        }
        catch (Exception e) {
            throw new FaceException(e);
        }
        finally {
            if (faceRecognizer != null) {
                try {
                    this.faceRecognizerPool.returnObject((Object)faceRecognizer);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public R<Float> featureComparison(String imagePath1, String imagePath2) {
        if (!FileUtils.isFileExists((String)imagePath1) || !FileUtils.isFileExists((String)imagePath2)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage image1 = null;
        BufferedImage image2 = null;
        try {
            image1 = ImageIO.read(new File(Paths.get(imagePath1, new String[0]).toAbsolutePath().toString()));
            image2 = ImageIO.read(new File(Paths.get(imagePath2, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.featureComparison(image1, image2);
    }

    @Override
    public R<Float> featureComparison(BufferedImage image1, BufferedImage image2) {
        if (!ImageUtils.isImageValid((BufferedImage)image1) || !ImageUtils.isImageValid((BufferedImage)image2)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        R<float[]> feature1 = this.extractTopFaceFeature(image1);
        if (!feature1.isSuccess()) {
            return R.fail((Integer)feature1.getCode(), (String)feature1.getMessage());
        }
        R<float[]> feature2 = this.extractTopFaceFeature(image2);
        if (!feature2.isSuccess()) {
            return R.fail((Integer)feature2.getCode(), (String)feature2.getMessage());
        }
        return R.ok((Object)Float.valueOf(this.calculSimilar((float[])feature1.getData(), (float[])feature2.getData())));
    }

    @Override
    public R<Float> featureComparison(byte[] imageData1, byte[] imageData2) {
        if (Objects.isNull(imageData1) || Objects.isNull(imageData2)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        BufferedImage image1 = null;
        BufferedImage image2 = null;
        try {
            image1 = ImageIO.read(new ByteArrayInputStream(imageData1));
            image2 = ImageIO.read(new ByteArrayInputStream(imageData2));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247", e);
        }
        return this.featureComparison(image1, image2);
    }

    @Override
    public R<String> register(FaceRegisterInfo faceRegisterInfo, String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.register(faceRegisterInfo, bufferedImage);
    }

    @Override
    public R<String> register(FaceRegisterInfo faceRegisterInfo, BufferedImage image) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        R<float[]> featureResponse = this.extractTopFaceFeature(image);
        if (!featureResponse.isSuccess()) {
            return R.fail((Integer)featureResponse.getCode(), (String)featureResponse.getMessage());
        }
        return this.register(faceRegisterInfo, (float[])featureResponse.getData());
    }

    @Override
    public R<String> register(FaceRegisterInfo faceRegisterInfo, byte[] imageData) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new ByteArrayInputStream(imageData));
        }
        catch (IOException e) {
            throw new FaceException(e);
        }
        return this.register(faceRegisterInfo, bufferedImage);
    }

    @Override
    public R<String> register(FaceRegisterInfo faceRegisterInfo, InputStream inputStream) {
        if (Objects.isNull(inputStream)) {
            throw new FaceException("\u56fe\u50cf\u8f93\u5165\u6d41\u65e0\u6548");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(inputStream);
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u7684\u56fe\u7247\u8f93\u5165\u6d41", e);
        }
        return this.register(faceRegisterInfo, image);
    }

    @Override
    public R<String> register(FaceRegisterInfo faceRegisterInfo, float[] feature) {
        if (Objects.isNull(feature)) {
            return R.fail((Integer)R.Status.Unknown.getCode(), (String)"\u4eba\u8138\u6ce8\u518c\u5931\u8d25\uff1a\u4eba\u8138\u7279\u5f81\u4e3a\u7a7a");
        }
        FaceVector faceVector = new FaceVector();
        if (Objects.nonNull(faceRegisterInfo)) {
            faceVector.setId(faceRegisterInfo.getId());
            faceVector.setMetadata(faceRegisterInfo.getMetadata());
        }
        faceVector.setVector(feature);
        return R.ok((Object)this.vectorDBClient.insert(faceVector));
    }

    @Override
    public R<DetectionResponse> search(String imagePath, FaceSearchParams params) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.search(bufferedImage, params);
    }

    @Override
    public R<DetectionResponse> search(BufferedImage image, FaceSearchParams params) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        R<DetectionResponse> detectionResponse = this.extractFeatures(image);
        if (!detectionResponse.isSuccess()) {
            return detectionResponse;
        }
        float threshold = Objects.isNull(params.getThreshold()) ? 0.85f : params.getThreshold().floatValue();
        int topK = Objects.isNull(params.getTopK()) ? 1 : params.getTopK();
        boolean normalize = Objects.isNull(params.getNormalizeSimilarity()) ? false : params.getNormalizeSimilarity();
        FaceSearchParams searchParams = new FaceSearchParams(topK, Float.valueOf(threshold), normalize);
        for (DetectionInfo detectionInfo : ((DetectionResponse)detectionResponse.getData()).getDetectionInfoList()) {
            if (!Objects.nonNull(detectionInfo.getFaceInfo()) || !Objects.nonNull(detectionInfo.getFaceInfo().getFeature())) continue;
            List<FaceSearchResult> searchResults = this.vectorDBClient.search(detectionInfo.getFaceInfo().getFeature(), searchParams);
            detectionInfo.getFaceInfo().setFaceSearchResults(searchResults);
        }
        return detectionResponse;
    }

    @Override
    public R<DetectionResponse> search(byte[] imageData, FaceSearchParams params) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new ByteArrayInputStream(imageData));
        }
        catch (IOException e) {
            throw new FaceException(e);
        }
        return this.search(bufferedImage, params);
    }

    @Override
    public List<FaceSearchResult> search(float[] feature, FaceSearchParams params) {
        if (this.vectorDBClient == null) {
            throw new VectorDBException("\u5411\u91cf\u6570\u636e\u5e93\u672a\u521d\u59cb\u5316\u6210\u529f");
        }
        if (Objects.isNull(feature)) {
            throw new FaceException("\u4eba\u8138\u7279\u5f81\u4e3a\u7a7a");
        }
        if (Objects.isNull(params)) {
            throw new FaceException("\u4eba\u8138\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a");
        }
        float threshold = Objects.isNull(params.getThreshold()) ? 0.85f : params.getThreshold().floatValue();
        int topK = Objects.isNull(params.getTopK()) ? 1 : params.getTopK();
        boolean normalize = Objects.isNull(params.getNormalizeSimilarity()) ? false : params.getNormalizeSimilarity();
        FaceSearchParams searchParams = new FaceSearchParams(topK, Float.valueOf(threshold), normalize);
        List<FaceSearchResult> searchResults = this.vectorDBClient.search(feature, searchParams);
        return searchResults;
    }

    @Override
    public R<List<FaceSearchResult>> searchByTopFace(String imagePath, FaceSearchParams params) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.searchByTopFace(bufferedImage, params);
    }

    @Override
    public R<List<FaceSearchResult>> searchByTopFace(BufferedImage sourceImage, FaceSearchParams params) {
        if (!ImageUtils.isImageValid((BufferedImage)sourceImage)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        R<float[]> featureResponse = this.extractTopFaceFeature(sourceImage);
        if (!featureResponse.isSuccess()) {
            return R.fail((Integer)featureResponse.getCode(), (String)featureResponse.getMessage());
        }
        float threshold = Objects.isNull(params.getThreshold()) ? 0.85f : params.getThreshold().floatValue();
        int topK = Objects.isNull(params.getTopK()) ? 1 : params.getTopK();
        boolean normalize = Objects.isNull(params.getNormalizeSimilarity()) ? false : params.getNormalizeSimilarity();
        FaceSearchParams searchParams = new FaceSearchParams(topK, Float.valueOf(threshold), normalize);
        List<FaceSearchResult> searchResults = this.vectorDBClient.search((float[])featureResponse.getData(), searchParams);
        return R.ok(searchResults);
    }

    @Override
    public R<List<FaceSearchResult>> searchByTopFace(byte[] imageData, FaceSearchParams params) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new ByteArrayInputStream(imageData));
        }
        catch (IOException e) {
            throw new FaceException(e);
        }
        return this.searchByTopFace(bufferedImage, params);
    }

    @Override
    public void removeRegister(String ... keys) {
        if (keys == null || keys.length == 0) {
            throw new FaceException("keys\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.vectorDBClient.deleteBatch(Arrays.asList(keys));
    }

    @Override
    public void clearFace() {
        this.vectorDBClient.dropCollection(null);
    }

    private FaceResult searchFaceDb(long index, float similar) {
        if (index >= 0L) {
            String key = null;
            return new FaceResult(key, similar);
        }
        return null;
    }

    @Override
    public R<DetectionResponse> extractFeatures(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.extractFeatures(image);
    }

    @Override
    public R<DetectionResponse> extractFeatures(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        try {
            return this.extractFeatures(ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u7279\u5f81\u63d0\u53d6\u5f02\u5e38", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public R<DetectionResponse> extractFeatures(BufferedImage image) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 66[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R<float[]> extractTopFaceFeature(BufferedImage image) {
        block58: {
            block57: {
                block56: {
                    block55: {
                        block54: {
                            if (!ImageUtils.isImageValid((BufferedImage)image)) {
                                return R.fail((R.Status)R.Status.INVALID_IMAGE);
                            }
                            features = null;
                            imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
                            imageData.data = ImageUtils.getMatrixBGR((BufferedImage)image);
                            faceDetector = null;
                            faceLandmarker = null;
                            faceRecognizer = null;
                            try {
                                faceRecognizer = (FaceRecognizer)this.faceRecognizerPool.borrowObject();
                                pointFS = null;
                                if (!Objects.isNull(this.config.getDetectModel())) ** GOTO lbl68
                                faceDetector = (FaceDetector)this.faceDetectorPool.borrowObject();
                                faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
                                seetaResult = faceDetector.Detect(imageData);
                                if (Objects.isNull(seetaResult) || seetaResult.length == 0) {
                                    var9_12 = R.fail((R.Status)R.Status.NO_FACE_DETECTED);
                                    if (faceDetector == null) break block54;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (FaceException e) {
                                try {
                                    throw e;
                                    catch (Exception e) {
                                        throw new FaceException("\u76ee\u6807\u68c0\u6d4b\u9519\u8bef", e);
                                    }
                                }
                                catch (Throwable var11_36) {
                                    if (faceDetector != null) {
                                        try {
                                            this.faceDetectorPool.returnObject(faceDetector);
                                        }
                                        catch (Exception e) {
                                            SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                                        }
                                    }
                                    if (faceLandmarker != null) {
                                        try {
                                            this.faceLandmarkerPool.returnObject(faceLandmarker);
                                        }
                                        catch (Exception e) {
                                            SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                                        }
                                    }
                                    if (faceRecognizer == null) throw var11_36;
                                    try {
                                        this.faceRecognizerPool.returnObject((Object)faceRecognizer);
                                        throw var11_36;
                                    }
                                    catch (Exception e) {
                                        SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                                    }
                                    throw var11_36;
                                }
                            }
                            try {
                                this.faceDetectorPool.returnObject((Object)faceDetector);
                            }
                            catch (Exception e) {
                                SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                            }
                        }
                        if (faceLandmarker != null) {
                            try {
                                this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
                            }
                            catch (Exception e) {
                                SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                            }
                        }
                        if (faceRecognizer == null) return var9_12;
                        try {
                            this.faceRecognizerPool.returnObject((Object)faceRecognizer);
                            return var9_12;
                        }
                        catch (Exception e) {
                            SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                        }
                        return var9_12;
lbl-1000:
                        // 1 sources

                        {
                            pointFS = new SeetaPointF[faceLandmarker.number()];
                            faceLandmarker.mark(imageData, seetaResult[0], pointFS);
                            ** GOTO lbl115
lbl68:
                            // 1 sources

                            detectResponse = this.config.getDetectModel().detect(image);
                            if (detectResponse.isSuccess()) ** GOTO lbl-1000
                            var9_13 = R.fail((Integer)detectResponse.getCode(), (String)detectResponse.getMessage());
                            if (faceDetector == null) break block55;
                        }
                        try {
                            this.faceDetectorPool.returnObject((Object)faceDetector);
                        }
                        catch (Exception e) {
                            SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                        }
                    }
                    if (faceLandmarker != null) {
                        try {
                            this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
                        }
                        catch (Exception e) {
                            SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                        }
                    }
                    if (faceRecognizer == null) return var9_13;
                    try {
                        this.faceRecognizerPool.returnObject((Object)faceRecognizer);
                        return var9_13;
                    }
                    catch (Exception e) {
                        SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    }
                    return var9_13;
lbl-1000:
                    // 1 sources

                    {
                        if (!Objects.isNull(detectResponse.getData()) && !Objects.isNull(((DetectionResponse)detectResponse.getData()).getDetectionInfoList()) && !((DetectionResponse)detectResponse.getData()).getDetectionInfoList().isEmpty()) ** GOTO lbl-1000
                        var9_14 = R.fail((R.Status)R.Status.NO_FACE_DETECTED);
                        if (faceDetector == null) break block56;
                    }
                    try {
                        this.faceDetectorPool.returnObject((Object)faceDetector);
                    }
                    catch (Exception e) {
                        SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    }
                }
                if (faceLandmarker != null) {
                    try {
                        this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
                    }
                    catch (Exception e) {
                        SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    }
                }
                if (faceRecognizer == null) return var9_14;
                try {
                    this.faceRecognizerPool.returnObject((Object)faceRecognizer);
                    return var9_14;
                }
                catch (Exception e) {
                    SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
                return var9_14;
lbl-1000:
                // 1 sources

                {
                    detectionInfo = (DetectionInfo)((DetectionResponse)detectResponse.getData()).getDetectionInfoList().get(0);
                    pointFS = FaceUtils.convertToSeetaPointF(detectionInfo.getFaceInfo().getKeyPoints());
lbl115:
                    // 2 sources

                    features = new float[faceRecognizer.GetExtractFeatureSize()];
                    isSuccess = faceRecognizer.Extract(imageData, pointFS, features);
                    if (isSuccess) ** GOTO lbl-1000
                    var9_15 = R.fail((Integer)R.Status.Unknown.getCode(), (String)"\u4eba\u8138\u7279\u5f81\u63d0\u53d6\u5931\u8d25");
                    if (faceDetector == null) break block57;
                }
                try {
                    this.faceDetectorPool.returnObject((Object)faceDetector);
                }
                catch (Exception e) {
                    SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
            if (faceLandmarker != null) {
                try {
                    this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
                }
                catch (Exception e) {
                    SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
            if (faceRecognizer == null) return var9_15;
            try {
                this.faceRecognizerPool.returnObject((Object)faceRecognizer);
                return var9_15;
            }
            catch (Exception e) {
                SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
            return var9_15;
lbl-1000:
            // 1 sources

            {
                var9_15 = R.ok((Object)features);
                if (faceDetector == null) break block58;
            }
            try {
                this.faceDetectorPool.returnObject((Object)faceDetector);
            }
            catch (Exception e) {
                SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceLandmarker != null) {
            try {
                this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
            }
            catch (Exception e) {
                SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceRecognizer == null) return var9_15;
        try {
            this.faceRecognizerPool.returnObject((Object)faceRecognizer);
            return var9_15;
        }
        catch (Exception e) {
            SeetaFace6FaceRecModel.log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
        }
        return var9_15;
    }

    public float[] featureExtraction(BufferedImage image) {
        FaceRecognizer faceRecognizer = null;
        try {
            faceRecognizer = (FaceRecognizer)this.faceRecognizerPool.borrowObject();
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((BufferedImage)image);
            float[] features = new float[faceRecognizer.GetExtractFeatureSize()];
            faceRecognizer.ExtractCroppedFace(imageData, features);
            float[] fArray = features;
            return fArray;
        }
        catch (FaceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FaceException("\u76ee\u6807\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (faceRecognizer != null) {
                try {
                    this.faceRecognizerPool.returnObject((Object)faceRecognizer);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public R<float[]> extractTopFaceFeature(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.extractTopFaceFeature(image);
    }

    @Override
    public R<float[]> extractTopFaceFeature(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        try {
            return this.extractTopFaceFeature(ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public void loadFaceFeatures() {
        if (Objects.isNull(this.vectorDBClient)) {
            throw new FaceException("\u672a\u521d\u59cb\u5316\u4eba\u8138\u5e93");
        }
        this.vectorDBClient.loadFaceFeatures();
    }

    @Override
    public void releaseFaceFeatures() {
        if (Objects.isNull(this.vectorDBClient)) {
            throw new FaceException("\u672a\u521d\u59cb\u5316\u4eba\u8138\u5e93");
        }
        this.vectorDBClient.releaseFaceFeatures();
    }

    @Override
    public void upsertFace(FaceRegisterInfo faceRegisterInfo, String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        this.upsertFace(faceRegisterInfo, bufferedImage);
    }

    @Override
    public void upsertFace(FaceRegisterInfo faceRegisterInfo, BufferedImage sourceImage) {
        if (this.vectorDBClient == null) {
            throw new VectorDBException("\u5411\u91cf\u6570\u636e\u5e93\u672a\u521d\u59cb\u5316\u6210\u529f");
        }
        if (Objects.isNull(faceRegisterInfo)) {
            throw new FaceException("\u6ce8\u518c\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)faceRegisterInfo.getId())) {
            throw new FaceException("\u6ce8\u518c\u4fe1\u606f\u4e2dID\u4e3a\u7a7a");
        }
        R<float[]> featureResponse = this.extractTopFaceFeature(sourceImage);
        if (!featureResponse.isSuccess()) {
            throw new FaceException(featureResponse.getMessage());
        }
        this.upsertFace(faceRegisterInfo, (float[])featureResponse.getData());
    }

    @Override
    public void upsertFace(FaceRegisterInfo faceRegisterInfo, float[] feature) {
        if (Objects.isNull(feature)) {
            throw new FaceException("\u4eba\u8138\u7279\u5f81\u4e3a\u7a7a");
        }
        if (Objects.isNull(this.vectorDBClient)) {
            throw new FaceException("\u672a\u521d\u59cb\u5316\u4eba\u8138\u5e93");
        }
        FaceVector faceVector = new FaceVector();
        if (faceRegisterInfo != null) {
            faceVector.setId(faceRegisterInfo.getId());
            faceVector.setMetadata(faceRegisterInfo.getMetadata());
        }
        faceVector.setVector(feature);
        this.vectorDBClient.upsert(faceVector);
    }

    @Override
    public void upsertFace(FaceRegisterInfo faceRegisterInfo, byte[] imageData) {
        FaceRecModel.super.upsertFace(faceRegisterInfo, imageData);
    }

    @Override
    public R<FaceVector> getFaceInfoById(String id) {
        if (this.vectorDBClient == null) {
            return R.fail((Integer)1000, (String)"\u5411\u91cf\u6570\u636e\u5e93\u672a\u521d\u59cb\u5316\u6210\u529f");
        }
        return R.ok((Object)this.vectorDBClient.getFaceInfoById(id));
    }

    @Override
    public R<List<FaceVector>> listFaces(long pageNum, long pageSize) {
        if (this.vectorDBClient == null) {
            return R.fail((Integer)1000, (String)"\u5411\u91cf\u6570\u636e\u5e93\u672a\u521d\u59cb\u5316\u6210\u529f");
        }
        return R.ok(this.vectorDBClient.listFaces(pageNum, pageSize));
    }

    @Override
    public void close() throws Exception {
        if (Objects.nonNull(this.faceDetectorPool)) {
            this.faceDetectorPool.close();
        }
        if (Objects.nonNull(this.faceRecognizerPool)) {
            this.faceRecognizerPool.close();
        }
        if (Objects.nonNull(this.faceLandmarkerPool)) {
            this.faceLandmarkerPool.close();
        }
        if (Objects.nonNull(this.faceDatabasePool)) {
            this.faceDatabasePool.close();
        }
        if (Objects.nonNull(this.vectorDBClient)) {
            this.vectorDBClient.close();
        }
    }

    @Override
    public boolean isLoadFaceCompleted() {
        return isLoadCompleted;
    }

    public FaceDetectorPool getFaceDetectorPool() {
        return this.faceDetectorPool;
    }

    public FaceRecognizerPool getFaceRecognizerPool() {
        return this.faceRecognizerPool;
    }

    public FaceLandmarkerPool getFaceLandmarkerPool() {
        return this.faceLandmarkerPool;
    }

    public FaceDatabasePool getFaceDatabasePool() {
        return this.faceDatabasePool;
    }
}

