/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.liveness;

import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.util.JsonUtils;
import cn.smartjavaai.common.entity.DetectionInfo;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.entity.face.FaceInfo;
import cn.smartjavaai.common.entity.face.LivenessResult;
import cn.smartjavaai.common.enums.face.LivenessStatus;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.common.preprocess.BufferedImagePreprocessor;
import cn.smartjavaai.common.utils.Base64ImageUtils;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.common.utils.OpenCVUtils;
import cn.smartjavaai.face.config.LivenessConfig;
import cn.smartjavaai.face.constant.MiniVisionConstant;
import cn.smartjavaai.face.enums.LivenessModelEnum;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.model.liveness.LivenessDetModel;
import cn.smartjavaai.face.model.liveness.criterial.LivenessCriteriaFactory;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameUtils;
import org.opencv.core.Mat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonLivenessModel
implements LivenessDetModel {
    private static final Logger log = LoggerFactory.getLogger(CommonLivenessModel.class);
    protected GenericObjectPool<Predictor<Image, Float>> predictorPool;
    protected LivenessConfig config;
    protected ZooModel<Image, Float> model;

    @Override
    public void loadModel(LivenessConfig config) {
        if (Objects.isNull((Object)config)) {
            throw new FaceException("config\u4e3anull");
        }
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new FaceException("modelPath\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.config = config;
        Float realityThreshold = Objects.isNull(config.getRealityThreshold()) ? MiniVisionConstant.REALITY_THRESHOLD : config.getRealityThreshold();
        this.config.setRealityThreshold(realityThreshold);
        Criteria<Image, Float> criteria = LivenessCriteriaFactory.createCriteria(config);
        try {
            this.model = criteria.loadModel();
            this.predictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.model));
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            throw new FaceException("\u963f\u91cc\u901a\u4e49\u5b9e\u9a8c\u5ba4\u6d3b\u4f53\u68c0\u6d4b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
        int predictorPoolSize = config.getPredictorPoolSize();
        if (config.getPredictorPoolSize() <= 0) {
            predictorPoolSize = Runtime.getRuntime().availableProcessors();
        }
        this.predictorPool.setMaxTotal(predictorPoolSize);
        log.debug("\u5f53\u524d\u8bbe\u5907: " + this.model.getNDManager().getDevice());
        log.debug("\u5f53\u524d\u5f15\u64ce: " + Engine.getInstance().getEngineName());
        log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
    }

    @Override
    public R<LivenessResult> detect(BufferedImage image, DetectionRectangle faceDetectionRectangle) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        Predictor predictor = null;
        Image djlImage = null;
        try {
            Float result;
            predictor = (Predictor)this.predictorPool.borrowObject();
            BufferedImage processedImage = image;
            if (this.config.getModelEnum() == LivenessModelEnum.IIC_FL_MODEL) {
                processedImage = new BufferedImagePreprocessor(image, faceDetectionRectangle).setExtendRatio(0.85714287f).enableSquarePadding(true).enableScaling(true).setTargetSize(128).enableCenterCrop(true).setCenterCropSize(112).process();
            }
            if ((result = (Float)predictor.predict((Object)(djlImage = ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)processedImage))))).floatValue() >= this.config.getRealityThreshold().floatValue()) {
                R r = R.ok((Object)new LivenessResult(LivenessStatus.LIVE, result.floatValue()));
                return r;
            }
            float nonLiveScore = BigDecimal.ONE.subtract(new BigDecimal(result.floatValue())).floatValue();
            R r = R.ok((Object)new LivenessResult(LivenessStatus.NON_LIVE, nonLiveScore));
            return r;
        }
        catch (Exception e) {
            throw new FaceException("\u6d3b\u4f53\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (predictor != null) {
                try {
                    this.predictorPool.returnObject((Object)predictor);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    try {
                        predictor.close();
                    }
                    catch (Exception ex) {
                        log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                    }
                }
            }
            if (djlImage != null) {
                ((Mat)djlImage.getWrappedImage()).release();
            }
        }
    }

    @Override
    public R<LivenessResult> detect(String imagePath, DetectionRectangle faceDetectionRectangle) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.detect(image, faceDetectionRectangle);
    }

    @Override
    public R<LivenessResult> detect(byte[] imageData, DetectionRectangle faceDetectionRectangle) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        try {
            return this.detect(ImageIO.read(new ByteArrayInputStream(imageData)), faceDetectionRectangle);
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public R<LivenessResult> detectBase64(String base64Image, DetectionRectangle faceDetectionRectangle) {
        if (StringUtils.isBlank((CharSequence)base64Image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        byte[] imageData = Base64ImageUtils.base64ToImage((String)base64Image);
        return this.detect(imageData, faceDetectionRectangle);
    }

    @Override
    public R<List<LivenessResult>> detect(String imagePath, DetectionResponse faceDetectionResponse) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.detect(image, faceDetectionResponse);
    }

    @Override
    public R<List<LivenessResult>> detect(byte[] imageData, DetectionResponse faceDetectionResponse) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        try {
            return this.detect(ImageIO.read(new ByteArrayInputStream(imageData)), faceDetectionResponse);
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public R<List<LivenessResult>> detect(BufferedImage image, DetectionResponse faceDetectionResponse) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        if (Objects.isNull(faceDetectionResponse) || Objects.isNull(faceDetectionResponse.getDetectionInfoList()) || faceDetectionResponse.getDetectionInfoList().isEmpty()) {
            R.fail((R.Status)R.Status.NO_FACE_DETECTED);
        }
        ArrayList<Object> livenessStatusList = new ArrayList<Object>();
        for (DetectionInfo detectionInfo : faceDetectionResponse.getDetectionInfoList()) {
            R<LivenessResult> result = this.detect(image, detectionInfo.getDetectionRectangle());
            if (!result.isSuccess()) {
                return R.fail((Integer)result.getCode(), (String)result.getMessage());
            }
            livenessStatusList.add(result.getData());
        }
        return R.ok(livenessStatusList);
    }

    @Override
    public R<List<LivenessResult>> detectBase64(String base64Image, DetectionResponse faceDetectionResponse) {
        if (StringUtils.isBlank((CharSequence)base64Image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        byte[] imageData = Base64ImageUtils.base64ToImage((String)base64Image);
        return this.detect(imageData, faceDetectionResponse);
    }

    @Override
    public R<LivenessResult> detectTopFace(BufferedImage image) {
        if (Objects.isNull(this.config.getDetectModel())) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"\u672a\u6307\u5b9a\u68c0\u6d4b\u6a21\u578b");
        }
        R<DetectionResponse> faceDetectionResponse = this.config.getDetectModel().detect(image);
        if (Objects.isNull(faceDetectionResponse.getData()) || Objects.isNull(((DetectionResponse)faceDetectionResponse.getData()).getDetectionInfoList()) || ((DetectionResponse)faceDetectionResponse.getData()).getDetectionInfoList().isEmpty()) {
            return R.fail((R.Status)R.Status.NO_FACE_DETECTED);
        }
        return this.detect(image, ((DetectionInfo)((DetectionResponse)faceDetectionResponse.getData()).getDetectionInfoList().get(0)).getDetectionRectangle());
    }

    @Override
    public R<LivenessResult> detectTopFace(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.detectTopFace(image);
    }

    @Override
    public R<LivenessResult> detectTopFace(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        try {
            return this.detectTopFace(ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public R<LivenessResult> detectTopFaceBase64(String base64Image) {
        if (StringUtils.isBlank((CharSequence)base64Image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        byte[] imageData = Base64ImageUtils.base64ToImage((String)base64Image);
        return this.detectTopFace(imageData);
    }

    @Override
    public R<DetectionResponse> detect(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.detect(image);
    }

    @Override
    public R<DetectionResponse> detect(BufferedImage image) {
        if (Objects.isNull(this.config.getDetectModel())) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"\u672a\u6307\u5b9a\u68c0\u6d4b\u6a21\u578b");
        }
        R<DetectionResponse> faceDetectionResponse = this.config.getDetectModel().detect(image);
        if (Objects.isNull(faceDetectionResponse.getData()) || Objects.isNull(((DetectionResponse)faceDetectionResponse.getData()).getDetectionInfoList()) || ((DetectionResponse)faceDetectionResponse.getData()).getDetectionInfoList().isEmpty()) {
            return R.fail((R.Status)R.Status.NO_FACE_DETECTED);
        }
        for (DetectionInfo detectionInfo : ((DetectionResponse)faceDetectionResponse.getData()).getDetectionInfoList()) {
            R<LivenessResult> result = this.detect(image, detectionInfo.getDetectionRectangle());
            if (!result.isSuccess()) {
                return R.fail((Integer)result.getCode(), (String)result.getMessage());
            }
            if (Objects.isNull(detectionInfo.getFaceInfo())) {
                detectionInfo.setFaceInfo(new FaceInfo());
            }
            detectionInfo.getFaceInfo().setLivenessStatus((LivenessResult)result.getData());
        }
        return faceDetectionResponse;
    }

    @Override
    public R<DetectionResponse> detect(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        try {
            return this.detect(ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public R<DetectionResponse> detectBase64(String base64Image) {
        if (StringUtils.isBlank((CharSequence)base64Image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        byte[] imageData = Base64ImageUtils.base64ToImage((String)base64Image);
        return this.detect(imageData);
    }

    @Override
    public R<LivenessResult> detectVideo(InputStream videoInputStream) {
        if (Objects.isNull(videoInputStream)) {
            return R.fail((R.Status)R.Status.INVALID_VIDEO);
        }
        return this.detectVideo(new FFmpegFrameGrabber(videoInputStream));
    }

    @Override
    public R<LivenessResult> detectVideo(String videoPath) {
        if (!FileUtils.isFileExists((String)videoPath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        return this.detectVideo(new FFmpegFrameGrabber(videoPath));
    }

    private R<LivenessResult> detectVideo(FFmpegFrameGrabber grabber) {
        try {
            ArrayDeque<Float> scoreWindow = new ArrayDeque<Float>();
            grabber.start();
            int totalFrames = grabber.getLengthInFrames();
            log.debug("\u89c6\u9891\u603b\u5e27\u6570\uff1a{}\uff0c\u68c0\u6d4b\u5e27\u6570\uff1a{}", (Object)totalFrames, (Object)this.config.getFrameCount());
            if (totalFrames < this.config.getFrameCount()) {
                return R.fail((Integer)10001, (String)"\u89c6\u9891\u5e27\u6570\u4f4e\u4e8e\u68c0\u6d4b\u5e27\u6570");
            }
            for (int frameIndex = 0; frameIndex < totalFrames; ++frameIndex) {
                if (frameIndex >= this.config.getMaxVideoDetectFrames()) {
                    return R.fail((Integer)10002, (String)("\u8d85\u51fa\u6700\u5927\u68c0\u6d4b\u5e27\u6570\uff1a" + this.config.getMaxVideoDetectFrames()));
                }
                Frame frame = grabber.grabImage();
                if (frame == null) continue;
                BufferedImage bufferedImage = Java2DFrameUtils.toBufferedImage((Frame)frame);
                R<LivenessResult> livenessStatus = this.detectTopFace(bufferedImage);
                if (!livenessStatus.isSuccess()) {
                    log.debug("\u7b2c" + frameIndex + "\u5e27\u5904\u7406\u5931\u8d25\uff1a" + livenessStatus.getMessage());
                    continue;
                }
                log.debug("\u7b2c" + frameIndex + "\u5e27\u6d3b\u4f53\u68c0\u6d4b\u7ed3\u679c\uff1a" + JsonUtils.toJson(livenessStatus));
                float liveScore = 0.0f;
                liveScore = ((LivenessResult)livenessStatus.getData()).getStatus() == LivenessStatus.LIVE ? ((LivenessResult)livenessStatus.getData()).getScore() : BigDecimal.ONE.subtract(BigDecimal.valueOf(((LivenessResult)livenessStatus.getData()).getScore())).floatValue();
                scoreWindow.add(Float.valueOf(liveScore));
                if (scoreWindow.size() < this.config.getFrameCount()) continue;
                float avgScore = (float)scoreWindow.stream().mapToDouble(Float::doubleValue).average().orElse(0.0);
                log.debug("\u6ed1\u52a8\u7a97\u53e3\u5e73\u5747\u5f97\u5206: {}", (Object)Float.valueOf(avgScore));
                if (avgScore >= this.config.getRealityThreshold().floatValue()) {
                    grabber.stop();
                    return R.ok((Object)new LivenessResult(LivenessStatus.LIVE, avgScore));
                }
                grabber.stop();
                float nonLiveScore = BigDecimal.ONE.subtract(BigDecimal.valueOf(avgScore)).floatValue();
                return R.ok((Object)new LivenessResult(LivenessStatus.NON_LIVE, nonLiveScore));
            }
            grabber.stop();
            if (scoreWindow.size() < this.config.getFrameCount()) {
                return R.fail((Integer)1000, (String)"\u6709\u6548\u5e27\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5b8c\u6210\u6d3b\u4f53\u68c0\u6d4b");
            }
        }
        catch (Exception e) {
            throw new FaceException(e);
        }
        return R.fail((R.Status)R.Status.Unknown);
    }

    @Override
    public GenericObjectPool<Predictor<Image, Float>> getPool() {
        return this.predictorPool;
    }

    @Override
    public void close() throws Exception {
        try {
            if (this.predictorPool != null) {
                this.predictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.model != null) {
                this.model.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
    }
}

