/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.utils;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.common.utils.OpenCVUtils;
import cn.smartjavaai.face.utils.FaceUtils;
import com.seeta.sdk.SeetaImageData;
import com.seeta.sdk.SeetaPointF;
import java.awt.image.BufferedImage;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class FaceAlignUtils {
    public static Mat warpAffine(Mat src, Mat rot_mat) {
        Mat rot = new Mat();
        Scalar scalar = new Scalar(135.0, 133.0, 132.0);
        Size size = new Size(512.0, 512.0);
        Imgproc.warpAffine((Mat)src, (Mat)rot, (Mat)rot_mat, (Size)size, (int)0, (int)0, (Scalar)scalar);
        return rot;
    }

    public static Mat warpAffine(Mat src, Mat rot_mat, int width, int height) {
        Mat rot = new Mat();
        Size size = new Size((double)width, (double)height);
        Scalar scalar = new Scalar(135.0, 133.0, 132.0);
        Imgproc.warpAffine((Mat)src, (Mat)rot, (Mat)rot_mat, (Size)size, (int)0, (int)0, (Scalar)scalar);
        return rot;
    }

    public static Mat warpAffine(Mat src, Mat rot_mat, int width, int height, int flags) {
        Mat rot = new Mat();
        Size size = new Size((double)width, (double)height);
        Imgproc.warpAffine((Mat)src, (Mat)rot, (Mat)rot_mat, (Size)size, (int)flags);
        return rot;
    }

    public static SeetaImageData faceAlign(BufferedImage sourceImage, SeetaPointF[] pointFS) {
        NDManager manager = NDManager.newBaseManager();
        double[][] pointsArray = FaceUtils.facePoints(pointFS);
        NDArray srcPoints = manager.create(pointsArray);
        NDArray dstPoints = FaceUtils.faceTemplate512x512(manager);
        Mat affine_matrix = OpenCVUtils.toOpenCVMat((NDManager)manager, (NDArray)srcPoints, (NDArray)dstPoints);
        Mat mat = FaceAlignUtils.warpAffine(OpenCVUtils.image2Mat((BufferedImage)sourceImage), affine_matrix);
        BufferedImage alignImage = OpenCVUtils.mat2Image((Mat)mat);
        SeetaImageData imageData = new SeetaImageData(alignImage.getWidth(), alignImage.getHeight(), 3);
        imageData.data = ImageUtils.getMatrixBGR((BufferedImage)alignImage);
        return imageData;
    }
}

