/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.factory;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.ocr.config.PlateDetModelConfig;
import cn.smartjavaai.ocr.config.PlateRecModelConfig;
import cn.smartjavaai.ocr.enums.PlateDetModelEnum;
import cn.smartjavaai.ocr.enums.PlateRecModelEnum;
import cn.smartjavaai.ocr.exception.OcrException;
import cn.smartjavaai.ocr.model.plate.CRNNPlateRecModel;
import cn.smartjavaai.ocr.model.plate.PlateDetModel;
import cn.smartjavaai.ocr.model.plate.PlateRecModel;
import cn.smartjavaai.ocr.model.plate.Yolov5PlateDetModel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlateModelFactory {
    private static final Logger log = LoggerFactory.getLogger(PlateModelFactory.class);
    private static volatile PlateModelFactory instance;
    private static final ConcurrentHashMap<PlateDetModelEnum, PlateDetModel> detModelMap;
    private static final ConcurrentHashMap<PlateRecModelEnum, PlateRecModel> recModelMap;
    private static final Map<PlateDetModelEnum, Class<? extends PlateDetModel>> detModelRegistry;
    private static final Map<PlateRecModelEnum, Class<? extends PlateRecModel>> recModelRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlateModelFactory getInstance() {
        if (instance != null) return instance;
        Class<PlateModelFactory> clazz = PlateModelFactory.class;
        synchronized (PlateModelFactory.class) {
            if (instance != null) return instance;
            instance = new PlateModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void registerDetModel(PlateDetModelEnum plateDetModelEnum, Class<? extends PlateDetModel> clazz) {
        detModelRegistry.put(plateDetModelEnum, clazz);
    }

    private static void registerRecModel(PlateRecModelEnum plateRecModelEnum, Class<? extends PlateRecModel> clazz) {
        recModelRegistry.put(plateRecModelEnum, clazz);
    }

    public PlateDetModel getDetModel(PlateDetModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new OcrException("\u672a\u914d\u7f6eOCR\u6a21\u578b");
        }
        return detModelMap.computeIfAbsent(config.getModelEnum(), k -> this.createDetModel(config));
    }

    public PlateRecModel getRecModel(PlateRecModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new OcrException("\u672a\u914d\u7f6eOCR\u6a21\u578b");
        }
        return recModelMap.computeIfAbsent(config.getModelEnum(), k -> this.createRecModel(config));
    }

    private PlateDetModel createDetModel(PlateDetModelConfig config) {
        Class<? extends PlateDetModel> clazz = detModelRegistry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new OcrException("Unsupported model");
        }
        PlateDetModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new OcrException(e);
        }
        model.loadModel(config);
        return model;
    }

    private PlateRecModel createRecModel(PlateRecModelConfig config) {
        Class<? extends PlateRecModel> clazz = recModelRegistry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new OcrException("Unsupported model");
        }
        PlateRecModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new OcrException(e);
        }
        model.loadModel(config);
        return model;
    }

    static {
        detModelMap = new ConcurrentHashMap();
        recModelMap = new ConcurrentHashMap();
        detModelRegistry = new ConcurrentHashMap<PlateDetModelEnum, Class<? extends PlateDetModel>>();
        recModelRegistry = new ConcurrentHashMap<PlateRecModelEnum, Class<? extends PlateRecModel>>();
        PlateModelFactory.registerDetModel(PlateDetModelEnum.YOLOV5, Yolov5PlateDetModel.class);
        PlateModelFactory.registerDetModel(PlateDetModelEnum.YOLOV7, Yolov5PlateDetModel.class);
        PlateModelFactory.registerRecModel(PlateRecModelEnum.PLATE_REC_CRNN, CRNNPlateRecModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

