/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.model.plate;

import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.common.utils.Base64ImageUtils;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.common.utils.OpenCVUtils;
import cn.smartjavaai.ocr.config.PlateDetModelConfig;
import cn.smartjavaai.ocr.entity.PlateInfo;
import cn.smartjavaai.ocr.exception.OcrException;
import cn.smartjavaai.ocr.model.plate.PlateDetModel;
import cn.smartjavaai.ocr.model.plate.criteria.PlateDetCriterialFactory;
import cn.smartjavaai.ocr.utils.OcrUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.opencv.core.Mat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Yolov5PlateDetModel
implements PlateDetModel {
    private static final Logger log = LoggerFactory.getLogger(Yolov5PlateDetModel.class);
    private GenericObjectPool<Predictor<Image, DetectedObjects>> detPredictorPool;
    private ZooModel<Image, DetectedObjects> detectionModel;
    private PlateDetModelConfig config;

    @Override
    public void loadModel(PlateDetModelConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new OcrException("modelPath is null");
        }
        this.config = config;
        Criteria<Image, DetectedObjects> detCriteria = PlateDetCriterialFactory.createCriteria(config);
        try {
            this.detectionModel = ModelZoo.loadModel(detCriteria);
            this.detPredictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.detectionModel));
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.detPredictorPool.setMaxTotal(predictorPoolSize);
            log.debug("\u5f53\u524d\u8bbe\u5907: " + this.detectionModel.getNDManager().getDevice());
            log.debug("\u5f53\u524d\u5f15\u64ce: " + Engine.getInstance().getEngineName());
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            throw new OcrException("\u68c0\u6d4b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
    }

    @Override
    public R<List<PlateInfo>> detect(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image img = null;
        try {
            img = ImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
        }
        catch (IOException e) {
            throw new OcrException("\u65e0\u6548\u7684\u56fe\u7247", e);
        }
        DetectedObjects detectedObjects = this.detect(img);
        if (Objects.isNull(detectedObjects) || detectedObjects.getNumberOfObjects() == 0) {
            return R.fail((R.Status)R.Status.NO_OBJECT_DETECTED);
        }
        List<PlateInfo> plateInfoList = OcrUtils.convertToPlateInfo(detectedObjects, img);
        ((Mat)img.getWrappedImage()).release();
        return R.ok(plateInfoList);
    }

    @Override
    public R<List<PlateInfo>> detectBase64(String base64Image) {
        if (StringUtils.isBlank((CharSequence)base64Image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        byte[] imageData = Base64ImageUtils.base64ToImage((String)base64Image);
        return this.detect(imageData);
    }

    @Override
    public R<List<PlateInfo>> detect(BufferedImage image) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image img = ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)image));
        DetectedObjects detectedObjects = this.detect(img);
        if (Objects.isNull(detectedObjects) || detectedObjects.getNumberOfObjects() == 0) {
            return R.fail((R.Status)R.Status.NO_OBJECT_DETECTED);
        }
        List<PlateInfo> plateInfoList = OcrUtils.convertToPlateInfo(detectedObjects, img);
        ((Mat)img.getWrappedImage()).release();
        return R.ok(plateInfoList);
    }

    @Override
    public R<List<PlateInfo>> detect(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        return this.detect(new ByteArrayInputStream(imageData));
    }

    @Override
    public DetectedObjects detect(Image image) {
        Predictor predictor = null;
        try {
            predictor = (Predictor)this.detPredictorPool.borrowObject();
            DetectedObjects detectedObjects = (DetectedObjects)predictor.predict((Object)image);
            return detectedObjects;
        }
        catch (Exception e) {
            throw new OcrException("\u8f66\u724c\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (predictor != null) {
                try {
                    this.detPredictorPool.returnObject((Object)predictor);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    try {
                        predictor.close();
                    }
                    catch (Exception ex) {
                        log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public R<List<PlateInfo>> detect(InputStream inputStream) {
        if (Objects.isNull(inputStream)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        try {
            Image img = ImageFactory.getInstance().fromInputStream(inputStream);
            DetectedObjects detection = this.detect(img);
            List<PlateInfo> plateInfoList = OcrUtils.convertToPlateInfo(detection, img);
            ((Mat)img.getWrappedImage()).release();
            return R.ok(plateInfoList);
        }
        catch (IOException e) {
            throw new OcrException("\u65e0\u6548\u56fe\u7247\u8f93\u5165\u6d41", e);
        }
    }

    @Override
    public R<Void> detectAndDraw(String imagePath, String outputPath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        try {
            Image img = ImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
            DetectedObjects detectedObjects = this.detect(img);
            if (Objects.isNull(detectedObjects) || detectedObjects.getNumberOfObjects() == 0) {
                return R.fail((R.Status)R.Status.NO_FACE_DETECTED);
            }
            img.drawBoundingBoxes(detectedObjects);
            Path output = Paths.get(outputPath, new String[0]);
            log.debug("Saving to {}", (Object)output.toAbsolutePath().toString());
            img.save(Files.newOutputStream(output, new OpenOption[0]), "png");
            return R.ok();
        }
        catch (IOException e) {
            throw new OcrException(e);
        }
    }

    @Override
    public R<BufferedImage> detectAndDraw(BufferedImage sourceImage) {
        if (!ImageUtils.isImageValid((BufferedImage)sourceImage)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image img = ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)sourceImage));
        DetectedObjects detectedObjects = this.detect(img);
        if (Objects.isNull(detectedObjects) || detectedObjects.getNumberOfObjects() == 0) {
            return R.fail((R.Status)R.Status.NO_FACE_DETECTED);
        }
        img.drawBoundingBoxes(detectedObjects);
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            img.save((OutputStream)outputStream, "png");
            byte[] imageBytes = outputStream.toByteArray();
            return R.ok((Object)ImageIO.read(new ByteArrayInputStream(imageBytes)));
        }
        catch (IOException e) {
            throw new OcrException("\u5bfc\u51fa\u56fe\u7247\u5931\u8d25", e);
        }
    }

    @Override
    public GenericObjectPool<Predictor<Image, DetectedObjects>> getPool() {
        return this.detPredictorPool;
    }

    @Override
    public void close() throws Exception {
        try {
            if (this.detPredictorPool != null) {
                this.detPredictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.detectionModel != null) {
                this.detectionModel.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
    }
}

