/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.opencv;

import ai.djl.ndarray.NDArray;
import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Point;

public class OcrNDArrayUtils {
    public static MatOfPoint matToMatOfPoint(Mat mat) {
        int rows = mat.rows();
        MatOfPoint matOfPoint = new MatOfPoint();
        ArrayList<Point> list = new ArrayList<Point>();
        for (int i = 0; i < rows; ++i) {
            Point point = new Point((double)((float)mat.get(i, 0)[0]), (double)((float)mat.get(i, 1)[0]));
            list.add(point);
        }
        matOfPoint.fromList(list);
        return matOfPoint;
    }

    public static float[][] floatNDArrayToArray(NDArray ndArray) {
        int rows = (int)ndArray.getShape().get(0);
        int cols = (int)ndArray.getShape().get(1);
        float[][] arr = new float[rows][cols];
        float[] arrs = ndArray.toFloatArray();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                arr[i][j] = arrs[i * cols + j];
            }
        }
        return arr;
    }

    public static double[][] matToDoubleArray(Mat mat) {
        int rows = mat.rows();
        int cols = mat.cols();
        double[][] doubles = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                doubles[i][j] = mat.get(i, j)[0];
            }
        }
        return doubles;
    }

    public static float[][] matToFloatArray(Mat mat) {
        int rows = mat.rows();
        int cols = mat.cols();
        float[][] floats = new float[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                floats[i][j] = (float)mat.get(i, j)[0];
            }
        }
        return floats;
    }

    public static byte[][] matToUint8Array(Mat mat) {
        int rows = mat.rows();
        int cols = mat.cols();
        byte[][] bytes = new byte[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                bytes[i][j] = (byte)mat.get(i, j)[0];
            }
        }
        return bytes;
    }

    public static Mat floatNDArrayToMat(NDArray ndArray, int cvType) {
        int rows = (int)ndArray.getShape().get(0);
        int cols = (int)ndArray.getShape().get(1);
        Mat mat = new Mat(rows, cols, cvType);
        float[] arrs = ndArray.toFloatArray();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                mat.put(i, j, new double[]{arrs[i * cols + j]});
            }
        }
        return mat;
    }

    public static Mat floatNDArrayToMat(NDArray ndArray) {
        int rows = (int)ndArray.getShape().get(0);
        int cols = (int)ndArray.getShape().get(1);
        Mat mat = new Mat(rows, cols, 5);
        float[] arrs = ndArray.toFloatArray();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                mat.put(i, j, new double[]{arrs[i * cols + j]});
            }
        }
        return mat;
    }

    public static Mat uint8NDArrayToMat(NDArray ndArray) {
        int rows = (int)ndArray.getShape().get(0);
        int cols = (int)ndArray.getShape().get(1);
        Mat mat = new Mat(rows, cols, 0);
        byte[] arrs = ndArray.toByteArray();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                mat.put(i, j, new double[]{arrs[i * cols + j]});
            }
        }
        return mat;
    }

    public static Mat floatArrayToMat(float[][] arr) {
        int rows = arr.length;
        int cols = arr[0].length;
        Mat mat = new Mat(rows, cols, 5);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                mat.put(i, j, new double[]{arr[i][j]});
            }
        }
        return mat;
    }

    public static Mat uint8ArrayToMat(byte[][] arr) {
        int rows = arr.length;
        int cols = arr[0].length;
        Mat mat = new Mat(rows, cols, 0);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                mat.put(i, j, new double[]{arr[i][j]});
            }
        }
        return mat;
    }

    public static Mat toMat(List<ai.djl.modality.cv.output.Point> points) {
        Mat mat = new Mat(points.size(), 2, 5);
        for (int i = 0; i < points.size(); ++i) {
            ai.djl.modality.cv.output.Point point = points.get(i);
            mat.put(i, 0, new double[]{(float)point.getX()});
            mat.put(i, 1, new double[]{(float)point.getY()});
        }
        return mat;
    }
}

