/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.utils;

import cn.smartjavaai.ocr.utils.CrossRangeCellMeta;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ConvertHtml2Excel {
    public static HSSFWorkbook table2Excel(String tableHtml) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        ArrayList<CrossRangeCellMeta> crossRowEleMetaLs = new ArrayList<CrossRangeCellMeta>();
        int rowIndex = 0;
        try {
            HSSFRow row;
            Document data = DocumentHelper.parseText((String)tableHtml);
            Element thead = data.getRootElement().element("thead");
            HSSFCellStyle titleStyle = ConvertHtml2Excel.getTitleStyle(wb);
            int ls = 0;
            if (thead != null) {
                List trLs = thead.elements("tr");
                for (Element trEle : trLs) {
                    row = sheet.createRow(rowIndex);
                    List thLs = trEle.elements("td");
                    ls = thLs.size();
                    ConvertHtml2Excel.makeRowCell(thLs, rowIndex, row, 0, titleStyle, crossRowEleMetaLs);
                    ++rowIndex;
                }
            }
            Element tbody = data.getRootElement().element("tbody");
            HSSFCellStyle contentStyle = ConvertHtml2Excel.getContentStyle(wb);
            if (tbody != null) {
                List trLs = tbody.elements("tr");
                row = trLs.iterator();
                while (row.hasNext()) {
                    Element trEle = (Element)row.next();
                    HSSFRow row2 = sheet.createRow(rowIndex);
                    List thLs = trEle.elements("th");
                    int cellIndex = ConvertHtml2Excel.makeRowCell(thLs, rowIndex, row2, 0, titleStyle, crossRowEleMetaLs);
                    List tdLs = trEle.elements("td");
                    ConvertHtml2Excel.makeRowCell(tdLs, rowIndex, row2, cellIndex, contentStyle, crossRowEleMetaLs);
                    ++rowIndex;
                }
            }
            for (CrossRangeCellMeta crcm : crossRowEleMetaLs) {
                sheet.addMergedRegion(new CellRangeAddress(crcm.getFirstRow(), crcm.getLastRow(), crcm.getFirstCol(), crcm.getLastCol()));
                ConvertHtml2Excel.setRegionStyle(sheet, new CellRangeAddress(crcm.getFirstRow(), crcm.getLastRow(), crcm.getFirstCol(), crcm.getLastCol()), titleStyle);
            }
            for (int i = 0; i < sheet.getRow(0).getPhysicalNumberOfCells(); ++i) {
                sheet.autoSizeColumn(i, true);
                if (sheet.getColumnWidth(i) < 65280) {
                    sheet.setColumnWidth(i, sheet.getColumnWidth(i) < 9000 ? 9000 : sheet.getColumnWidth(i));
                    continue;
                }
                sheet.setColumnWidth(i, 15000);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return wb;
    }

    private static int makeRowCell(List<Element> tdLs, int rowIndex, HSSFRow row, int startCellIndex, HSSFCellStyle cellStyle, List<CrossRangeCellMeta> crossRowEleMetaLs) {
        int i = startCellIndex;
        for (int eleIndex = 0; eleIndex < tdLs.size(); ++eleIndex) {
            Element e;
            int captureCellSize = ConvertHtml2Excel.getCaptureCellSize(rowIndex, i, crossRowEleMetaLs);
            while (captureCellSize > 0) {
                for (int j = 0; j < captureCellSize; ++j) {
                    row.createCell(i);
                    ++i;
                }
                captureCellSize = ConvertHtml2Excel.getCaptureCellSize(rowIndex, i, crossRowEleMetaLs);
            }
            Element thEle = tdLs.get(eleIndex);
            String val = thEle.getTextTrim();
            if (StringUtils.isBlank((CharSequence)val) && (e = thEle.element("a")) != null) {
                val = e.getTextTrim();
            }
            HSSFCell c = row.createCell(i);
            if (NumberUtils.isNumber((String)val)) {
                c.setCellValue(Double.parseDouble(val));
                c.setCellType(CellType.NUMERIC);
            } else {
                c.setCellValue(val);
            }
            int rowSpan = NumberUtils.toInt((String)thEle.attributeValue("rowspan"), (int)1);
            int colSpan = NumberUtils.toInt((String)thEle.attributeValue("colspan"), (int)1);
            c.setCellStyle(cellStyle);
            if (rowSpan > 1 || colSpan > 1) {
                crossRowEleMetaLs.add(new CrossRangeCellMeta(rowIndex, i, rowSpan, colSpan));
            }
            if (colSpan > 1) {
                for (int j = 1; j < colSpan; ++j) {
                    row.createCell(++i);
                }
            }
            ++i;
        }
        return i;
    }

    public static void setRegionStyle(HSSFSheet sheet, CellRangeAddress region, HSSFCellStyle cs) {
        for (int i = region.getFirstRow(); i <= region.getLastRow(); ++i) {
            HSSFRow row = sheet.getRow(i);
            for (int j = region.getFirstColumn(); j <= region.getLastColumn(); ++j) {
                HSSFCell cell = row.getCell(j);
                cell.setCellStyle(cs);
            }
        }
    }

    private static int getCaptureCellSize(int rowIndex, int colIndex, List<CrossRangeCellMeta> crossRowEleMetaLs) {
        int captureCellSize = 0;
        for (CrossRangeCellMeta crossRangeCellMeta : crossRowEleMetaLs) {
            if (crossRangeCellMeta.getFirstRow() >= rowIndex || crossRangeCellMeta.getLastRow() < rowIndex || crossRangeCellMeta.getFirstCol() > colIndex || crossRangeCellMeta.getLastCol() < colIndex) continue;
            captureCellSize = crossRangeCellMeta.getLastCol() - colIndex + 1;
        }
        return captureCellSize;
    }

    private static HSSFCellStyle getTitleStyle(HSSFWorkbook workbook) {
        short fontSize = 12;
        String fontName = "\u5b8b\u4f53";
        HSSFCellStyle style = workbook.createCellStyle();
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        HSSFFont font = workbook.createFont();
        font.setFontName(fontName);
        font.setFontHeightInPoints(fontSize);
        font.setBold(true);
        style.setFont(font);
        return style;
    }

    private static HSSFCellStyle getContentStyle(HSSFWorkbook wb) {
        short fontSize = 12;
        String fontName = "\u5b8b\u4f53";
        HSSFCellStyle style = wb.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        HSSFFont font = wb.createFont();
        font.setFontName(fontName);
        font.setFontHeightInPoints(fontSize);
        style.setFont(font);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        return style;
    }
}

