/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.speech.asr.audio;

import ai.djl.modality.audio.Audio;
import cn.smartjavaai.speech.asr.exception.AsrException;
import cn.smartjavaai.speech.utils.AudioUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.schild.jave.EncoderException;

public class SmartAudioFactory {
    private static final Logger log = LoggerFactory.getLogger(SmartAudioFactory.class);
    private static final SmartAudioFactory INSTANCE = new SmartAudioFactory();

    private SmartAudioFactory() {
    }

    public static SmartAudioFactory getInstance() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Audio fromFile(Path path, AudioFormat targetFormat) throws IOException {
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(path.toFile());
            if (targetFormat != null) {
                try (AudioInputStream convertedAis = AudioSystem.getAudioInputStream(targetFormat, ais);){
                    byte[] bytes = this.read(convertedAis);
                    float[] floats = this.bytesToFloats(bytes, targetFormat.isBigEndian());
                    Audio audio = new Audio(floats, targetFormat.getSampleRate(), targetFormat.getChannels());
                    return audio;
                }
            }
            AudioFormat format = ais.getFormat();
            byte[] bytes = this.read(ais);
            float[] floats = this.bytesToFloats(bytes, format.isBigEndian());
            return new Audio(floats, format.getSampleRate(), format.getChannels());
            finally {
                if (ais != null) {
                    ais.close();
                }
            }
        }
        catch (UnsupportedAudioFileException e) {
            log.debug("Unsupported Audio file, Conversion to WAV is required");
            byte[] allBytes = Files.readAllBytes(path);
            try (AudioInputStream audioInputStream = this.convertWav(allBytes);){
                Audio audio = this.fromAudioInputStream(audioInputStream, targetFormat);
                return audio;
            }
        }
    }

    public Audio fromAudioInputStream(AudioInputStream ais, AudioFormat targetFormat) throws IOException {
        AudioInputStream audioInputStream = ais;
        if (targetFormat != null) {
            try (AudioInputStream convertedAis = AudioSystem.getAudioInputStream(targetFormat, audioInputStream);){
                byte[] bytes = this.read(convertedAis);
                float[] floats = this.bytesToFloats(bytes, targetFormat.isBigEndian());
                Audio audio = new Audio(floats, targetFormat.getSampleRate(), targetFormat.getChannels());
                return audio;
            }
        }
        AudioFormat format = audioInputStream.getFormat();
        byte[] bytes = this.read(audioInputStream);
        float[] floats = this.bytesToFloats(bytes, format.isBigEndian());
        Audio audio = new Audio(floats, format.getSampleRate(), format.getChannels());
        return audio;
        finally {
            if (audioInputStream != null) {
                audioInputStream.close();
            }
        }
    }

    public AudioInputStream convertWav(byte[] allBytes) {
        BufferedInputStream conversionStream = new BufferedInputStream(new ByteArrayInputStream(allBytes));
        File tempFile = null;
        try {
            AudioInputStream ais;
            tempFile = AudioUtils.audioFormatConversion(conversionStream, "wav");
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(tempFile));
            AudioInputStream audioInputStream = ais = AudioSystem.getAudioInputStream(fis);
            return audioInputStream;
        }
        catch (IOException | UnsupportedAudioFileException | EncoderException e) {
            throw new AsrException(e);
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
            if (conversionStream != null) {
                try {
                    ((InputStream)conversionStream).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public Audio fromInputStream(InputStream is, AudioFormat targetFormat) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 14[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] read(AudioInputStream ais) throws IOException {
        int read;
        AudioFormat format = ais.getFormat();
        int frameSize = format.getFrameSize();
        if (frameSize == -1) {
            frameSize = 1;
        }
        int size = (int)ais.getFrameLength() * frameSize;
        if (ais.getFrameLength() == -1L || size <= 0) {
            int read2;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((read2 = ais.read(buf)) != -1) {
                baos.write(buf, 0, read2);
            }
            return baos.toByteArray();
        }
        byte[] ret = new byte[size];
        byte[] buf = new byte[1024];
        int offset = 0;
        while ((read = ais.read(buf)) != -1) {
            System.arraycopy(buf, 0, ret, offset, read);
            offset += read;
        }
        return ret;
    }

    private float[] bytesToFloats(byte[] bytes, boolean isBigEndian) {
        ByteOrder order = isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        ShortBuffer buffer = ByteBuffer.wrap(bytes).order(order).asShortBuffer();
        short[] shorts = new short[buffer.capacity()];
        buffer.get(shorts);
        float[] floats = new float[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            floats[i] = (float)shorts[i] / 32767.0f;
        }
        return floats;
    }
}

