/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.translation.factory;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.translation.config.TranslationModelConfig;
import cn.smartjavaai.translation.exception.TranslationException;
import cn.smartjavaai.translation.model.NllbModel;
import cn.smartjavaai.translation.model.TranslationModel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationModelFactory {
    private static final Logger log = LoggerFactory.getLogger(TranslationModelFactory.class);
    private static volatile TranslationModelFactory instance;
    private static final ConcurrentHashMap<String, TranslationModel> modelMap;
    private static final Map<String, Class<? extends TranslationModel>> modelRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TranslationModelFactory getInstance() {
        if (instance != null) return instance;
        Class<TranslationModelFactory> clazz = TranslationModelFactory.class;
        synchronized (TranslationModelFactory.class) {
            if (instance != null) return instance;
            instance = new TranslationModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void registerCommonDetModel(String name, Class<? extends TranslationModel> clazz) {
        modelRegistry.put(name.toLowerCase(), clazz);
    }

    public TranslationModel getModel(TranslationModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new TranslationException("\u672a\u914d\u7f6eOCR\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum().name(), k -> this.createModel(config));
    }

    private TranslationModel createModel(TranslationModelConfig config) {
        Class<? extends TranslationModel> clazz = modelRegistry.get(config.getModelEnum().name().toLowerCase());
        if (clazz == null) {
            throw new TranslationException("Unsupported model");
        }
        TranslationModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new TranslationException(e);
        }
        model.loadModel(config);
        return model;
    }

    static {
        modelMap = new ConcurrentHashMap();
        modelRegistry = new ConcurrentHashMap<String, Class<? extends TranslationModel>>();
        TranslationModelFactory.registerCommonDetModel("NLLB_MODEL", NllbModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

