/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.auth;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.AES;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.stylefeng.roses.kernel.auth.api.AuthServiceApi;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.SsoServerApi;
import cn.stylefeng.roses.kernel.auth.api.TempSecretApi;
import cn.stylefeng.roses.kernel.auth.api.constants.LoginCacheConstants;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.enums.SsoClientTypeEnum;
import cn.stylefeng.roses.kernel.auth.api.exception.AuthException;
import cn.stylefeng.roses.kernel.auth.api.exception.enums.AuthExceptionEnum;
import cn.stylefeng.roses.kernel.auth.api.expander.AuthConfigExpander;
import cn.stylefeng.roses.kernel.auth.api.password.PasswordStoredEncryptApi;
import cn.stylefeng.roses.kernel.auth.api.password.PasswordTransferEncryptApi;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginRequest;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginResponse;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginWithTokenRequest;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.auth.api.pojo.sso.SsoLoginCodeRequest;
import cn.stylefeng.roses.kernel.auth.api.pojo.sso.SsoProperties;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.demo.expander.DemoConfigExpander;
import cn.stylefeng.roses.kernel.jwt.JwtTokenOperator;
import cn.stylefeng.roses.kernel.jwt.api.context.JwtContext;
import cn.stylefeng.roses.kernel.jwt.api.exception.enums.JwtExceptionEnum;
import cn.stylefeng.roses.kernel.jwt.api.pojo.config.JwtConfig;
import cn.stylefeng.roses.kernel.jwt.api.pojo.payload.DefaultJwtPayload;
import cn.stylefeng.roses.kernel.log.api.LoginLogServiceApi;
import cn.stylefeng.roses.kernel.message.api.expander.WebSocketConfigExpander;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import cn.stylefeng.roses.kernel.scanner.api.exception.ScannerException;
import cn.stylefeng.roses.kernel.scanner.api.exception.enums.ScannerExceptionEnum;
import cn.stylefeng.roses.kernel.scanner.api.holder.InitScanFlagHolder;
import cn.stylefeng.roses.kernel.security.api.DragCaptchaApi;
import cn.stylefeng.roses.kernel.security.api.ImageCaptchaApi;
import cn.stylefeng.roses.kernel.security.api.expander.SecurityConfigExpander;
import cn.stylefeng.roses.kernel.system.api.UserServiceApi;
import cn.stylefeng.roses.kernel.system.api.enums.UserStatusEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.user.UserLoginInfoDTO;
import cn.stylefeng.roses.kernel.validator.api.exception.enums.ValidatorExceptionEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl
implements AuthServiceApi {
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private SessionManagerApi sessionManagerApi;
    @Resource
    private PasswordStoredEncryptApi passwordStoredEncryptApi;
    @Resource
    private PasswordTransferEncryptApi passwordTransferEncryptApi;
    @Resource
    private LoginLogServiceApi loginLogServiceApi;
    @Resource
    private ImageCaptchaApi captchaApi;
    @Resource
    private DragCaptchaApi dragCaptchaApi;
    @Resource
    private SsoProperties ssoProperties;
    @Resource(name="loginErrorCountCacheApi")
    private CacheOperatorApi<Integer> loginErrorCountCacheApi;
    @Resource(name="caClientTokenCacheApi")
    private CacheOperatorApi<String> caClientTokenCacheApi;

    public LoginResponse login(LoginRequest loginRequest) {
        return this.loginAction(loginRequest, true, null);
    }

    public LoginResponse loginWithUserName(String username) {
        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setAccount(username);
        return this.loginAction(loginRequest, false, null);
    }

    public LoginResponse loginWithUserNameAndCaToken(String username, String caToken) {
        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setAccount(username);
        return this.loginAction(loginRequest, false, caToken);
    }

    public LoginResponse LoginWithToken(LoginWithTokenRequest loginWithTokenRequest) {
        JwtConfig jwtConfig = new JwtConfig();
        jwtConfig.setJwtSecret(AuthConfigExpander.getSsoJwtSecret());
        jwtConfig.setExpiredSeconds(Long.valueOf(0L));
        JwtTokenOperator jwtTokenOperator = new JwtTokenOperator(jwtConfig);
        Claims payload = null;
        try {
            payload = jwtTokenOperator.getJwtPayloadClaims(loginWithTokenRequest.getToken());
        }
        catch (Exception exception) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.SSO_TOKEN_PARSE_ERROR, new Object[]{exception.getMessage()});
        }
        Object userInfoEncryptString = payload.get((Object)"userInfo");
        if (ObjectUtil.isEmpty((Object)userInfoEncryptString)) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.SSO_TOKEN_GET_USER_ERROR);
        }
        String account = null;
        String caToken = null;
        try {
            AES aesUtil = SecureUtil.aes((byte[])Base64.decode((CharSequence)AuthConfigExpander.getSsoDataDecryptSecret()));
            String loginUserJson = aesUtil.decryptStr(userInfoEncryptString.toString(), CharsetUtil.CHARSET_UTF_8);
            JSONObject userInfoJsonObject = JSON.parseObject((String)loginUserJson);
            account = userInfoJsonObject.getString("account");
            caToken = userInfoJsonObject.getString("caToken");
        }
        catch (Exception exception) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.SSO_TOKEN_DECRYPT_USER_ERROR, new Object[]{exception.getMessage()});
        }
        if (account == null) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.SSO_TOKEN_DECRYPT_USER_ERROR);
        }
        LoginResponse loginResponse = this.loginWithUserNameAndCaToken(account, caToken);
        this.caClientTokenCacheApi.put(loginWithTokenRequest.getToken(), (Object)loginResponse.getToken());
        return loginResponse;
    }

    public void logout() {
        String token = LoginContext.me().getToken();
        if (!DemoConfigExpander.getDemoEnvFlag().booleanValue() && StrUtil.isNotEmpty((CharSequence)token)) {
            this.loginLogServiceApi.loginOutSuccess(LoginContext.me().getLoginUser().getUserId());
        }
        this.logoutWithToken(token);
        this.sessionManagerApi.destroySessionCookie();
    }

    public void logoutWithToken(String token) {
        this.sessionManagerApi.removeSession(token);
    }

    public DefaultJwtPayload validateToken(String token) throws AuthException {
        try {
            JwtContext.me().validateTokenWithException(token);
            DefaultJwtPayload defaultPayload = JwtContext.me().getDefaultPayload(token);
            if (defaultPayload.getRememberMe().booleanValue()) {
                return defaultPayload;
            }
            LoginUser session = this.sessionManagerApi.getSession(token);
            if (session == null) {
                throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.AUTH_EXPIRED_ERROR);
            }
            return defaultPayload;
        }
        catch (cn.stylefeng.roses.kernel.jwt.api.exception.JwtException jwtException) {
            if (JwtExceptionEnum.JWT_EXPIRED_ERROR.getErrorCode().equals(jwtException.getErrorCode())) {
                throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.AUTH_EXPIRED_ERROR);
            }
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.TOKEN_PARSE_ERROR);
        }
        catch (JwtException jwtSelfException) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.TOKEN_PARSE_ERROR);
        }
    }

    public void checkAuth(String token, String requestUrl) {
        if (StrUtil.isEmpty((CharSequence)token)) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.TOKEN_GET_ERROR);
        }
        this.validateToken(token);
    }

    public void cancelFreeze(LoginRequest loginRequest) {
        this.loginErrorCountCacheApi.remove(new String[]{loginRequest.getAccount()});
    }

    public LoginUser createNewLoginInfo(String token, String account) {
        UserLoginInfoDTO userLoginInfo = this.userServiceApi.getUserLoginInfo(account);
        this.sessionManagerApi.updateSession(token, userLoginInfo.getLoginUser());
        return userLoginInfo.getLoginUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginResponse loginAction(LoginRequest loginRequest, Boolean validatePassword, String caToken) {
        String verKey;
        Integer loginErrorCount;
        if (validatePassword.booleanValue()) {
            if (loginRequest == null || StrUtil.hasBlank((CharSequence[])new CharSequence[]{loginRequest.getAccount(), loginRequest.getPassword()})) {
                throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.PARAM_EMPTY);
            }
        } else if (loginRequest == null || StrUtil.hasBlank((CharSequence[])new CharSequence[]{loginRequest.getAccount()})) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.ACCOUNT_IS_BLANK);
        }
        if ((loginErrorCount = (Integer)this.loginErrorCountCacheApi.get(loginRequest.getAccount())) != null && loginErrorCount >= LoginCacheConstants.MAX_ERROR_LOGIN_COUNT) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.LOGIN_LOCKED);
        }
        if (SecurityConfigExpander.getCaptchaOpen().booleanValue()) {
            verKey = loginRequest.getVerKey();
            String verCode = loginRequest.getVerCode();
            if (StrUtil.isEmpty((CharSequence)verKey) || StrUtil.isEmpty((CharSequence)verCode)) {
                throw new AuthException((AbstractExceptionEnum)ValidatorExceptionEnum.CAPTCHA_EMPTY);
            }
            if (!this.captchaApi.validateCaptcha(verKey, verCode)) {
                throw new AuthException((AbstractExceptionEnum)ValidatorExceptionEnum.CAPTCHA_ERROR);
            }
        }
        if (SecurityConfigExpander.getDragCaptchaOpen().booleanValue()) {
            verKey = loginRequest.getVerKey();
            String verXLocationValue = loginRequest.getVerCode();
            if (StrUtil.isEmpty((CharSequence)verKey) || StrUtil.isEmpty((CharSequence)verXLocationValue)) {
                throw new AuthException((AbstractExceptionEnum)ValidatorExceptionEnum.CAPTCHA_EMPTY);
            }
            if (!this.dragCaptchaApi.validateCaptcha(verKey, Convert.toInt((Object)verXLocationValue))) {
                throw new AuthException((AbstractExceptionEnum)ValidatorExceptionEnum.DRAG_CAPTCHA_ERROR);
            }
        }
        if (!InitScanFlagHolder.getFlag().booleanValue()) {
            throw new ScannerException((AbstractExceptionEnum)ScannerExceptionEnum.SYSTEM_RESOURCE_URL_NOT_INIT);
        }
        if (loginRequest.getPassword() != null && AuthConfigExpander.getPasswordRsaValidateFlag().booleanValue()) {
            String decryptPassword = this.passwordTransferEncryptApi.decrypt(loginRequest.getPassword());
            loginRequest.setPassword(decryptPassword);
        }
        if (this.ssoProperties.getOpenFlag().booleanValue() && StrUtil.isEmpty((CharSequence)caToken)) {
            if (SsoClientTypeEnum.client.name().equals(this.ssoProperties.getSsoClientType())) {
                String remoteLoginCode = this.getRemoteLoginCode(loginRequest);
                return new LoginResponse(remoteLoginCode);
            }
            SsoServerApi ssoServerApi = (SsoServerApi)SpringUtil.getBean(SsoServerApi.class);
            SsoLoginCodeRequest ssoLoginCodeRequest = new SsoLoginCodeRequest();
            ssoLoginCodeRequest.setAccount(loginRequest.getAccount());
            ssoLoginCodeRequest.setPassword(loginRequest.getPassword());
            String remoteLoginCode = ssoServerApi.createSsoLoginCode(ssoLoginCodeRequest);
            return new LoginResponse(remoteLoginCode);
        }
        UserLoginInfoDTO userValidateInfo = this.userServiceApi.getUserLoginInfo(loginRequest.getAccount());
        this.validateUserPassword(validatePassword, loginErrorCount, loginRequest, userValidateInfo);
        if (!UserStatusEnum.ENABLE.getCode().equals(userValidateInfo.getUserStatus())) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.USER_STATUS_ERROR, new Object[]{UserStatusEnum.getCodeMessage((Integer)userValidateInfo.getUserStatus())});
        }
        LoginUser loginUser = userValidateInfo.getLoginUser();
        DefaultJwtPayload defaultJwtPayload = new DefaultJwtPayload(loginUser.getUserId(), loginUser.getAccount(), loginRequest.getRememberMe().booleanValue(), caToken);
        String jwtToken = JwtContext.me().generateTokenDefaultPayload(defaultJwtPayload);
        loginUser.setToken(jwtToken);
        loginUser.setTenantCode(loginRequest.getTenantCode());
        String string = loginUser.getAccount().intern();
        synchronized (string) {
            loginUser.setWsUrl(WebSocketConfigExpander.getWebSocketWsUrl());
            this.sessionManagerApi.createSession(jwtToken, loginUser, loginRequest.getCreateCookie());
            if (AuthConfigExpander.getSingleAccountLoginFlag()) {
                this.sessionManagerApi.removeSessionExcludeToken(jwtToken);
            }
        }
        if (!DemoConfigExpander.getDemoEnvFlag().booleanValue()) {
            String ip = HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest());
            this.userServiceApi.updateUserLoginInfo(loginUser.getUserId(), new Date(), ip);
            this.loginLogServiceApi.loginSuccess(loginUser.getUserId());
        }
        this.cancelFreeze(loginRequest);
        return new LoginResponse(loginUser, jwtToken, defaultJwtPayload.getExpirationDate());
    }

    private String getRemoteLoginCode(LoginRequest loginRequest) {
        String ssoUrl = AuthConfigExpander.getSsoUrl();
        HttpRequest httpRequest = HttpRequest.post((String)(ssoUrl + "/sso/getLoginCode"));
        httpRequest.body(JSON.toJSONString((Object)loginRequest));
        HttpResponse httpResponse = httpRequest.execute();
        String body = httpResponse.body();
        JSONObject jsonObject = new JSONObject();
        if (StrUtil.isNotBlank((CharSequence)body)) {
            jsonObject = JSON.parseObject((String)body);
        }
        if (httpResponse.getStatus() != 200) {
            String message = jsonObject.getString("message");
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.SSO_LOGIN_CODE_GET_ERROR, new Object[]{message});
        }
        String loginCode = jsonObject.getString("data");
        if (loginCode == null) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.SSO_LOGIN_CODE_GET_ERROR, new Object[]{"loginCode\u4e3a\u7a7a"});
        }
        return loginCode;
    }

    private void validateUserPassword(Boolean validatePassword, Integer loginErrorCount, LoginRequest loginRequest, UserLoginInfoDTO userValidateInfo) {
        if (validatePassword.booleanValue()) {
            Boolean checkResult = this.passwordStoredEncryptApi.checkPassword(loginRequest.getPassword(), userValidateInfo.getUserPasswordHexed());
            if (checkResult.booleanValue()) {
                return;
            }
            TempSecretApi tempSecretApi = null;
            try {
                Boolean checkTempKeyResult;
                String userTempSecretKey;
                tempSecretApi = (TempSecretApi)SpringUtil.getBean(TempSecretApi.class);
                if (tempSecretApi != null && StrUtil.isNotBlank((CharSequence)(userTempSecretKey = tempSecretApi.getUserTempSecretKey(userValidateInfo.getLoginUser().getUserId()))) && (checkTempKeyResult = this.passwordStoredEncryptApi.checkPassword(loginRequest.getPassword(), userTempSecretKey)).booleanValue()) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (loginErrorCount == null) {
                loginErrorCount = 0;
            }
            if (!DemoConfigExpander.getDemoEnvFlag().booleanValue()) {
                this.loginErrorCountCacheApi.put(loginRequest.getAccount(), (Object)(loginErrorCount + 1));
            }
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.USERNAME_PASSWORD_ERROR);
        }
    }
}

