/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.group.modular.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.group.api.GroupApi;
import cn.stylefeng.roses.kernel.group.api.pojo.SysGroupDTO;
import cn.stylefeng.roses.kernel.group.api.pojo.SysGroupRequest;
import cn.stylefeng.roses.kernel.group.modular.entity.SysGroup;
import cn.stylefeng.roses.kernel.group.modular.mapper.SysGroupMapper;
import cn.stylefeng.roses.kernel.group.modular.service.SysGroupService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SysGroupServiceImpl
extends ServiceImpl<SysGroupMapper, SysGroup>
implements SysGroupService,
GroupApi {
    public List<SysGroupDTO> findGroupList(SysGroupRequest sysGroupRequest, boolean getTotal) {
        String groupBizCode = sysGroupRequest.getGroupBizCode();
        Long userId = LoginContext.me().getLoginUser().getUserId();
        List<SysGroupDTO> userGroupList = ((SysGroupMapper)this.baseMapper).getUserGroupList(groupBizCode, userId, getTotal);
        this.addAllGroup(groupBizCode, userGroupList);
        return userGroupList;
    }

    @Override
    public List<SysGroupDTO> addSelect(SysGroupRequest sysGroupRequest) {
        String groupBizCode = sysGroupRequest.getGroupBizCode();
        Long userId = LoginContext.me().getLoginUser().getUserId();
        List<SysGroupDTO> userGroupList = ((SysGroupMapper)this.baseMapper).getUserGroupList(groupBizCode, userId, false);
        this.addCommonGroup(groupBizCode, userGroupList);
        return userGroupList;
    }

    @Override
    public void add(SysGroupRequest sysGroupRequest) {
        ArrayList<SysGroup> sysGroups = new ArrayList<SysGroup>();
        Long userId = LoginContext.me().getLoginUser().getUserId();
        List businessIdList = sysGroupRequest.getBusinessIdList();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(SysGroup::getGroupBizCode, (Object)sysGroupRequest.getGroupBizCode());
        updateWrapper.in(SysGroup::getBusinessId, (Collection)businessIdList);
        updateWrapper.eq(SysGroup::getUserId, (Object)userId);
        this.remove((Wrapper)updateWrapper);
        if (!"\u672a\u5206\u7ec4".equals(sysGroupRequest.getGroupName())) {
            for (Long bizId : businessIdList) {
                SysGroup sysGroup = new SysGroup();
                sysGroup.setGroupName(sysGroupRequest.getGroupName());
                sysGroup.setGroupBizCode(sysGroupRequest.getGroupBizCode());
                sysGroup.setBusinessId(bizId);
                sysGroup.setUserId(userId);
                sysGroups.add(sysGroup);
            }
            this.saveBatch(sysGroups);
        }
    }

    @Override
    public void del(SysGroupRequest sysGroupRequest) {
        Long userId = LoginContext.me().getLoginUser().getUserId();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(SysGroup::getUserId, (Object)userId);
        wrapper.eq(SysGroup::getGroupBizCode, (Object)sysGroupRequest.getGroupBizCode());
        wrapper.in(SysGroup::getBusinessId, (Collection)sysGroupRequest.getBusinessIdList());
        this.remove((Wrapper)wrapper);
    }

    public List<Long> findUserGroupDataList(SysGroupRequest sysGroupRequest) {
        Long userId = LoginContext.me().getLoginUser().getUserId();
        LambdaQueryWrapper sysGroupLambdaQueryWrapper = new LambdaQueryWrapper();
        sysGroupLambdaQueryWrapper.eq(SysGroup::getUserId, (Object)userId);
        sysGroupLambdaQueryWrapper.eq(SysGroup::getGroupBizCode, (Object)sysGroupRequest.getGroupBizCode());
        sysGroupLambdaQueryWrapper.eq(StrUtil.isNotBlank((CharSequence)sysGroupRequest.getGroupName()), SysGroup::getGroupName, (Object)sysGroupRequest.getGroupName());
        List list2 = this.list((Wrapper)sysGroupLambdaQueryWrapper);
        if (list2 == null || list2.size() == 0) {
            return new ArrayList<Long>();
        }
        return list2.stream().map(SysGroup::getBusinessId).collect(Collectors.toList());
    }

    public void removeGroup(String bizCode, Long bizId) {
        Long userId = LoginContext.me().getLoginUser().getUserId();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(SysGroup::getUserId, (Object)userId);
        wrapper.eq(SysGroup::getGroupBizCode, (Object)bizCode);
        wrapper.eq(SysGroup::getBusinessId, (Object)bizId);
        this.remove((Wrapper)wrapper);
    }

    private void addCommonGroup(String groupBizCode, List<SysGroupDTO> result) {
        SysGroupDTO addGroup = new SysGroupDTO();
        addGroup.setGroupBizCode(groupBizCode);
        addGroup.setGroupName("\u6dfb\u52a0\u5206\u7ec4");
        SysGroupDTO noneGroup = new SysGroupDTO();
        noneGroup.setGroupBizCode(groupBizCode);
        noneGroup.setGroupName("\u672a\u5206\u7ec4");
        result.add(0, noneGroup);
        result.add(0, addGroup);
    }

    private void addAllGroup(String groupBizCode, List<SysGroupDTO> result) {
        SysGroupDTO addGroup = new SysGroupDTO();
        addGroup.setGroupBizCode(groupBizCode);
        addGroup.setGroupName("\u6240\u6709\u5206\u7ec4");
        SysGroupDTO noneGroup = new SysGroupDTO();
        noneGroup.setGroupBizCode(groupBizCode);
        noneGroup.setGroupName("\u672a\u5206\u7ec4");
        result.add(0, noneGroup);
        result.add(0, addGroup);
    }
}

