/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.i18n.modular.controller;

import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.dict.api.DictApi;
import cn.stylefeng.roses.kernel.i18n.api.context.TranslationContext;
import cn.stylefeng.roses.kernel.i18n.api.pojo.request.TranslationRequest;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResource(name="\u7528\u6237\u591a\u8bed\u8a00\u4fe1\u606f\u63a7\u5236\u5668")
public class UserTranslationController {
    @Resource
    private DictApi dictApi;
    @Resource
    private SessionManagerApi sessionManagerApi;

    @GetResource(name="\u83b7\u53d6\u6240\u6709\u7684\u591a\u8bed\u8a00\u7c7b\u578b\u7f16\u7801", path={"/i18n/getAllLanguages"}, requiredPermission=false)
    public ResponseData getAllLanguages() {
        List dictDetailsByDictTypeCode = this.dictApi.getDictDetailsByDictTypeCode("languages");
        return new SuccessResponseData((Object)dictDetailsByDictTypeCode);
    }

    @GetResource(name="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u591a\u8bed\u8a00\u5b57\u5178", path={"/i18n/getUserTranslation"}, requiredPermission=false)
    public ResponseData getUserTranslation() {
        String tranLanguageCode = LoginContext.me().getLoginUser().getTranLanguageCode();
        Map translationDictByLanguage = TranslationContext.me().getTranslationDictByLanguage(tranLanguageCode);
        return new SuccessResponseData((Object)translationDictByLanguage);
    }

    @PostResource(name="\u4fee\u6539\u5f53\u524d\u7528\u6237\u7684\u591a\u8bed\u8a00\u914d\u7f6e", path={"/i18n/changeUserTranslation"}, requiredPermission=false)
    public ResponseData changeUserTranslation(@RequestBody @Validated(value={TranslationRequest.changeUserLanguage.class}) TranslationRequest translationRequest) {
        String token = LoginContext.me().getToken();
        LoginUser loginUser = LoginContext.me().getLoginUser();
        loginUser.setTranLanguageCode(translationRequest.getTranLanguageCode());
        this.sessionManagerApi.updateSession(token, loginUser);
        return new SuccessResponseData();
    }
}

