/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.migration.aggregation.scheduling;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.migration.api.AccessMigrationApi;
import cn.stylefeng.roses.kernel.migration.api.pojo.MigrationAggregationPOJO;
import cn.stylefeng.roses.kernel.migration.api.pojo.MigrationInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SchedulingCenter {
    private static final ConcurrentHashMap<String, AccessMigrationApi> migrationCollection = new ConcurrentHashMap();

    public static void addMigration(AccessMigrationApi accessMigrationApi) {
        String appAndModuleNameItem = accessMigrationApi.getAppName() + "#" + accessMigrationApi.getModuleName();
        migrationCollection.put(appAndModuleNameItem, accessMigrationApi);
    }

    public static void importData(MigrationAggregationPOJO migrationAggregationPOJO, String type) {
        Map migrationInfoMap = migrationAggregationPOJO.getData();
        for (String appAndModuleName : migrationAggregationPOJO.getAppAndModuleNameList()) {
            AccessMigrationApi accessMigrationApi = migrationCollection.get(appAndModuleName);
            if (!ObjectUtil.isNotEmpty((Object)accessMigrationApi)) continue;
            MigrationInfo migrationInfo = (MigrationInfo)migrationInfoMap.get(appAndModuleName);
            try {
                accessMigrationApi.importData(type, migrationInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static MigrationAggregationPOJO exportData(MigrationAggregationPOJO migrationAggregationPOJO) {
        HashMap<String, MigrationInfo> data = migrationAggregationPOJO.getData();
        if (ObjectUtil.isEmpty((Object)data)) {
            data = new HashMap<String, MigrationInfo>();
            migrationAggregationPOJO.setData(data);
        }
        for (String appAndModuleName : migrationAggregationPOJO.getAppAndModuleNameList()) {
            AccessMigrationApi accessMigrationApi = migrationCollection.get(appAndModuleName);
            if (ObjectUtil.isNotEmpty((Object)accessMigrationApi)) {
                try {
                    MigrationInfo migrationInfo = accessMigrationApi.exportData();
                    data.put(appAndModuleName, migrationInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            data.put(appAndModuleName, new MigrationInfo());
        }
        return migrationAggregationPOJO;
    }

    public static List<String> getAllMigrationInfo() {
        return new ArrayList<String>(migrationCollection.keySet());
    }
}

