/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.home.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.log.api.LogManagerApi;
import cn.stylefeng.roses.kernel.log.api.pojo.manage.LogManagerRequest;
import cn.stylefeng.roses.kernel.log.api.pojo.record.LogRecordDTO;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.system.api.HomePageServiceApi;
import cn.stylefeng.roses.kernel.system.api.PositionServiceApi;
import cn.stylefeng.roses.kernel.system.api.UserServiceApi;
import cn.stylefeng.roses.kernel.system.api.pojo.home.HomeCompanyInfo;
import cn.stylefeng.roses.kernel.system.api.pojo.user.OnlineUserDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.user.request.OnlineUserRequest;
import cn.stylefeng.roses.kernel.system.api.pojo.user.request.SysUserRequest;
import cn.stylefeng.roses.kernel.system.modular.home.entity.SysStatisticsCount;
import cn.stylefeng.roses.kernel.system.modular.home.entity.SysStatisticsUrl;
import cn.stylefeng.roses.kernel.system.modular.home.mapper.SysStatisticsUrlMapper;
import cn.stylefeng.roses.kernel.system.modular.home.pojo.OnlineUserStat;
import cn.stylefeng.roses.kernel.system.modular.home.service.HomePageService;
import cn.stylefeng.roses.kernel.system.modular.home.service.SysStatisticsCountService;
import cn.stylefeng.roses.kernel.system.modular.home.service.SysStatisticsUrlService;
import cn.stylefeng.roses.kernel.system.modular.menu.entity.SysMenu;
import cn.stylefeng.roses.kernel.system.modular.menu.mapper.SysMenuMapper;
import cn.stylefeng.roses.kernel.system.modular.organization.entity.HrOrganization;
import cn.stylefeng.roses.kernel.system.modular.organization.service.HrOrganizationService;
import cn.stylefeng.roses.kernel.system.modular.user.entity.SysUserOrg;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserOrgService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class HomePageServiceImpl
implements HomePageService,
HomePageServiceApi {
    @Resource
    private LogManagerApi logManagerApi;
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private HrOrganizationService hrOrganizationService;
    @Resource
    private PositionServiceApi positionServiceApi;
    @Resource
    private SysUserOrgService sysUserOrgService;
    @Resource(name="requestCountCacheApi")
    private CacheOperatorApi<Map<Long, Integer>> requestCountCacheApi;
    @Resource
    private SysStatisticsCountService sysStatisticsCountService;
    @Resource
    private SysStatisticsUrlService sysStatisticsUrlService;
    @Resource
    private SysStatisticsUrlMapper sysStatisticsUrlMapper;
    @Resource
    private SysMenuMapper sysMenuMapper;

    @Override
    public List<LogRecordDTO> getRecentLogs() {
        LogManagerRequest logManagerRequest = new LogManagerRequest();
        logManagerRequest.setUserId(LoginContext.me().getLoginUser().getUserId());
        PageResult page = this.logManagerApi.findPage(logManagerRequest);
        return page.getRows();
    }

    @Override
    public OnlineUserStat getOnlineUserList(OnlineUserRequest onlineUserRequest) {
        OnlineUserStat onlineUserStat = new OnlineUserStat();
        List onlineUserDTOS = this.userServiceApi.onlineUserList(onlineUserRequest);
        HashSet<String> onlineUserList = new HashSet<String>();
        for (OnlineUserDTO onlineUserDTO : onlineUserDTOS) {
            if (!ObjectUtil.isNotEmpty((Object)onlineUserDTO.getRealName())) continue;
            onlineUserList.add(onlineUserDTO.getRealName());
        }
        onlineUserStat.setTotalNum(onlineUserList.size());
        Set<String> newSet = onlineUserList.stream().limit(20L).collect(Collectors.toSet());
        onlineUserStat.setTotalUserNames(newSet);
        return onlineUserStat;
    }

    @Override
    public HomeCompanyInfo getHomeCompanyInfo() {
        HomeCompanyInfo homeCompanyInfo = new HomeCompanyInfo();
        long count = this.hrOrganizationService.count();
        homeCompanyInfo.setOrganizationNum(Convert.toInt((Object)count));
        SysUserRequest sysUserRequest = new SysUserRequest();
        List allUserIdList = this.userServiceApi.queryAllUserIdList(sysUserRequest);
        homeCompanyInfo.setEnterprisePersonNum(Integer.valueOf(allUserIdList.size()));
        int positionNum = this.positionServiceApi.positionNum();
        homeCompanyInfo.setPositionNum(Integer.valueOf(positionNum));
        LoginUser loginUser = LoginContext.me().getLoginUser();
        Long organizationId = loginUser.getOrganizationId();
        LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(HrOrganization.class).like(HrOrganization::getOrgPids, (Object)("[" + organizationId + "]"))).or()).eq(HrOrganization::getOrgId, (Object)organizationId)).select(new SFunction[]{HrOrganization::getOrgId});
        List organizations = this.hrOrganizationService.list((Wrapper)wrapper);
        homeCompanyInfo.setCurrentDeptNum(Integer.valueOf(organizations.size()));
        List orgIds = organizations.stream().map(HrOrganization::getOrgId).collect(Collectors.toList());
        Long currentOrgPersonNum = this.sysUserOrgService.count((Wrapper)Wrappers.lambdaQuery(SysUserOrg.class).in(SysUserOrg::getOrgId, orgIds));
        homeCompanyInfo.setCurrentCompanyPersonNum(Convert.toInt((Object)currentOrgPersonNum));
        return homeCompanyInfo;
    }

    @Override
    public List<SysMenu> getCommonFunctions() {
        LoginUser loginUser = LoginContext.me().getLoginUser();
        List statList = this.sysStatisticsCountService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysStatisticsCount.class).eq(SysStatisticsCount::getUserId, (Object)loginUser.getUserId())).orderByDesc(SysStatisticsCount::getStatCount));
        List<Long> statUrlIdList = statList.stream().map(SysStatisticsCount::getStatUrlId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery(SysStatisticsUrl.class).eq(SysStatisticsUrl::getAlwaysShow, (Object)YesOrNotEnum.Y)).select(new SFunction[]{SysStatisticsUrl::getStatUrlId});
        List alwaysShowList = this.sysStatisticsUrlService.list((Wrapper)wrapper);
        if (ObjectUtil.isNotEmpty((Object)alwaysShowList)) {
            statUrlIdList.addAll(0, alwaysShowList.stream().map(SysStatisticsUrl::getStatUrlId).collect(Collectors.toList()));
        }
        if (statUrlIdList.size() > 8) {
            statUrlIdList = statUrlIdList.subList(0, 8);
        }
        List<Long> usualMenuIds = this.sysStatisticsUrlMapper.getMenuIdsByStatUrlIdList(statUrlIdList);
        List list = this.sysMenuMapper.getMenuStatInfoByMenuIds(usualMenuIds);
        for (SysMenu sysMenu : list) {
            if (sysMenu.getAntdvIcon() == null) continue;
            String replace = sysMenu.getAntdvIcon().replace("-", "_");
            sysMenu.setAntdvIcon(StrUtil.upperFirst((CharSequence)StrUtil.toCamelCase((CharSequence)replace)));
        }
        return list;
    }

    @Override
    public void saveStatisticsCacheToDb() {
        Map userRequestStats = this.requestCountCacheApi.getAllKeyValues();
        Set userIds = userRequestStats.keySet();
        if (ObjectUtil.isEmpty(userIds)) {
            return;
        }
        ArrayList<SysStatisticsCount> cacheCountList = new ArrayList<SysStatisticsCount>();
        for (String userId : userIds) {
            Map userCounts = (Map)userRequestStats.get(userId);
            for (Map.Entry userCountItem : userCounts.entrySet()) {
                Long statUrlId = (Long)userCountItem.getKey();
                Integer count = (Integer)userCountItem.getValue();
                SysStatisticsCount sysStatisticsCount = new SysStatisticsCount();
                sysStatisticsCount.setUserId(Long.valueOf(userId));
                sysStatisticsCount.setStatUrlId(statUrlId);
                sysStatisticsCount.setStatCount(count);
                cacheCountList.add(sysStatisticsCount);
            }
        }
        List userIdsLong = userIds.stream().map(Long::valueOf).collect(Collectors.toList());
        List sysStatisticsCounts = this.sysStatisticsCountService.list((Wrapper)Wrappers.lambdaQuery(SysStatisticsCount.class).in(SysStatisticsCount::getUserId, userIdsLong));
        for (SysStatisticsCount cacheItem : cacheCountList) {
            boolean haveRecord = false;
            for (SysStatisticsCount dbItem : sysStatisticsCounts) {
                if (!dbItem.getStatUrlId().equals(cacheItem.getStatUrlId()) || !dbItem.getUserId().equals(cacheItem.getUserId())) continue;
                haveRecord = true;
                cacheItem.setStatCountId(dbItem.getStatCountId());
            }
            if (haveRecord) continue;
            cacheItem.setStatCountId(IdWorker.getId());
        }
        this.sysStatisticsCountService.saveOrUpdateBatch(cacheCountList);
    }
}

