/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.resource.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.dict.api.pojo.dict.request.ParentIdsUpdateRequest;
import cn.stylefeng.roses.kernel.rule.constants.RuleConstants;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.resource.ApiGroupExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.resource.ApiGroupRequest;
import cn.stylefeng.roses.kernel.system.api.pojo.resource.ApiGroupTreeWrapper;
import cn.stylefeng.roses.kernel.system.api.pojo.resource.TreeSortRequest;
import cn.stylefeng.roses.kernel.system.modular.resource.entity.ApiGroup;
import cn.stylefeng.roses.kernel.system.modular.resource.entity.ApiResource;
import cn.stylefeng.roses.kernel.system.modular.resource.entity.ApiResourceField;
import cn.stylefeng.roses.kernel.system.modular.resource.entity.SysResource;
import cn.stylefeng.roses.kernel.system.modular.resource.enums.NodeEnums;
import cn.stylefeng.roses.kernel.system.modular.resource.enums.NodeTypeEnums;
import cn.stylefeng.roses.kernel.system.modular.resource.mapper.ApiGroupMapper;
import cn.stylefeng.roses.kernel.system.modular.resource.service.ApiGroupService;
import cn.stylefeng.roses.kernel.system.modular.resource.service.ApiResourceFieldService;
import cn.stylefeng.roses.kernel.system.modular.resource.service.ApiResourceService;
import cn.stylefeng.roses.kernel.system.modular.resource.service.SysResourceService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApiGroupServiceImpl
extends ServiceImpl<ApiGroupMapper, ApiGroup>
implements ApiGroupService {
    @Autowired
    private ApiResourceService apiResourceService;
    @Autowired
    private ApiResourceFieldService apiResourceFieldService;
    @Autowired
    private SysResourceService sysResourceService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiGroup add(ApiGroupRequest apiGroupRequest) {
        ApiGroup apiGroup = new ApiGroup();
        BeanUtil.copyProperties((Object)apiGroupRequest, (Object)((Object)apiGroup), (String[])new String[0]);
        this.setPids(apiGroup);
        this.save((Object)apiGroup);
        return apiGroup;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(ApiGroupRequest apiGroupRequest) {
        if (NodeEnums.ROOT_NODE.getId().equals(apiGroupRequest.getGroupId())) {
            throw new SystemModularException((AbstractExceptionEnum)ApiGroupExceptionEnum.ROOT_PROHIBIT_OPERATION);
        }
        ApiGroup apiGroup = this.queryApiGroup(apiGroupRequest);
        this.removeById(apiGroup.getGroupId());
        LambdaQueryWrapper apiGroupLambdaQueryWrapper = new LambdaQueryWrapper();
        apiGroupLambdaQueryWrapper.like(ApiGroup::getGroupPids, (Object)("[" + apiGroup.getGroupId() + "]"));
        List apiGroups = this.list((Wrapper)apiGroupLambdaQueryWrapper);
        apiGroups.add(apiGroup);
        Set apiGroupIdSet = null;
        if (ObjectUtil.isNotEmpty((Object)apiGroups)) {
            apiGroupIdSet = apiGroups.stream().map(ApiGroup::getGroupId).collect(Collectors.toSet());
        }
        if (ObjectUtil.isNotEmpty(apiGroupIdSet)) {
            LambdaQueryWrapper apiResourceLambdaQueryWrapper = new LambdaQueryWrapper();
            apiResourceLambdaQueryWrapper.in(ApiResource::getGroupId, apiGroupIdSet);
            List apiResourceList = this.apiResourceService.list((Wrapper)apiResourceLambdaQueryWrapper);
            if (ObjectUtil.isNotEmpty((Object)apiResourceList)) {
                Set apiResourceSet = apiResourceList.stream().map(ApiResource::getApiResourceId).collect(Collectors.toSet());
                LambdaQueryWrapper apiResourceFieldLambdaQueryWrapper = new LambdaQueryWrapper();
                apiResourceFieldLambdaQueryWrapper.in(ApiResourceField::getApiResourceId, apiResourceSet);
                this.apiResourceFieldService.remove((Wrapper)apiResourceFieldLambdaQueryWrapper);
            }
            this.apiResourceService.remove((Wrapper)apiResourceLambdaQueryWrapper);
        }
        this.remove((Wrapper)apiGroupLambdaQueryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(ApiGroupRequest apiGroupRequest) {
        ApiGroup oldApiGroup = this.queryApiGroup(apiGroupRequest);
        if (apiGroupRequest.getGroupPid().equals(oldApiGroup.getGroupId())) {
            throw new SystemModularException((AbstractExceptionEnum)ApiGroupExceptionEnum.PARENT_NODE_ITSELF);
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.like(ApiGroup::getGroupPids, (Object)("[" + oldApiGroup.getGroupId() + "]"));
        List apiGroups = this.list((Wrapper)lambdaQueryWrapper);
        if (ObjectUtil.isNotEmpty((Object)apiGroups) && apiGroups.stream().anyMatch(item -> item.getGroupId().equals(apiGroupRequest.getGroupPid()))) {
            throw new SystemModularException((AbstractExceptionEnum)ApiGroupExceptionEnum.PARENT_NODE_ITSELF);
        }
        ApiGroup newApiGroup = (ApiGroup)((Object)BeanUtil.toBean((Object)apiGroupRequest, ApiGroup.class));
        if (!newApiGroup.getGroupPid().equals(oldApiGroup.getGroupPid())) {
            this.setPids(newApiGroup);
            this.updatePids(newApiGroup, oldApiGroup);
        }
        this.updateById((Object)newApiGroup);
    }

    @Override
    public ApiGroup detail(ApiGroupRequest apiGroupRequest) {
        return this.queryApiGroup(apiGroupRequest);
    }

    @Override
    public PageResult<ApiGroup> findPage(ApiGroupRequest apiGroupRequest) {
        LambdaQueryWrapper<ApiGroup> wrapper = this.createWrapper(apiGroupRequest);
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    public List<ApiGroupTreeWrapper> tree(ApiGroupRequest apiGroupRequest) {
        return this.createTree(this.peersTree(apiGroupRequest));
    }

    @Override
    public List<ApiGroupTreeWrapper> peersTree(ApiGroupRequest apiGroupRequest) {
        List<ApiResource> apiResourceList;
        ApiGroupTreeWrapper item;
        ArrayList<ApiGroupTreeWrapper> allApiGroupTreeWrapperList = new ArrayList<ApiGroupTreeWrapper>();
        HashMap<String, SysResource> stringSysResourceMap = new HashMap<String, SysResource>();
        LambdaQueryWrapper sysResourceLambdaQueryWrapper = new LambdaQueryWrapper();
        sysResourceLambdaQueryWrapper.eq(SysResource::getViewFlag, (Object)YesOrNotEnum.N.getCode());
        List sysResources = this.sysResourceService.list((Wrapper)sysResourceLambdaQueryWrapper);
        for (SysResource sysResource : sysResources) {
            stringSysResourceMap.put(sysResource.getResourceCode(), sysResource);
        }
        HashMap<Long, Integer> notNullGroup = new HashMap<Long, Integer>();
        List<ApiGroup> apiGroups = this.dataList(apiGroupRequest);
        if (ObjectUtil.isNotEmpty(apiGroups)) {
            for (ApiGroup apiGroup : apiGroups) {
                item = new ApiGroupTreeWrapper();
                item.setId(apiGroup.getGroupId());
                item.setPid(apiGroup.getGroupPid());
                item.setName(apiGroup.getGroupName());
                item.setType(NodeTypeEnums.LEAF_NODE.getType());
                item.setSort(apiGroup.getGroupSort());
                item.setData((Object)apiGroup);
                item.setSlotsValue();
                allApiGroupTreeWrapperList.add(item);
            }
        }
        if (ObjectUtil.isNotEmpty(apiResourceList = this.apiResourceService.dataList(apiGroupRequest))) {
            for (ApiResource apiResource : apiResourceList) {
                Integer count = (Integer)notNullGroup.get(apiResource.getGroupId());
                if (ObjectUtil.isEmpty((Object)count)) {
                    count = 0;
                }
                count = count + 1;
                notNullGroup.put(apiResource.getGroupId(), count);
                ApiGroupTreeWrapper item2 = new ApiGroupTreeWrapper();
                item2.setId(apiResource.getApiResourceId());
                item2.setPid(apiResource.getGroupId());
                item2.setName(apiResource.getApiAlias());
                item2.setType(NodeTypeEnums.DATA_NODE.getType());
                item2.setSort(apiResource.getResourceSort());
                item2.setData((Object)apiResource);
                item2.setSlotsValue();
                SysResource sysResource = (SysResource)((Object)stringSysResourceMap.get(apiResource.getResourceCode()));
                if (ObjectUtil.isNotEmpty((Object)((Object)sysResource))) {
                    item2.setUrl(sysResource.getUrl());
                }
                allApiGroupTreeWrapperList.add(item2);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)apiGroupRequest.getGroupName())) {
            Iterator iterator = allApiGroupTreeWrapperList.iterator();
            while (iterator.hasNext()) {
                Integer integer;
                item = (ApiGroupTreeWrapper)iterator.next();
                if (RuleConstants.TREE_ROOT_ID.toString().equals(item.getNodeParentId()) || NodeTypeEnums.DATA_NODE.getType().equals(item.getType()) || !ObjectUtil.isEmpty((Object)(integer = (Integer)notNullGroup.get(item.getId()))) && integer != 0) continue;
                iterator.remove();
            }
        }
        return allApiGroupTreeWrapperList;
    }

    private List<ApiGroup> dataList(ApiGroupRequest apiGroupRequest) {
        return ((ApiGroupMapper)this.baseMapper).dataList(apiGroupRequest);
    }

    @Override
    public List<ApiGroupTreeWrapper> groupTree(ApiGroupRequest apiGroupRequest) {
        List apiGroups;
        ArrayList<ApiGroupTreeWrapper> apiGroupTreeWrapperList = new ArrayList<ApiGroupTreeWrapper>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (ObjectUtil.isNotEmpty((Object)apiGroupRequest.getGroupId())) {
            wrapper.notLike(ApiGroup::getGroupPids, (Object)("[" + apiGroupRequest.getGroupId() + "]"));
            wrapper.ne(ApiGroup::getGroupId, (Object)apiGroupRequest.getGroupId());
        }
        if (ObjectUtil.isNotEmpty((Object)(apiGroups = this.list((Wrapper)wrapper)))) {
            for (ApiGroup apiGroup : apiGroups) {
                ApiGroupTreeWrapper item = new ApiGroupTreeWrapper();
                item.setId(apiGroup.getGroupId());
                item.setPid(apiGroup.getGroupPid());
                item.setName(apiGroup.getGroupName());
                item.setType(NodeTypeEnums.LEAF_NODE.getType());
                item.setSort(apiGroup.getGroupSort());
                item.setData((Object)apiGroup);
                item.setSlotsValue();
                apiGroupTreeWrapperList.add(item);
            }
        }
        return this.createTree(apiGroupTreeWrapperList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editTreeSort(List<TreeSortRequest> treeSortRequestList) {
        ArrayList<BaseEntity> apiGroupList = new ArrayList<BaseEntity>();
        ArrayList<BaseEntity> apiResourceList = new ArrayList<BaseEntity>();
        for (TreeSortRequest treeSortRequest : treeSortRequestList) {
            BaseEntity item;
            if (NodeTypeEnums.LEAF_NODE.getType().equals(treeSortRequest.getNodeType())) {
                item = new ApiGroup();
                item.setGroupId(treeSortRequest.getNodeId());
                item.setGroupPid(treeSortRequest.getNodePid());
                item.setGroupSort(treeSortRequest.getNodeSort());
                apiGroupList.add(item);
                continue;
            }
            item = new ApiResource();
            item.setApiResourceId(treeSortRequest.getNodeId());
            item.setGroupId(treeSortRequest.getNodePid());
            item.setResourceSort(treeSortRequest.getNodeSort());
            apiResourceList.add(item);
        }
        if (ObjectUtil.isNotEmpty(apiGroupList)) {
            for (ApiGroup apiGroup : apiGroupList) {
                ApiGroup oldApiGroup = (ApiGroup)((Object)this.getById(apiGroup.getGroupId()));
                this.setPids(apiGroup);
                this.updatePids(apiGroup, oldApiGroup);
            }
            this.updateBatchById(apiGroupList);
        }
        if (ObjectUtil.isNotEmpty(apiResourceList)) {
            this.apiResourceService.updateBatchById(apiResourceList);
        }
    }

    @Override
    public List<ApiGroup> findList(ApiGroupRequest apiGroupRequest) {
        LambdaQueryWrapper<ApiGroup> wrapper = this.createWrapper(apiGroupRequest);
        List apiGroupList = this.list((Wrapper)wrapper);
        return apiGroupList;
    }

    private ApiGroup queryApiGroup(ApiGroupRequest apiGroupRequest) {
        ApiGroup apiGroup = (ApiGroup)((Object)this.getById(apiGroupRequest.getGroupId()));
        if (ObjectUtil.isEmpty((Object)((Object)apiGroup))) {
            throw new SystemModularException((AbstractExceptionEnum)ApiGroupExceptionEnum.APIGROUP_NOT_EXISTED);
        }
        return apiGroup;
    }

    private LambdaQueryWrapper<ApiGroup> createWrapper(ApiGroupRequest apiGroupRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long groupId = apiGroupRequest.getGroupId();
        String groupName = apiGroupRequest.getGroupName();
        Long groupPid = apiGroupRequest.getGroupPid();
        String groupPids = apiGroupRequest.getGroupPids();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)groupId), ApiGroup::getGroupId, (Object)groupId);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)groupName), ApiGroup::getGroupName, (Object)groupName);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)groupPid), ApiGroup::getGroupPid, (Object)groupPid);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)groupPids), ApiGroup::getGroupPids, (Object)groupPids);
        return queryWrapper;
    }

    private void setPids(ApiGroup apiGroup) {
        if (RuleConstants.TREE_ROOT_ID.equals(apiGroup.getGroupPid())) {
            apiGroup.setGroupPids("[" + RuleConstants.TREE_ROOT_ID + "]");
        } else {
            ApiGroup pApiGroup = (ApiGroup)((Object)this.getById(apiGroup.getGroupPid()));
            apiGroup.setGroupPids(pApiGroup.getGroupPids() + "," + "[" + pApiGroup.getGroupId() + "]");
        }
    }

    private void updatePids(ApiGroup apiGroup, ApiGroup oldApiGroup) {
        String oldPids = oldApiGroup.getGroupPids();
        oldPids = oldPids + "," + "[" + oldApiGroup.getGroupId() + "]";
        ParentIdsUpdateRequest parentIdsUpdateRequest = ApiGroupServiceImpl.createParenIdsUpdateRequest(apiGroup.getGroupPids() + "," + "[" + apiGroup.getGroupId() + "]", oldPids);
        ((ApiGroupMapper)this.baseMapper).updateSubPids(parentIdsUpdateRequest);
    }

    private static ParentIdsUpdateRequest createParenIdsUpdateRequest(String newParentIds, String oldParentIds) {
        ParentIdsUpdateRequest parentIdsUpdateRequest = new ParentIdsUpdateRequest();
        parentIdsUpdateRequest.setNewParentIds(newParentIds);
        parentIdsUpdateRequest.setOldParentIds(oldParentIds);
        parentIdsUpdateRequest.setUpdateTime(new Date());
        parentIdsUpdateRequest.setUpdateUser(LoginContext.me().getLoginUser().getUserId());
        return parentIdsUpdateRequest;
    }

    private List<ApiGroupTreeWrapper> createTree(List<ApiGroupTreeWrapper> orgTrees) {
        ApiGroupTreeWrapper root = null;
        HashMap<String, ApiGroupTreeWrapper> dataMap = new HashMap<String, ApiGroupTreeWrapper>(orgTrees.size());
        for (ApiGroupTreeWrapper orgTree : orgTrees) {
            if (orgTree.getNodeParentId().equals(RuleConstants.TREE_ROOT_ID.toString())) {
                root = orgTree;
            }
            dataMap.put(orgTree.getNodeId(), orgTree);
        }
        orgTrees.parallelStream().forEach(item -> {
            if (!RuleConstants.TREE_ROOT_ID.toString().equals(item.getNodeParentId())) {
                ApiGroupTreeWrapper orgTreeWrapper;
                if (ObjectUtil.isEmpty((Object)item.getSort())) {
                    item.setSort(BigDecimal.valueOf(9999L));
                }
                if (ObjectUtil.isNotEmpty((Object)(orgTreeWrapper = (ApiGroupTreeWrapper)dataMap.get(item.getNodeParentId())))) {
                    ((ApiGroupTreeWrapper)dataMap.get(item.getNodeParentId())).getChildren().add(item);
                }
            }
        });
        root.sortChildren();
        return Collections.singletonList(root);
    }
}

