/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.resource.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.FieldMetadata;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.ResourceDefinition;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.resource.ApiResourceExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.resource.ApiGroupRequest;
import cn.stylefeng.roses.kernel.system.api.pojo.resource.ApiResourceFieldRequest;
import cn.stylefeng.roses.kernel.system.api.pojo.resource.ApiResourceRequest;
import cn.stylefeng.roses.kernel.system.modular.resource.entity.ApiGroup;
import cn.stylefeng.roses.kernel.system.modular.resource.entity.ApiResource;
import cn.stylefeng.roses.kernel.system.modular.resource.entity.ApiResourceField;
import cn.stylefeng.roses.kernel.system.modular.resource.entity.SysResource;
import cn.stylefeng.roses.kernel.system.modular.resource.factory.ResourceFactory;
import cn.stylefeng.roses.kernel.system.modular.resource.mapper.ApiResourceMapper;
import cn.stylefeng.roses.kernel.system.modular.resource.service.ApiGroupService;
import cn.stylefeng.roses.kernel.system.modular.resource.service.ApiResourceFieldService;
import cn.stylefeng.roses.kernel.system.modular.resource.service.ApiResourceService;
import cn.stylefeng.roses.kernel.system.modular.resource.service.SysResourceService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class ApiResourceServiceImpl
extends ServiceImpl<ApiResourceMapper, ApiResource>
implements ApiResourceService {
    @Autowired
    private ApiGroupService apiGroupService;
    @Autowired
    private SysResourceService sysResourceService;
    @Autowired
    private ApiResourceFieldService apiResourceFieldService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(ApiResourceRequest apiResourceRequest) {
        ApiGroup apiGroup = (ApiGroup)((Object)this.apiGroupService.getById(apiResourceRequest.getGroupId()));
        if (ObjectUtil.isEmpty((Object)((Object)apiGroup))) {
            throw new SystemModularException((AbstractExceptionEnum)ApiResourceExceptionEnum.OPERATIONS_RESOURCE_NODESNOT_ALLOWED);
        }
        ArrayList<SysResource> resourceList = new ArrayList<SysResource>();
        LambdaQueryWrapper sysResourceLambdaQueryWrapper = new LambdaQueryWrapper();
        if (!apiResourceRequest.getResourceCode().contains("$")) {
            sysResourceLambdaQueryWrapper.eq(SysResource::getModularCode, (Object)apiResourceRequest.getResourceCode());
            sysResourceLambdaQueryWrapper.eq(SysResource::getViewFlag, (Object)YesOrNotEnum.N.getCode());
            List sysResourceList = this.sysResourceService.list((Wrapper)sysResourceLambdaQueryWrapper);
            resourceList.addAll(sysResourceList);
        } else {
            sysResourceLambdaQueryWrapper.eq(SysResource::getResourceCode, (Object)apiResourceRequest.getResourceCode());
            SysResource sysResources = (SysResource)((Object)this.sysResourceService.getOne((Wrapper)sysResourceLambdaQueryWrapper));
            if (YesOrNotEnum.Y.getCode().equals(sysResources.getViewFlag())) {
                throw new SystemModularException((AbstractExceptionEnum)ApiResourceExceptionEnum.ADDING_VIEW_RESOURCES_NOT_ALLOWED);
            }
            resourceList.add(sysResources);
        }
        BigDecimal index = BigDecimal.ZERO;
        LambdaQueryWrapper apiResourceLambdaQueryWrapper = new LambdaQueryWrapper();
        apiResourceLambdaQueryWrapper.eq(ApiResource::getGroupId, (Object)apiResourceRequest.getGroupId());
        apiResourceLambdaQueryWrapper.orderByDesc(ApiResource::getResourceSort);
        apiResourceLambdaQueryWrapper.last("LIMIT 1");
        ApiResource resource = (ApiResource)((Object)this.getOne((Wrapper)apiResourceLambdaQueryWrapper));
        if (ObjectUtil.isNotEmpty((Object)((Object)resource))) {
            index = resource.getResourceSort();
        }
        for (SysResource sysResource : resourceList) {
            ApiResourceField conversion;
            ApiResource apiResource = (ApiResource)((Object)BeanUtil.toBean((Object)apiResourceRequest, ApiResource.class));
            apiResource.setRequestMethod(sysResource.getHttpMethod());
            apiResource.setApiAlias(sysResource.getResourceName());
            apiResource.setResourceCode(sysResource.getResourceCode());
            if (ObjectUtil.isEmpty((Object)apiResourceRequest.getResourceSort())) {
                index = index.add(BigDecimal.ONE);
                apiResource.setResourceSort(index);
            }
            this.save((Object)apiResource);
            ResourceDefinition fillResourceDetail = ResourceFactory.fillResourceDetail(ResourceFactory.createResourceDefinition(sysResource));
            ArrayList<ApiResourceField> apiResourceFieldList = new ArrayList<ApiResourceField>();
            if (ObjectUtil.isNotEmpty((Object)fillResourceDetail.getParamFieldDescriptions())) {
                for (FieldMetadata fieldMetadata : fillResourceDetail.getParamFieldDescriptions()) {
                    conversion = this.conversion(sysResource, apiResource.getApiResourceId(), fieldMetadata);
                    conversion.setFieldLocation("request");
                    apiResourceFieldList.add(conversion);
                }
            }
            if (ObjectUtil.isNotEmpty((Object)fillResourceDetail.getResponseFieldDescriptions())) {
                for (FieldMetadata fieldDescription : fillResourceDetail.getResponseFieldDescriptions()) {
                    conversion = this.conversion(sysResource, apiResource.getApiResourceId(), fieldDescription);
                    conversion.setFieldLocation("response");
                    apiResourceFieldList.add(conversion);
                }
            }
            if (!ObjectUtil.isNotEmpty(apiResourceFieldList)) continue;
            this.apiResourceFieldService.saveBatch(apiResourceFieldList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(ApiResourceRequest apiResourceRequest) {
        ApiResource apiResource = this.queryApiResource(apiResourceRequest);
        this.removeById(apiResource.getApiResourceId());
        LambdaQueryWrapper apiResourceFieldLambdaQueryWrapper = new LambdaQueryWrapper();
        apiResourceFieldLambdaQueryWrapper.eq(ApiResourceField::getApiResourceId, (Object)apiResource.getApiResourceId());
        this.apiResourceFieldService.remove((Wrapper)apiResourceFieldLambdaQueryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(ApiResourceRequest apiResourceRequest) {
        ApiResource apiResource = this.queryApiResource(apiResourceRequest);
        ApiGroup apiGroup = (ApiGroup)((Object)this.apiGroupService.getById(apiResource.getGroupId()));
        if (ObjectUtil.isEmpty((Object)((Object)apiGroup))) {
            throw new SystemModularException((AbstractExceptionEnum)ApiResourceExceptionEnum.OPERATIONS_RESOURCE_NODESNOT_ALLOWED);
        }
        BeanUtil.copyProperties((Object)apiResourceRequest, (Object)((Object)apiResource), (String[])new String[0]);
        this.updateById((Object)apiResource);
        LambdaQueryWrapper fieldLambdaQueryWrapper = new LambdaQueryWrapper();
        fieldLambdaQueryWrapper.eq(ApiResourceField::getApiResourceId, (Object)apiResource.getApiResourceId());
        this.apiResourceFieldService.remove((Wrapper)fieldLambdaQueryWrapper);
        List apiResourceFieldRequestList = apiResourceRequest.getApiResourceFieldRequestList();
        if (ObjectUtil.isNotEmpty((Object)apiResourceFieldRequestList)) {
            List apiResourceFields = apiResourceFieldRequestList.stream().map(item -> {
                ApiResourceField apiResourceField = (ApiResourceField)((Object)((Object)BeanUtil.toBean((Object)item, ApiResourceField.class)));
                apiResourceField.setApiResourceId(apiResource.getApiResourceId());
                return apiResourceField;
            }).collect(Collectors.toList());
            this.apiResourceFieldService.saveBatch(apiResourceFields);
        }
    }

    @Override
    public ApiResource detail(ApiResourceRequest apiResourceRequest) {
        ApiResource apiResource = this.queryApiResource(apiResourceRequest);
        LambdaQueryWrapper apiResourceFieldLambdaQueryWrapper = new LambdaQueryWrapper();
        apiResourceFieldLambdaQueryWrapper.eq(ApiResourceField::getApiResourceId, (Object)apiResource.getApiResourceId());
        List apiResourceFields = this.apiResourceFieldService.list((Wrapper)apiResourceFieldLambdaQueryWrapper);
        apiResourceFields.removeIf(resourceField -> "createTime".equalsIgnoreCase(resourceField.getFieldCode()) || "createUser".equalsIgnoreCase(resourceField.getFieldCode()) || "updateTime".equalsIgnoreCase(resourceField.getFieldCode()) || "updateUser".equalsIgnoreCase(resourceField.getFieldCode()));
        ArrayList<ApiResourceFieldRequest> apiResourceFieldList = new ArrayList<ApiResourceFieldRequest>();
        for (ApiResourceField apiResourceField : apiResourceFields) {
            ApiResourceFieldRequest apiResourceFieldRequest = (ApiResourceFieldRequest)BeanUtil.toBean((Object)((Object)apiResourceField), ApiResourceFieldRequest.class);
            apiResourceFieldRequest.setChildren((Set)JSON.parseObject((String)apiResourceField.getFieldSubInfo(), Set.class, (Feature[])new Feature[]{Feature.SupportAutoType}));
            apiResourceFieldList.add(apiResourceFieldRequest);
        }
        apiResource.setApiResourceFieldList(apiResourceFieldList);
        return apiResource;
    }

    @Override
    public PageResult<ApiResource> findPage(ApiResourceRequest apiResourceRequest) {
        LambdaQueryWrapper<ApiResource> wrapper = this.createWrapper(apiResourceRequest);
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResource record(ApiResourceRequest apiResourceRequest) {
        ApiResource apiResource = (ApiResource)((Object)BeanUtil.toBean((Object)apiResourceRequest, ApiResource.class));
        String resultBody = null;
        try {
            HttpRequest httpRequest;
            if (RequestMethod.GET.toString().equalsIgnoreCase(apiResourceRequest.getRequestMethod())) {
                httpRequest = HttpRequest.get((String)apiResourceRequest.getRequestUrl());
                JSONObject jsonObject = JSONObject.parseObject((String)apiResourceRequest.getLastRequestContent());
                for (Map.Entry stringObjectEntry : jsonObject.entrySet()) {
                    httpRequest.form((String)stringObjectEntry.getKey(), stringObjectEntry.getValue());
                }
            } else {
                httpRequest = HttpRequest.post((String)apiResourceRequest.getRequestUrl()).body(apiResourceRequest.getLastRequestContent());
            }
            if (ObjectUtil.isNotEmpty((Object)apiResourceRequest.getLastRequestHeader())) {
                for (Map.Entry stringStringEntry : apiResourceRequest.getLastRequestHeader().entrySet()) {
                    String[] values;
                    for (String value : values = ((String)stringStringEntry.getValue()).split(",")) {
                        httpRequest.header((String)stringStringEntry.getKey(), value, false);
                    }
                }
            }
            resultBody = httpRequest.timeout(15000).execute().body();
        }
        catch (Exception e) {
            resultBody = ExceptionUtil.stacktraceToString((Throwable)e, (int)10000);
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apiResourceRequest.getLastRequestHeader())) {
                apiResource.setLastRequestHeader(JSON.toJSONString((Object)apiResourceRequest.getLastRequestHeader()));
            }
            apiResource.setLastResponseContent(resultBody);
            this.updateById((Object)apiResource);
        }
        return apiResource;
    }

    @Override
    public List<ApiResourceFieldRequest> allField(ApiResourceRequest apiResourceRequest) {
        LambdaQueryWrapper sysResourceLambdaQueryWrapper = new LambdaQueryWrapper();
        sysResourceLambdaQueryWrapper.eq(SysResource::getResourceCode, (Object)apiResourceRequest.getResourceCode());
        SysResource sysResources = (SysResource)((Object)this.sysResourceService.getOne((Wrapper)sysResourceLambdaQueryWrapper));
        ResourceDefinition fillResourceDetail = ResourceFactory.fillResourceDetail(ResourceFactory.createResourceDefinition(sysResources));
        ArrayList<ApiResourceFieldRequest> apiResourceFieldList = new ArrayList<ApiResourceFieldRequest>();
        if (ObjectUtil.isNotEmpty((Object)fillResourceDetail.getParamFieldDescriptions())) {
            ApiResourceFieldRequest apiResourceFieldRequest;
            ApiResourceField conversion;
            for (FieldMetadata fieldMetadata : fillResourceDetail.getParamFieldDescriptions()) {
                conversion = this.conversion(sysResources, null, fieldMetadata);
                conversion.setFieldLocation("request");
                apiResourceFieldRequest = (ApiResourceFieldRequest)BeanUtil.toBean((Object)((Object)conversion), ApiResourceFieldRequest.class);
                apiResourceFieldRequest.setChildren((Set)JSON.parseObject((String)conversion.getFieldSubInfo(), Set.class, (Feature[])new Feature[]{Feature.SupportAutoType}));
                apiResourceFieldList.add(apiResourceFieldRequest);
            }
            for (FieldMetadata fieldDescription : fillResourceDetail.getResponseFieldDescriptions()) {
                conversion = this.conversion(sysResources, null, fieldDescription);
                conversion.setFieldLocation("response");
                apiResourceFieldRequest = (ApiResourceFieldRequest)BeanUtil.toBean((Object)((Object)conversion), ApiResourceFieldRequest.class);
                apiResourceFieldRequest.setChildren((Set)JSON.parseObject((String)conversion.getFieldSubInfo(), Set.class, (Feature[])new Feature[]{Feature.SupportAutoType}));
                apiResourceFieldList.add(apiResourceFieldRequest);
            }
        }
        return apiResourceFieldList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResource reset(ApiResourceRequest apiResourceRequest) {
        ApiResource oldApiResource = (ApiResource)((Object)this.getById(apiResourceRequest.getApiResourceId()));
        this.del(apiResourceRequest);
        apiResourceRequest.setResourceSort(oldApiResource.getResourceSort());
        this.add(apiResourceRequest);
        return (ApiResource)((Object)this.getById(apiResourceRequest.getApiResourceId()));
    }

    @Override
    public List<ApiResource> dataList(ApiGroupRequest apiGroupRequest) {
        return ((ApiResourceMapper)this.baseMapper).dataList(apiGroupRequest);
    }

    @Override
    public List<ApiResource> findList(ApiResourceRequest apiResourceRequest) {
        LambdaQueryWrapper<ApiResource> wrapper = this.createWrapper(apiResourceRequest);
        return this.list((Wrapper)wrapper);
    }

    private ApiResource queryApiResource(ApiResourceRequest apiResourceRequest) {
        ApiResource apiResource = (ApiResource)((Object)this.getById(apiResourceRequest.getApiResourceId()));
        if (ObjectUtil.isEmpty((Object)((Object)apiResource))) {
            throw new SystemModularException((AbstractExceptionEnum)ApiResourceExceptionEnum.APIRESOURCE_NOT_EXISTED);
        }
        return apiResource;
    }

    private LambdaQueryWrapper<ApiResource> createWrapper(ApiResourceRequest apiResourceRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long apiResourceId = apiResourceRequest.getApiResourceId();
        Long groupId = apiResourceRequest.getGroupId();
        String apiAlias = apiResourceRequest.getApiAlias();
        String resourceCode = apiResourceRequest.getResourceCode();
        String lastRequestContent = apiResourceRequest.getLastRequestContent();
        String lastResponseContent = apiResourceRequest.getLastResponseContent();
        BigDecimal resourceSort = apiResourceRequest.getResourceSort();
        String createTime = apiResourceRequest.getCreateTime();
        Long createUser = apiResourceRequest.getCreateUser();
        String updateTime = apiResourceRequest.getUpdateTime();
        Long updateUser = apiResourceRequest.getUpdateUser();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)apiResourceId), ApiResource::getApiResourceId, (Object)apiResourceId);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)groupId), ApiResource::getGroupId, (Object)groupId);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)apiAlias), ApiResource::getApiAlias, (Object)apiAlias);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)resourceCode), ApiResource::getResourceCode, (Object)resourceCode);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)lastRequestContent), ApiResource::getLastRequestContent, (Object)lastRequestContent);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)lastResponseContent), ApiResource::getLastResponseContent, (Object)lastResponseContent);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)resourceSort), ApiResource::getResourceSort, (Object)resourceSort);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)createTime), ApiResource::getCreateTime, (Object)createTime);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)createUser), ApiResource::getCreateUser, (Object)createUser);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)updateTime), ApiResource::getUpdateTime, (Object)updateTime);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)updateUser), ApiResource::getUpdateUser, (Object)updateUser);
        return queryWrapper;
    }

    private ApiResourceField conversion(SysResource sysResource, Long apiResourceId, FieldMetadata fieldMetadata) {
        ApiResourceField item = new ApiResourceField();
        item.setApiResourceId(apiResourceId);
        item.setFieldCode(fieldMetadata.getFieldName());
        item.setFieldName(fieldMetadata.getChineseName());
        if (ObjectUtil.isEmpty((Object)fieldMetadata.getFieldClassPath())) {
            item.setFieldType("object");
        } else if (fieldMetadata.getFieldClassPath().contains("java.util")) {
            item.setFieldType("list");
        } else if (fieldMetadata.getFieldClassPath().contains("java.io")) {
            item.setFieldType("file");
        } else if (fieldMetadata.getFieldClassPath().contains("java.")) {
            item.setFieldType("string");
        } else {
            item.setFieldType("object");
        }
        item.setFieldRequired(this.isRequired(sysResource, fieldMetadata) ? YesOrNotEnum.Y.getCode() : YesOrNotEnum.N.getCode());
        item.setFieldValidationMsg(fieldMetadata.getValidationMessages());
        Set genericFieldMetadata = fieldMetadata.getGenericFieldMetadata();
        if (ObjectUtil.isNotEmpty((Object)genericFieldMetadata)) {
            HashSet<ApiResourceField> apiResourceFieldSet = new HashSet<ApiResourceField>();
            for (FieldMetadata genericFieldMetadatum : genericFieldMetadata) {
                ApiResourceField conversion = this.conversion(sysResource, apiResourceId, genericFieldMetadatum);
                if ("list".equals(item.getFieldType())) {
                    conversion.setFieldRequired(YesOrNotEnum.N.getCode());
                }
                apiResourceFieldSet.add(conversion);
            }
            item.setFieldSubInfo(JSON.toJSONString(apiResourceFieldSet, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
        }
        return item;
    }

    private boolean isRequired(SysResource sysResource, FieldMetadata fieldMetadata) {
        Set validateGroups;
        Set annotations = fieldMetadata.getAnnotations();
        if (ObjectUtil.isNotEmpty((Object)annotations) && ObjectUtil.isNotEmpty((Object)(validateGroups = (Set)JSON.parseObject((String)sysResource.getValidateGroups(), Set.class, (Feature[])new Feature[]{Feature.SupportAutoType})))) {
            Map groupValidationMessage = fieldMetadata.getGroupValidationMessage();
            for (String annotationName : annotations) {
                if (!"NotBlank".equalsIgnoreCase(annotationName) && !"NotNull".equalsIgnoreCase(annotationName)) continue;
                Set annotationGroups = groupValidationMessage.keySet();
                for (String group : annotationGroups) {
                    if (!validateGroups.contains(group)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

