/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.user.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.exception.enums.AuthExceptionEnum;
import cn.stylefeng.roses.kernel.auth.api.password.PasswordStoredEncryptApi;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.basic.SimpleUserInfo;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.file.api.FileInfoApi;
import cn.stylefeng.roses.kernel.file.api.constants.FileConstants;
import cn.stylefeng.roses.kernel.office.api.OfficeExcelApi;
import cn.stylefeng.roses.kernel.office.api.pojo.report.ExcelExportParam;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.TreeNodeEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import cn.stylefeng.roses.kernel.system.api.DataScopeApi;
import cn.stylefeng.roses.kernel.system.api.OrganizationServiceApi;
import cn.stylefeng.roses.kernel.system.api.ResourceServiceApi;
import cn.stylefeng.roses.kernel.system.api.RoleServiceApi;
import cn.stylefeng.roses.kernel.system.api.enums.UserStatusEnum;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.user.SysUserExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.expander.SystemConfigExpander;
import cn.stylefeng.roses.kernel.system.api.pojo.organization.DataScopeDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.organization.HrOrganizationDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.user.OnlineUserDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserOrgDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.user.UserLoginInfoDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.user.UserSelectTreeNode;
import cn.stylefeng.roses.kernel.system.api.pojo.user.request.OnlineUserRequest;
import cn.stylefeng.roses.kernel.system.api.pojo.user.request.SysUserRequest;
import cn.stylefeng.roses.kernel.system.api.util.DataScopeUtil;
import cn.stylefeng.roses.kernel.system.modular.user.entity.SysUser;
import cn.stylefeng.roses.kernel.system.modular.user.entity.SysUserDataScope;
import cn.stylefeng.roses.kernel.system.modular.user.entity.SysUserRole;
import cn.stylefeng.roses.kernel.system.modular.user.factory.OnlineUserCreateFactory;
import cn.stylefeng.roses.kernel.system.modular.user.factory.SysUserCreateFactory;
import cn.stylefeng.roses.kernel.system.modular.user.factory.UserLoginInfoFactory;
import cn.stylefeng.roses.kernel.system.modular.user.mapper.SysUserMapper;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserDataScopeService;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserOrgService;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserRoleService;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserService;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserServiceImpl
extends ServiceImpl<SysUserMapper, SysUser>
implements SysUserService {
    private static final Logger log = LoggerFactory.getLogger(SysUserServiceImpl.class);
    @Resource
    private SysUserOrgService sysUserOrgService;
    @Resource
    private SysUserRoleService sysUserRoleService;
    @Resource
    private SysUserDataScopeService sysUserDataScopeService;
    @Resource
    private OfficeExcelApi officeExcelApi;
    @Resource
    private DataScopeApi dataScopeApi;
    @Resource
    private RoleServiceApi roleServiceApi;
    @Resource
    private ResourceServiceApi resourceServiceApi;
    @Resource
    private FileInfoApi fileInfoApi;
    @Resource
    private PasswordStoredEncryptApi passwordStoredEncryptApi;
    @Resource
    private SessionManagerApi sessionManagerApi;
    @Resource
    private OrganizationServiceApi organizationServiceApi;
    @Resource
    private CacheOperatorApi<SysUserDTO> sysUserCacheOperatorApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(SysUserRequest sysUserRequest) {
        Long organizationId = sysUserRequest.getOrgId();
        DataScopeUtil.quickValidateDataScope((Long)organizationId);
        SysUser sysUser = new SysUser();
        BeanUtil.copyProperties((Object)sysUserRequest, (Object)((Object)sysUser), (String[])new String[0]);
        SysUserCreateFactory.fillAddSysUser(sysUser);
        sysUser.setAvatar(FileConstants.DEFAULT_AVATAR_FILE_ID);
        this.save((Object)sysUser);
        if (null == sysUserRequest.getPositionId()) {
            this.sysUserOrgService.add(sysUser.getUserId(), sysUserRequest.getOrgId());
        } else {
            this.sysUserOrgService.add(sysUser.getUserId(), sysUserRequest.getOrgId(), sysUserRequest.getPositionId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SysUserRequest sysUserRequest) {
        SysUser sysUser = this.querySysUser(sysUserRequest);
        if (YesOrNotEnum.Y.getCode().equals(sysUser.getSuperAdminFlag())) {
            throw new SystemModularException((AbstractExceptionEnum)SysUserExceptionEnum.USER_CAN_NOT_DELETE_ADMIN);
        }
        SysUserOrgDTO userOrgInfo = this.sysUserOrgService.getUserOrgByUserId(sysUser.getUserId());
        Long organizationId = userOrgInfo.getOrgId();
        DataScopeUtil.quickValidateDataScope((Long)organizationId);
        sysUser.setDelFlag(YesOrNotEnum.Y.getCode());
        this.updateById((Object)sysUser);
        Long userId = sysUser.getUserId();
        this.sysUserOrgService.delByUserId(userId);
        this.sysUserRoleService.delByUserId(userId);
        this.sysUserDataScopeService.delByUserId(userId);
        this.sysUserCacheOperatorApi.remove(new String[]{String.valueOf(userId)});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(SysUserRequest sysUserRequest) {
        Long organizationId = sysUserRequest.getOrgId();
        DataScopeUtil.quickValidateDataScope((Long)organizationId);
        SysUser sysUser = this.querySysUser(sysUserRequest);
        BeanUtil.copyProperties((Object)sysUserRequest, (Object)((Object)sysUser), (String[])new String[0]);
        SysUserCreateFactory.fillEditSysUser(sysUser);
        this.updateById((Object)sysUser);
        Long sysUserId = sysUser.getUserId();
        if (null == sysUserRequest.getPositionId()) {
            this.sysUserOrgService.edit(sysUser.getUserId(), sysUserRequest.getOrgId());
        } else {
            this.sysUserOrgService.edit(sysUser.getUserId(), sysUserRequest.getOrgId(), sysUserRequest.getPositionId());
        }
        this.sysUserCacheOperatorApi.remove(new String[]{String.valueOf(sysUserId)});
    }

    @Override
    public void editInfo(SysUserRequest sysUserRequest) {
        sysUserRequest.setUserId(LoginContext.me().getLoginUser().getUserId());
        SysUser sysUser = this.querySysUser(sysUserRequest);
        SysUserCreateFactory.fillUpdateInfo(sysUserRequest, sysUser);
        this.updateById((Object)sysUser);
        this.sysUserCacheOperatorApi.remove(new String[]{String.valueOf(sysUser.getUserId())});
    }

    @Override
    public void editStatus(SysUserRequest sysUserRequest) {
        Integer statusFlag = sysUserRequest.getStatusFlag();
        UserStatusEnum.validateUserStatus((Integer)statusFlag);
        SysUser sysUser = this.querySysUser(sysUserRequest);
        if (YesOrNotEnum.Y.getCode().equals(sysUser.getSuperAdminFlag())) {
            throw new SystemModularException((AbstractExceptionEnum)SysUserExceptionEnum.USER_CAN_NOT_UPDATE_ADMIN);
        }
        Long id = sysUser.getUserId();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(SysUser::getUserId, (Object)id)).and(i -> {
            LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)i.ne(SysUser::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        })).set(SysUser::getStatusFlag, (Object)statusFlag);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            log.error(SysUserExceptionEnum.UPDATE_USER_STATUS_ERROR.getUserTip());
            throw new SystemModularException((AbstractExceptionEnum)SysUserExceptionEnum.UPDATE_USER_STATUS_ERROR);
        }
        this.sysUserCacheOperatorApi.remove(new String[]{String.valueOf(sysUser.getUserId())});
    }

    @Override
    public void editPassword(SysUserRequest sysUserRequest) {
        LoginUser loginUser = LoginContext.me().getLoginUser();
        sysUserRequest.setUserId(loginUser.getUserId());
        SysUser sysUser = this.querySysUser(sysUserRequest);
        if (sysUserRequest.getNewPassword().equals(sysUserRequest.getPassword())) {
            throw new SystemModularException((AbstractExceptionEnum)SysUserExceptionEnum.USER_PWD_REPEAT);
        }
        if (!this.passwordStoredEncryptApi.checkPassword(sysUserRequest.getPassword(), sysUser.getPassword()).booleanValue()) {
            throw new SystemModularException((AbstractExceptionEnum)SysUserExceptionEnum.USER_PWD_ERROR);
        }
        sysUser.setPassword(this.passwordStoredEncryptApi.encrypt(sysUserRequest.getNewPassword()));
        this.updateById((Object)sysUser);
        this.sysUserCacheOperatorApi.remove(new String[]{String.valueOf(sysUser.getUserId())});
    }

    @Override
    public void resetPassword(SysUserRequest sysUserRequest) {
        SysUser sysUser = this.querySysUser(sysUserRequest);
        String password = SystemConfigExpander.getDefaultPassWord();
        sysUser.setPassword(this.passwordStoredEncryptApi.encrypt(password));
        this.updateById((Object)sysUser);
    }

    @Override
    public void editAvatar(SysUserRequest sysUserRequest) {
        Long fileId = sysUserRequest.getAvatar();
        LoginUser loginUser = LoginContext.me().getLoginUser();
        sysUserRequest.setUserId(loginUser.getUserId());
        SysUser sysUser = this.querySysUser(sysUserRequest);
        sysUser.setAvatar(fileId);
        this.updateById((Object)sysUser);
        SimpleUserInfo simpleUserInfo = loginUser.getSimpleUserInfo();
        simpleUserInfo.setAvatar(fileId);
        this.sessionManagerApi.updateSession(LoginContext.me().getToken(), loginUser);
        this.sysUserCacheOperatorApi.remove(new String[]{String.valueOf(sysUser.getUserId())});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void grantRole(SysUserRequest sysUserRequest) {
        SysUser sysUser = this.querySysUser(sysUserRequest);
        SysUserOrgDTO userOrgInfo = this.sysUserOrgService.getUserOrgByUserId(sysUser.getUserId());
        Long organizationId = userOrgInfo.getOrgId();
        DataScopeUtil.quickValidateDataScope((Long)organizationId);
        this.sysUserRoleService.assignRoles(sysUserRequest);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void grantData(SysUserRequest sysUserRequest) {
        SysUser sysUser = this.querySysUser(sysUserRequest);
        SysUserOrgDTO userOrgInfo = this.sysUserOrgService.getUserOrgByUserId(sysUser.getUserId());
        Long organizationId = userOrgInfo.getOrgId();
        DataScopeUtil.quickValidateDataScope((Long)organizationId);
        this.sysUserDataScopeService.assignData(sysUserRequest);
    }

    @Override
    public SysUserDTO detail(SysUserRequest sysUserRequest) {
        SysUserDTO sysUserResponse = new SysUserDTO();
        SysUser sysUser = this.querySysUser(sysUserRequest);
        BeanUtil.copyProperties((Object)((Object)sysUser), (Object)sysUserResponse, (String[])new String[0]);
        SysUserOrgDTO userOrgInfo = this.sysUserOrgService.getUserOrgByUserId(sysUser.getUserId());
        sysUserResponse.setOrgId(userOrgInfo.getOrgId());
        sysUserResponse.setPositionId(userOrgInfo.getPositionId());
        sysUserResponse.setGrantRoleIdList(this.sysUserRoleService.findRoleIdsByUserId(sysUser.getUserId()));
        return sysUserResponse;
    }

    @Override
    public PageResult<SysUserDTO> findPage(SysUserRequest sysUserRequest) {
        Page<SysUserDTO> userPage = ((SysUserMapper)this.baseMapper).findUserPage((Page<SysUser>)PageFactory.defaultPage(), sysUserRequest);
        return PageResultFactory.createPageResult(userPage);
    }

    @Override
    public List<SysUserDTO> getUserList(SysUserRequest sysUserRequest) {
        return ((SysUserMapper)this.baseMapper).findUserList(sysUserRequest);
    }

    @Override
    public void export(HttpServletResponse response) {
        ExcelExportParam excelExportParam = new ExcelExportParam();
        List sysUserList = this.list();
        excelExportParam.setClazz(SysUser.class);
        excelExportParam.setDataList(sysUserList);
        excelExportParam.setExcelTypeEnum(ExcelTypeEnum.XLS);
        excelExportParam.setFileName("\u7cfb\u7edf\u7528\u6237\u5bfc\u51fa");
        excelExportParam.setResponse(response);
        this.officeExcelApi.easyExportDownload(excelExportParam);
    }

    @Override
    public List<UserSelectTreeNode> userSelectTree(SysUserRequest sysUserRequest) {
        ArrayList treeNodeList = CollectionUtil.newArrayList((Object[])new UserSelectTreeNode[0]);
        List orgList = this.organizationServiceApi.orgList();
        for (HrOrganizationDTO hrOrganization : orgList) {
            UserSelectTreeNode orgTreeNode = new UserSelectTreeNode();
            orgTreeNode.setId(String.valueOf(hrOrganization.getOrgId()));
            orgTreeNode.setPId(String.valueOf(hrOrganization.getOrgParentId()));
            orgTreeNode.setName(hrOrganization.getOrgName());
            orgTreeNode.setNodeType(TreeNodeEnum.ORG.getCode());
            orgTreeNode.setValue(String.valueOf(hrOrganization.getOrgId()));
            orgTreeNode.setSort(hrOrganization.getOrgSort());
            treeNodeList.add(orgTreeNode);
            List<UserSelectTreeNode> userNodeList = this.getUserTreeNodeList(hrOrganization.getOrgId(), treeNodeList);
            if (userNodeList.size() <= 0) continue;
            treeNodeList.addAll(userNodeList);
        }
        return new DefaultTreeBuildFactory().doTreeBuild((List)treeNodeList);
    }

    @Override
    public SysUser getUserByAccount(String account) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUser::getAccount, (Object)account);
        queryWrapper.ne(SysUser::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        List list = this.list((Wrapper)queryWrapper);
        if (list.isEmpty()) {
            throw new SystemModularException((AbstractExceptionEnum)SysUserExceptionEnum.USER_NOT_EXIST, new Object[]{account});
        }
        if (list.size() > 1) {
            throw new SystemModularException((AbstractExceptionEnum)SysUserExceptionEnum.ACCOUNT_HAVE_MANY, new Object[]{account});
        }
        return (SysUser)((Object)list.get(0));
    }

    @Override
    public String getUserAvatarUrl(Long fileId) {
        return this.fileInfoApi.getFileAuthUrl(fileId);
    }

    @Override
    public String getUserAvatarUrl(Long fileId, String token) {
        return this.fileInfoApi.getFileAuthUrl(fileId, token);
    }

    @Override
    public List<UserSelectTreeNode> getUserTreeNodeList(Long orgId, List<UserSelectTreeNode> treeNodeList) {
        ArrayList newTreeNodeList = CollectionUtil.newArrayList((Object[])new UserSelectTreeNode[0]);
        SysUserRequest userRequest = new SysUserRequest();
        userRequest.setOrgId(orgId);
        List<SysUserDTO> userList = ((SysUserMapper)this.baseMapper).findUserList(userRequest);
        for (SysUserDTO user : userList) {
            UserSelectTreeNode userTreeNode = new UserSelectTreeNode();
            userTreeNode.setId(String.valueOf(user.getUserId()));
            userTreeNode.setPId(String.valueOf(user.getOrgId()));
            userTreeNode.setName(user.getRealName());
            userTreeNode.setNodeType(TreeNodeEnum.USER.getCode());
            userTreeNode.setValue(String.valueOf(user.getUserId()));
            boolean fillThisUser = true;
            for (UserSelectTreeNode userSelectTreeNode : treeNodeList) {
                if (!userSelectTreeNode.getNodeId().equals(userTreeNode.getId())) continue;
                fillThisUser = false;
                break;
            }
            if (!fillThisUser) continue;
            newTreeNodeList.add(userTreeNode);
        }
        return newTreeNodeList;
    }

    @Override
    public List<SimpleDict> selector(SysUserRequest sysUserRequest) {
        LambdaQueryWrapper<SysUser> wrapper = this.createWrapper(sysUserRequest);
        wrapper.ne(SysUser::getSuperAdminFlag, (Object)YesOrNotEnum.Y.getCode());
        wrapper.select(new SFunction[]{SysUser::getRealName, SysUser::getUserId});
        List list = this.list((Wrapper)wrapper);
        ArrayList<SimpleDict> results = new ArrayList<SimpleDict>();
        for (SysUser sysUser : list) {
            SimpleDict simpleDict = new SimpleDict();
            simpleDict.setId(sysUser.getUserId());
            simpleDict.setName(sysUser.getRealName());
            results.add(simpleDict);
        }
        return results;
    }

    @Override
    public void batchDelete(SysUserRequest sysUserRequest) {
        List userIds = sysUserRequest.getUserIds();
        for (Long userId : userIds) {
            SysUserRequest tempRequest = new SysUserRequest();
            tempRequest.setUserId(userId);
            this.del(tempRequest);
        }
    }

    @Override
    public List<Long> getAllUserIds() {
        LambdaQueryWrapper userLambdaQueryWrapper = new LambdaQueryWrapper();
        userLambdaQueryWrapper.select(new SFunction[]{SysUser::getUserId});
        userLambdaQueryWrapper.eq(SysUser::getStatusFlag, (Object)StatusEnum.ENABLE);
        userLambdaQueryWrapper.ne(SysUser::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        List list = this.list((Wrapper)userLambdaQueryWrapper);
        return list.stream().map(SysUser::getUserId).collect(Collectors.toList());
    }

    public UserLoginInfoDTO getUserLoginInfo(String account) {
        SysUser sysUser = this.getUserByAccount(account);
        Long userId = sysUser.getUserId();
        List<Long> roleIds = this.sysUserRoleService.findRoleIdsByUserId(userId);
        if (ObjectUtil.isEmpty(roleIds)) {
            throw new SystemModularException((AbstractExceptionEnum)AuthExceptionEnum.ROLE_IS_EMPTY);
        }
        List roleResponseList = this.roleServiceApi.getRolesByIds(roleIds);
        DataScopeDTO dataScopeResponse = this.dataScopeApi.getDataScope(userId, roleResponseList);
        SysUserOrgDTO userOrgInfo = this.sysUserOrgService.getUserOrgByUserId(userId);
        Set resourceCodeList = this.roleServiceApi.getRoleResourceCodeList(roleIds);
        Set resourceUrlsListByCodes = this.resourceServiceApi.getResourceUrlsListByCodes(resourceCodeList);
        Set roleButtonCodes = this.roleServiceApi.getRoleButtonCodes(roleIds);
        return UserLoginInfoFactory.userLoginInfoDTO(sysUser, roleResponseList, dataScopeResponse, userOrgInfo, resourceUrlsListByCodes, roleButtonCodes);
    }

    public LoginUser getEffectiveLoginUser(LoginUser loginUser) {
        UserLoginInfoDTO userLoginInfoDTO = this.getUserLoginInfo(loginUser.getAccount());
        LoginUser newLoginUser = userLoginInfoDTO.getLoginUser();
        newLoginUser.setToken(loginUser.getToken());
        newLoginUser.setTenantCode(loginUser.getTenantCode());
        newLoginUser.setWsUrl(loginUser.getWsUrl());
        return newLoginUser;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateUserLoginInfo(Long userId, Date date, String ip) {
        LambdaQueryWrapper sysUserLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)sysUserLambdaQueryWrapper.eq(SysUser::getUserId, (Object)userId)).eq(SysUser::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        SysUser sysUser = (SysUser)((Object)this.getOne((Wrapper)sysUserLambdaQueryWrapper));
        if (sysUser != null) {
            SysUser newSysUser = new SysUser();
            newSysUser.setUserId(sysUser.getUserId());
            newSysUser.setLastLoginIp(ip);
            newSysUser.setLastLoginTime(date);
            this.updateById((Object)newSysUser);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteUserDataScopeListByOrgIdList(Set<Long> organizationIds) {
        if (organizationIds != null && organizationIds.size() > 0) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysUserDataScope::getOrgId, organizationIds);
            this.sysUserDataScopeService.remove((Wrapper)queryWrapper);
        }
    }

    public List<Long> getUserRoleIdList(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserRole::getUserId, (Object)userId);
        queryWrapper.select(new SFunction[]{SysUserRole::getRoleId});
        List list = this.sysUserRoleService.list((Wrapper)queryWrapper);
        return list.stream().map(SysUserRole::getRoleId).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteUserRoleListByRoleId(Long roleId) {
        if (roleId != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysUserRole::getRoleId, (Object)roleId);
            this.sysUserRoleService.remove((Wrapper)queryWrapper);
        }
    }

    public List<Long> getUserBindDataScope(Long userId) {
        return this.sysUserDataScopeService.findOrgIdsByUserId(userId);
    }

    public List<OnlineUserDTO> onlineUserList(OnlineUserRequest onlineUserRequest) {
        List loginUsers = this.sessionManagerApi.onlineUserList();
        List<OnlineUserDTO> result = loginUsers.stream().map(OnlineUserCreateFactory::createOnlineUser).collect(Collectors.toList());
        if (StrUtil.isNotBlank((CharSequence)onlineUserRequest.getAccount())) {
            return result.stream().filter(i -> i.getAccount().equals(onlineUserRequest.getAccount())).collect(Collectors.toList());
        }
        return result;
    }

    public SysUserDTO getUserInfoByUserId(Long userId) {
        SysUserDTO sysUserDTO = (SysUserDTO)this.sysUserCacheOperatorApi.get(String.valueOf(userId));
        if (sysUserDTO != null) {
            return sysUserDTO;
        }
        SysUser sysUser = (SysUser)((Object)this.getById(userId));
        if (ObjectUtil.isNotEmpty((Object)((Object)sysUser))) {
            SysUserDTO result = (SysUserDTO)BeanUtil.copyProperties((Object)((Object)sysUser), SysUserDTO.class, (String[])new String[0]);
            this.sysUserCacheOperatorApi.put(String.valueOf(userId), (Object)result);
            return result;
        }
        return null;
    }

    public List<Long> queryAllUserIdList(SysUserRequest sysUserRequest) {
        LambdaQueryWrapper<SysUser> wrapper = this.createWrapper(sysUserRequest);
        wrapper.select(new SFunction[]{SysUser::getUserId});
        Function<Object, Long> mapper = id -> Long.valueOf(id.toString());
        return this.listObjs((Wrapper)wrapper, mapper);
    }

    public Boolean userExist(Long userId) {
        SysUserRequest userRequest = new SysUserRequest();
        userRequest.setUserId(userId);
        LambdaQueryWrapper<SysUser> wrapper = this.createWrapper(userRequest);
        wrapper.select(new SFunction[]{SysUser::getUserId});
        SysUser sysUser = (SysUser)((Object)this.getOne((Wrapper)wrapper));
        if (sysUser == null || sysUser.getUserId() == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private SysUser querySysUser(SysUserRequest sysUserRequest) {
        String userIdKey = String.valueOf(sysUserRequest.getUserId());
        SysUserDTO sysUserDTO = (SysUserDTO)this.sysUserCacheOperatorApi.get(userIdKey);
        if (sysUserDTO != null) {
            SysUser tempUser = new SysUser();
            BeanUtil.copyProperties((Object)sysUserDTO, (Object)((Object)tempUser), (String[])new String[0]);
            return tempUser;
        }
        SysUser sysUser = (SysUser)((Object)this.getById(sysUserRequest.getUserId()));
        if (ObjectUtil.isNull((Object)((Object)sysUser))) {
            throw new SystemModularException((AbstractExceptionEnum)SysUserExceptionEnum.USER_NOT_EXIST, new Object[]{sysUserRequest.getUserId()});
        }
        SysUserDTO sysUserDTOCache = new SysUserDTO();
        BeanUtil.copyProperties((Object)((Object)sysUser), (Object)sysUserDTOCache, (String[])new String[0]);
        this.sysUserCacheOperatorApi.put(userIdKey, (Object)sysUserDTOCache);
        return sysUser;
    }

    private LambdaQueryWrapper<SysUser> createWrapper(SysUserRequest sysUserRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUser::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        if (ObjectUtil.isEmpty((Object)sysUserRequest)) {
            return queryWrapper;
        }
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)sysUserRequest.getUserId()), SysUser::getUserId, (Object)sysUserRequest.getUserId());
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)sysUserRequest.getAccount()), SysUser::getAccount, (Object)sysUserRequest.getAccount());
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)sysUserRequest.getRealName()), SysUser::getRealName, (Object)sysUserRequest.getRealName());
        return queryWrapper;
    }
}

