/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.user.controller;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.AuthServiceApi;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginRequest;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginResponse;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginWithTokenRequest;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import cn.stylefeng.roses.kernel.system.api.pojo.login.CurrentUserInfoResponse;
import cn.stylefeng.roses.kernel.system.api.pojo.login.ValidateTokenRequest;
import cn.stylefeng.roses.kernel.system.api.pojo.login.v3.IndexUserInfoV3;
import cn.stylefeng.roses.kernel.system.modular.user.factory.UserLoginInfoFactory;
import cn.stylefeng.roses.kernel.system.modular.user.service.IndexUserInfoService;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResource(name="\u767b\u9646\u767b\u51fa\u7ba1\u7406")
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Resource
    private AuthServiceApi authServiceApi;
    @Resource
    private SessionManagerApi sessionManagerApi;
    @Resource
    private IndexUserInfoService indexUserInfoService;
    @Resource(name="caClientTokenCacheApi")
    private CacheOperatorApi<String> caClientTokenCacheApi;

    @PostResource(name="\u767b\u9646", path={"/login"}, requiredLogin=false, requiredPermission=false)
    public ResponseData<String> login(@RequestBody @Validated LoginRequest loginRequest) {
        loginRequest.setCreateCookie(Boolean.valueOf(true));
        LoginResponse loginResponse = this.authServiceApi.login(loginRequest);
        return new SuccessResponseData((Object)loginResponse.getToken());
    }

    @PostResource(name="\u767b\u9646\uff08\u5206\u79bb\u7248\uff09", path={"/loginApi"}, requiredLogin=false, requiredPermission=false)
    public ResponseData<LoginResponse> loginApi(@RequestBody @Validated LoginRequest loginRequest) {
        loginRequest.setCreateCookie(Boolean.valueOf(false));
        LoginResponse loginResponse = this.authServiceApi.login(loginRequest);
        return new SuccessResponseData((Object)loginResponse);
    }

    @PostResource(name="\u9002\u7528\u4e8e\u5355\u70b9\u767b\u5f55", path={"/loginWithToken"}, requiredLogin=false, requiredPermission=false)
    public ResponseData<String> loginWithToken(@RequestBody @Validated LoginWithTokenRequest loginWithTokenRequest) {
        LoginResponse loginResponse = this.authServiceApi.LoginWithToken(loginWithTokenRequest);
        return new SuccessResponseData((Object)loginResponse.getToken());
    }

    @ApiResource(name="\u5355\u70b9\u9000\u51fa", path={"/logoutByCaClientToken"}, requiredLogin=false, requiredPermission=false, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData<?> ssoLogout(@RequestParam(value="caClientToken") String caClientToken) {
        String currentSystemToken = (String)this.caClientTokenCacheApi.get(caClientToken);
        if (StrUtil.isNotBlank((CharSequence)currentSystemToken)) {
            this.authServiceApi.logoutWithToken(currentSystemToken);
            this.caClientTokenCacheApi.remove(new String[]{caClientToken});
        }
        return new SuccessResponseData();
    }

    @ApiResource(name="\u767b\u51fa", path={"/logoutAction"}, requiredPermission=false, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData<?> logoutAction() {
        this.authServiceApi.logout();
        return new SuccessResponseData();
    }

    @GetResource(name="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u7528\u6237\u4fe1\u606f", path={"/getCurrentLoginUserInfo"}, requiredPermission=false)
    public ResponseData<CurrentUserInfoResponse> getCurrentLoginUserInfo() {
        LoginUser loginUser = LoginContext.me().getLoginUser();
        CurrentUserInfoResponse currentUserInfoResponse = UserLoginInfoFactory.parseUserInfo(loginUser);
        return new SuccessResponseData((Object)currentUserInfoResponse);
    }

    @PostResource(name="\u6821\u9a8ctoken\u662f\u5426\u6b63\u786e", path={"/validateToken"}, requiredPermission=false, requiredLogin=false)
    public ResponseData<Boolean> validateToken(@RequestBody @Valid ValidateTokenRequest validateTokenRequest) {
        boolean haveSessionFlag = this.sessionManagerApi.haveSession(validateTokenRequest.getToken());
        return new SuccessResponseData((Object)haveSessionFlag);
    }

    @PostResource(name="\u53d6\u6d88\u5e10\u53f7\u51bb\u7ed3", path={"/cancelFreeze"})
    public ResponseData<?> cancelFreeze(@RequestBody @Validated(value={LoginRequest.cancelFreeze.class}) LoginRequest loginRequest) {
        this.authServiceApi.cancelFreeze(loginRequest);
        return new SuccessResponseData();
    }

    @GetResource(name="\u65b0\u7248Antdv3\u7248\u672c\u7684\u7528\u6237\u4fe1\u606f\u83b7\u53d6", path={"/v3/userInfo"}, requiredPermission=false)
    public ResponseData<IndexUserInfoV3> userInfoV3(Integer menuFrontType) {
        return new SuccessResponseData((Object)this.indexUserInfoService.userInfoV3(menuFrontType));
    }
}

