/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.user.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.basic.SimpleRoleInfo;
import cn.stylefeng.roses.kernel.rule.enums.SexEnum;
import cn.stylefeng.roses.kernel.system.api.MenuServiceApi;
import cn.stylefeng.roses.kernel.system.api.enums.MenuFrontTypeEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.login.v3.IndexRoleInfo;
import cn.stylefeng.roses.kernel.system.api.pojo.login.v3.IndexUserInfoV3;
import cn.stylefeng.roses.kernel.system.modular.user.service.IndexUserInfoService;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class IndexUserInfoServiceImpl
implements IndexUserInfoService {
    @Resource
    private SysUserService sysUserService;
    @Resource
    private MenuServiceApi menuServiceApi;

    @Override
    public IndexUserInfoV3 userInfoV3(Integer menuFrontType) {
        LoginUser loginUser = LoginContext.me().getLoginUser();
        IndexUserInfoV3 indexUserInfoV3 = new IndexUserInfoV3();
        indexUserInfoV3.setUserId(loginUser.getUserId());
        indexUserInfoV3.setRealName(loginUser.getSimpleUserInfo().getRealName());
        indexUserInfoV3.setUsername(loginUser.getAccount());
        indexUserInfoV3.setNickname(loginUser.getSimpleUserInfo().getNickName());
        Long avatarFileId = loginUser.getSimpleUserInfo().getAvatar();
        String userAvatarUrl = this.sysUserService.getUserAvatarUrl(avatarFileId, loginUser.getToken());
        indexUserInfoV3.setAvatar(userAvatarUrl);
        indexUserInfoV3.setSex(loginUser.getSimpleUserInfo().getSex());
        indexUserInfoV3.setPhone(loginUser.getSimpleUserInfo().getPhone());
        indexUserInfoV3.setEmail(loginUser.getSimpleUserInfo().getEmail());
        indexUserInfoV3.setBirthday(loginUser.getSimpleUserInfo().getBirthday());
        indexUserInfoV3.setOrganizationId(loginUser.getOrganizationId());
        indexUserInfoV3.setStatus(null);
        indexUserInfoV3.setSexName(SexEnum.codeToMessage((String)indexUserInfoV3.getSex()));
        indexUserInfoV3.setOrganizationName(null);
        indexUserInfoV3.setRoles(this.buildRoles(loginUser));
        if (ObjectUtil.isEmpty((Object)menuFrontType)) {
            menuFrontType = MenuFrontTypeEnum.FRONT.getCode();
        }
        indexUserInfoV3.setAuthorities(this.menuServiceApi.buildAuthorities(menuFrontType));
        indexUserInfoV3.setWsUrl(loginUser.getWsUrl());
        indexUserInfoV3.setAuthCodes(loginUser.getButtonCodes());
        return indexUserInfoV3;
    }

    private List<IndexRoleInfo> buildRoles(LoginUser loginUser) {
        List simpleRoleInfoList = loginUser.getSimpleRoleInfoList();
        ArrayList<IndexRoleInfo> indexRoleInfos = new ArrayList<IndexRoleInfo>();
        if (simpleRoleInfoList.size() > 0) {
            for (SimpleRoleInfo simpleRoleInfo : simpleRoleInfoList) {
                IndexRoleInfo indexRoleInfo = new IndexRoleInfo();
                BeanUtil.copyProperties((Object)simpleRoleInfo, (Object)indexRoleInfo, (String[])new String[0]);
                indexRoleInfos.add(indexRoleInfo);
            }
        }
        return indexRoleInfos;
    }
}

