/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.integration.config;

import cn.stylefeng.roses.kernel.auth.api.LoginUserApi;
import cn.stylefeng.roses.kernel.system.integration.core.CustomBeetlGroupUtilConfiguration;
import cn.stylefeng.roses.kernel.system.integration.core.expander.BeetlConfigExpander;
import java.util.Properties;
import org.beetl.core.ResourceLoader;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.ext.spring.BeetlGroupUtilConfiguration;
import org.beetl.ext.spring.BeetlSpringViewResolver;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BeetlAutoConfiguration {
    @Value(value="${spring.mvc.view.prefix}")
    private String prefix;

    @Bean(initMethod="init")
    public CustomBeetlGroupUtilConfiguration customBeetlGroupUtilConfiguration(LoginUserApi loginUserApi) {
        CustomBeetlGroupUtilConfiguration customBeetlGroupUtilConfiguration = new CustomBeetlGroupUtilConfiguration(loginUserApi);
        customBeetlGroupUtilConfiguration.setResourceLoader((ResourceLoader)new ClasspathResourceLoader(BeetlAutoConfiguration.class.getClassLoader(), this.prefix));
        customBeetlGroupUtilConfiguration.setConfigProperties(this.createBeetlProperties());
        return customBeetlGroupUtilConfiguration;
    }

    @Bean
    public BeetlSpringViewResolver beetlViewResolver(CustomBeetlGroupUtilConfiguration customBeetlGroupUtilConfiguration) {
        BeetlSpringViewResolver beetlSpringViewResolver = new BeetlSpringViewResolver();
        beetlSpringViewResolver.setConfig((BeetlGroupUtilConfiguration)customBeetlGroupUtilConfiguration);
        beetlSpringViewResolver.setContentType("text/html;charset=UTF-8");
        beetlSpringViewResolver.setOrder(0);
        return beetlSpringViewResolver;
    }

    private Properties createBeetlProperties() {
        Properties properties = new Properties();
        properties.setProperty("DELIMITER_STATEMENT_START", BeetlConfigExpander.getDelimiterStatementStart());
        properties.setProperty("DELIMITER_STATEMENT_END", BeetlConfigExpander.getDelimiterStatementEnd());
        properties.setProperty("HTML_TAG_FLAG", BeetlConfigExpander.getHtmlTagFlag());
        properties.setProperty("RESOURCE.tagRoot", BeetlConfigExpander.getResourceTagRoot());
        properties.setProperty("RESOURCE.tagSuffix", BeetlConfigExpander.getResourceTagSuffix());
        properties.setProperty("RESOURCE.autoCheck", BeetlConfigExpander.getResourceAutoCheck());
        return properties;
    }
}

