/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.validator.api.utils;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.validator.api.exception.ParamValidateException;
import cn.stylefeng.roses.kernel.validator.api.exception.enums.ValidatorExceptionEnum;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;

public class ValidatorUtil {
    private static final Validator VALIDATOR_INSTANCE = Validation.buildDefaultValidatorFactory().getValidator();

    public static Set<ConstraintViolation<Object>> validate(Object object, Class<?> ... groups) {
        return VALIDATOR_INSTANCE.validate(object, (Class[])groups);
    }

    public static boolean simpleValidate(Object object, Class<?> ... groups) {
        Set constraintViolations = VALIDATOR_INSTANCE.validate(object, (Class[])groups);
        return constraintViolations.isEmpty();
    }

    public static void validateThrowMessage(Object object, Class<?> ... groups) {
        String errorMessage = ValidatorUtil.validateGetMessage(object, groups);
        if (errorMessage != null) {
            throw new ParamValidateException(ValidatorExceptionEnum.VALIDATED_RESULT_ERROR, errorMessage);
        }
    }

    public static String validateGetMessage(Object object, Class<?> ... groups) {
        Set constraintViolations = VALIDATOR_INSTANCE.validate(object, (Class[])groups);
        if (!constraintViolations.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder();
            Iterator it = constraintViolations.iterator();
            while (it.hasNext()) {
                ConstraintViolation violation = (ConstraintViolation)it.next();
                errorMessage.append(violation.getMessage());
                if (!it.hasNext()) continue;
                errorMessage.append(", ");
            }
            return StrUtil.format((CharSequence)ValidatorExceptionEnum.VALIDATED_RESULT_ERROR.getUserTip(), (Object[])new Object[]{errorMessage});
        }
        return null;
    }
}

