/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.config.IdcardEnum;
import cn.xfyun.config.IntsigRecgEnum;
import cn.xfyun.model.sign.Signature;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;

public class IntsigOcrClient
extends HttpClient {
    private IntsigRecgEnum intsigRecgEnum;
    private IdcardEnum headPortrait;
    private IdcardEnum cropImage;
    private IdcardEnum idNumberImage;
    private IdcardEnum recognizeMode;

    public IdcardEnum getHeadPortrait() {
        return this.headPortrait;
    }

    public IdcardEnum getCropImage() {
        return this.cropImage;
    }

    public IdcardEnum getIdNumberImage() {
        return this.idNumberImage;
    }

    public IdcardEnum getRecognizeMode() {
        return this.recognizeMode;
    }

    public IntsigOcrClient(Builder builder) {
        super((HttpBuilder)builder);
        this.intsigRecgEnum = builder.intsigRecgEnum;
        this.headPortrait = builder.headPortrait;
        this.cropImage = builder.cropImage;
        this.idNumberImage = builder.idNumberImage;
        this.recognizeMode = builder.recognizeMode;
    }

    public String intsigRecg(String imageBase64) throws IOException {
        Map header = Signature.signHttpHeaderCheckSum((String)this.appId, (String)this.apiKey, (String)this.buildParam());
        return this.sendPost(this.hostUrl + this.intsigRecgEnum.getValue(), FORM, header, "image=" + imageBase64);
    }

    private String buildParam() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("engine_type", this.intsigRecgEnum.getValue());
        if (this.intsigRecgEnum.equals((Object)IntsigRecgEnum.IDCARD)) {
            jsonObject.addProperty("head_portrait", this.headPortrait.getValue());
            jsonObject.addProperty("crop_image", this.cropImage.getValue());
            jsonObject.addProperty("id_number_image", this.idNumberImage.getValue());
            jsonObject.addProperty("recognize_mode", this.recognizeMode.getValue());
        }
        return jsonObject.toString();
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://webapi.xfyun.cn/v1/service/v1/ocr/";
        private IntsigRecgEnum intsigRecgEnum;
        private IdcardEnum headPortrait = IdcardEnum.OFF;
        private IdcardEnum cropImage = IdcardEnum.OFF;
        private IdcardEnum idNumberImage = IdcardEnum.OFF;
        private IdcardEnum recognizeMode = IdcardEnum.OFF;

        public Builder(String appId, String apiKey, IntsigRecgEnum intsigRecgEnum) {
            super(HOST_URL, appId, apiKey, null);
            this.intsigRecgEnum = intsigRecgEnum;
        }

        public Builder headPortrait(IdcardEnum idcardEnum) {
            this.headPortrait = idcardEnum;
            return this;
        }

        public Builder cropImage(IdcardEnum idcardEnum) {
            this.cropImage = idcardEnum;
            return this;
        }

        public Builder idNumberImage(IdcardEnum idcardEnum) {
            this.idNumberImage = idcardEnum;
            return this;
        }

        public Builder recognizeMode(IdcardEnum idcardEnum) {
            this.recognizeMode = idcardEnum;
            return this;
        }

        public IntsigOcrClient build() {
            return new IntsigOcrClient(this);
        }
    }
}

