/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.config.ItrEntEnum;
import cn.xfyun.model.sign.Signature;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;

public class ItrClient
extends HttpClient {
    private ItrEntEnum itrEntEnum;

    public ItrEntEnum getItrEntEnum() {
        return this.itrEntEnum;
    }

    public ItrClient(Builder builder) {
        super((HttpBuilder)builder);
        this.itrEntEnum = builder.itrEntEnum;
    }

    public String itr(String imageBase64) throws Exception {
        String body = this.buildHttpBody(imageBase64);
        Map header = Signature.signHttpHeaderDigest((String)this.hostUrl, (String)"POST", (String)this.apiKey, (String)this.apiSecret, (String)body);
        return this.sendPost(this.hostUrl, JSON, header, body);
    }

    private String buildHttpBody(String imageBase64) {
        JsonObject body = new JsonObject();
        JsonObject business = new JsonObject();
        JsonObject common = new JsonObject();
        JsonObject data = new JsonObject();
        common.addProperty("app_id", this.appId);
        business.addProperty("ent", this.itrEntEnum.getValue());
        business.addProperty("aue", "raw");
        data.addProperty("image", imageBase64);
        body.add("common", (JsonElement)common);
        body.add("business", (JsonElement)business);
        body.add("data", (JsonElement)data);
        return body.toString();
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://rest-api.xfyun.cn/v2/itr";
        private ItrEntEnum itrEntEnum;

        public Builder(String appId, String apiKey, String apiSecret, ItrEntEnum itrEntEnum) {
            super(HOST_URL, appId, apiKey, apiSecret);
            this.itrEntEnum = itrEntEnum;
        }

        public ItrClient build() {
            return new ItrClient(this);
        }
    }
}

