/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.convertor;

import cn.zhxu.bs.FieldConvertor;
import cn.zhxu.bs.FieldMeta;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;

public class DateFieldConvertor
implements FieldConvertor.BFieldConvertor {
    private ZoneId zoneId = ZoneId.systemDefault();

    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType) {
        if (valueType == Date.class || valueType == java.sql.Date.class || valueType == Timestamp.class || valueType == LocalDateTime.class || valueType == LocalDate.class) {
            Class<?> targetType = meta.getType();
            return targetType == Date.class || targetType == java.sql.Date.class || targetType == Timestamp.class || targetType == LocalDateTime.class || targetType == LocalDate.class;
        }
        return false;
    }

    @Override
    public Object convert(FieldMeta meta, Object value) {
        return this.convert(meta.getType(), value);
    }

    public Object convert(Class<?> targetType, Object value) {
        Class<?> valueType = value.getClass();
        if (Date.class.isAssignableFrom(valueType)) {
            Date date = (Date)value;
            if (targetType == java.sql.Date.class) {
                return new java.sql.Date(date.getTime());
            }
            if (targetType == Timestamp.class) {
                return new Timestamp(date.getTime());
            }
            if (targetType == LocalDateTime.class) {
                if (date instanceof java.sql.Date) {
                    LocalDate localDate = ((java.sql.Date)date).toLocalDate();
                    return LocalDateTime.of(localDate, LocalTime.of(0, 0, 0, 0));
                }
                return LocalDateTime.ofInstant(date.toInstant(), this.zoneId);
            }
            if (targetType == LocalDate.class) {
                if (date instanceof java.sql.Date) {
                    return ((java.sql.Date)date).toLocalDate();
                }
                return this.toLocalDate(date.toInstant());
            }
            if (targetType == Date.class) {
                return date;
            }
        }
        LocalDateTime dateTime = valueType == LocalDateTime.class ? (LocalDateTime)value : LocalDateTime.of((LocalDate)value, LocalTime.of(0, 0));
        if (targetType == LocalDateTime.class) {
            return dateTime;
        }
        Instant instant = dateTime.atZone(this.zoneId).toInstant();
        if (targetType == Date.class) {
            return new Date(instant.toEpochMilli());
        }
        if (targetType == java.sql.Date.class) {
            return new java.sql.Date(instant.toEpochMilli());
        }
        if (targetType == Timestamp.class) {
            return new Timestamp(instant.toEpochMilli());
        }
        if (targetType == LocalDate.class) {
            return this.toLocalDate(instant);
        }
        throw new IllegalStateException("The supports(FieldMeta, Class<?>) method must be called first and return true before invoking convert(FieldMeta, Object) method.");
    }

    protected LocalDate toLocalDate(Instant instant) {
        ZoneOffset offset = this.zoneId.getRules().getOffset(instant);
        long localSecond = instant.getEpochSecond() + (long)offset.getTotalSeconds();
        long localEpochDay = Math.floorDiv(localSecond, 86400L);
        return LocalDate.ofEpochDay(localEpochDay);
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }
}

