/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.implement;

import cn.zhxu.bs.BeanMeta;
import cn.zhxu.bs.FieldMeta;
import cn.zhxu.bs.bean.Cluster;
import cn.zhxu.bs.group.Group;
import cn.zhxu.bs.group.GroupPair;
import cn.zhxu.bs.param.FieldParam;
import cn.zhxu.bs.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class GroupPairResolver
implements GroupPair.Resolver {
    @Override
    public GroupPair resolve(BeanMeta<?> beanMeta, Group<List<FieldParam>> paramsGroup, String groupBy) {
        Predicate<FieldParam> havingTester = p -> this.isClusterField(beanMeta, (FieldParam)p, groupBy);
        if (paramsGroup.isRaw()) {
            return this.buildGroupPair(paramsGroup.getValue(), havingTester);
        }
        if (paramsGroup.judgeAll(list -> {
            for (FieldParam param : list) {
                if (!havingTester.test(param)) continue;
                return false;
            }
            return true;
        })) {
            return new GroupPair(paramsGroup, GroupPair.EMPTY_GROUP);
        }
        if (paramsGroup.judgeAll(list -> {
            for (FieldParam param : list) {
                if (havingTester.test(param)) continue;
                return false;
            }
            return true;
        })) {
            return new GroupPair(GroupPair.EMPTY_GROUP, paramsGroup);
        }
        return this.buildGroupPair(paramsGroup, havingTester);
    }

    public boolean isClusterField(BeanMeta<?> beanMeta, FieldParam param, String groupBy) {
        FieldMeta meta = beanMeta.requireFieldMeta(param.getName());
        Cluster cluster = meta.getCluster();
        if (cluster == Cluster.FALSE) {
            return false;
        }
        if (cluster == Cluster.TRUE) {
            return true;
        }
        return meta.selectable() && !StringUtils.sqlContains(groupBy, meta.getFieldSql().getSql());
    }

    public GroupPair buildGroupPair(List<FieldParam> params, Predicate<FieldParam> havingTester) {
        ArrayList<FieldParam> where = new ArrayList<FieldParam>();
        ArrayList<FieldParam> having = new ArrayList<FieldParam>();
        for (FieldParam param : params) {
            if (havingTester.test(param)) {
                having.add(param);
                continue;
            }
            where.add(param);
        }
        return new GroupPair(this.group(where), this.group(having));
    }

    public Group<List<FieldParam>> group(List<FieldParam> params) {
        return params.isEmpty() ? GroupPair.EMPTY_GROUP : new Group<List<FieldParam>>(params);
    }

    public GroupPair buildGroupPair(Group<List<FieldParam>> group, Predicate<FieldParam> havingTester) {
        if (group == GroupPair.EMPTY_GROUP) {
            return GroupPair.EMPTY_PAIR;
        }
        if (group.isRaw()) {
            return this.buildGroupPair(group.getValue(), havingTester);
        }
        List children = group.getGroups().stream().map(g -> this.buildGroupPair((Group<List<FieldParam>>)g, havingTester)).collect(Collectors.toList());
        if (children.isEmpty()) {
            return GroupPair.EMPTY_PAIR;
        }
        Group<List<FieldParam>> where = ((GroupPair)children.get(0)).getWhereGroup();
        Group<List<FieldParam>> having = ((GroupPair)children.get(0)).getHavingGroup();
        for (int i = 1; i < children.size(); ++i) {
            GroupPair pair = (GroupPair)children.get(i);
            if (pair == GroupPair.EMPTY_PAIR) continue;
            where = this.compute(where, pair.getWhereGroup(), group.isAnd());
            having = this.compute(having, pair.getHavingGroup(), group.isAnd());
        }
        return new GroupPair(where, having);
    }

    public Group<List<FieldParam>> compute(Group<List<FieldParam>> group, Group<List<FieldParam>> other, boolean isAnd) {
        if (group == GroupPair.EMPTY_GROUP) {
            return other;
        }
        if (other == GroupPair.EMPTY_GROUP) {
            return group;
        }
        if (isAnd) {
            return group.and(other);
        }
        return group.or(other);
    }
}

