/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.util;

import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.operator.SqlCond;
import cn.zhxu.bs.param.FieldParam;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Builder<B extends Builder<B>> {
    public static final String ROOT_GROUP = "$";
    protected final Map<String, Object> map;
    protected String group = "$";
    private FieldParam fieldParam = null;

    public Builder(Map<String, Object> map) {
        this.map = map;
    }

    public <T> B field(FieldFns.FieldFn<T, ?> fieldFn, Collection<?> values) {
        return this.field(fieldFn, values.toArray());
    }

    public <T> B field(FieldFns.FieldFn<T, ?> fieldFn, Object ... values) {
        return this.field(FieldFns.name(fieldFn), values);
    }

    public <T> B field(String fieldName, Collection<?> values) {
        return this.field(fieldName, values.toArray());
    }

    public B field(String fieldName, Object ... values) {
        if (fieldName != null) {
            ArrayList<FieldParam.Value> pValues = new ArrayList<FieldParam.Value>();
            for (int index = 0; index < values.length; ++index) {
                pValues.add(new FieldParam.Value(values[index], index));
            }
            String field = fieldName.trim();
            this.fieldParam = new FieldParam(field, pValues);
            if (this.group != null) {
                this.map.put(this.group + MapBuilder.FIELD_PARAM + field, this.fieldParam);
            }
            if (ROOT_GROUP.equals(this.group)) {
                this.map.put(MapBuilder.FIELD_PARAM + field, this.fieldParam);
            }
        }
        return (B)this;
    }

    @SafeVarargs
    public final <T> B field(FieldFns.FieldFn<T, ?> fieldFn, FieldFns.FieldFn<T, ?> ... fieldFns) {
        return this.field(FieldFns.name(fieldFn), (Object[])this.toFields(fieldFns));
    }

    public B op(String operator) {
        return this.fieldOp(operator);
    }

    public B op(Class<? extends FieldOp> operator) {
        return this.fieldOp(operator);
    }

    public B op(FieldOp operator) {
        return this.fieldOp(operator);
    }

    private B fieldOp(Object operator) {
        if (this.fieldParam == null) {
            throw new IllegalStateException("The method op(...) must go after field(...) method.");
        }
        this.fieldParam.setOperator(operator);
        return (B)this;
    }

    public B ic() {
        return this.ic(true);
    }

    public B ic(boolean ignoreCase) {
        if (this.fieldParam == null) {
            throw new IllegalStateException("The method ic(...) must go after field(...) method.");
        }
        this.fieldParam.setIgnoreCase(ignoreCase);
        return (B)this;
    }

    public B sql(String sqlCond) {
        return this.fieldOp(new SqlCond(sqlCond));
    }

    public B sql(String sqlCond, Object ... args) {
        return this.fieldOp(new SqlCond(sqlCond, args));
    }

    @SafeVarargs
    protected final <T> String[] toFields(FieldFns.FieldFn<T, ?> ... fieldFns) {
        String[] fields = new String[fieldFns.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = FieldFns.name(fieldFns[i]);
        }
        return fields;
    }

    protected <T> List<T> obtainList(String key) {
        Object value = this.map.get(key);
        ArrayList list = null;
        if (value instanceof List) {
            ArrayList l;
            list = l = (ArrayList)value;
        }
        if (list == null) {
            list = new ArrayList();
            this.map.put(key, list);
        }
        return list;
    }
}

