/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketAggregateBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class TermsAggregateBase<TBucket>
extends MultiBucketAggregateBase<TBucket> {
    @Nullable
    private final Long docCountErrorUpperBound;
    @Nullable
    private final Long sumOtherDocCount;

    protected TermsAggregateBase(AbstractBuilder<TBucket, ?> builder) {
        super(builder);
        this.docCountErrorUpperBound = ((AbstractBuilder)builder).docCountErrorUpperBound;
        this.sumOtherDocCount = ((AbstractBuilder)builder).sumOtherDocCount;
    }

    @Nullable
    public final Long docCountErrorUpperBound() {
        return this.docCountErrorUpperBound;
    }

    @Nullable
    public final Long sumOtherDocCount() {
        return this.sumOtherDocCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.docCountErrorUpperBound != null) {
            generator.writeKey("doc_count_error_upper_bound");
            generator.write(this.docCountErrorUpperBound.longValue());
        }
        if (this.sumOtherDocCount != null) {
            generator.writeKey("sum_other_doc_count");
            generator.write(this.sumOtherDocCount.longValue());
        }
    }

    protected static <TBucket, BuilderT extends AbstractBuilder<TBucket, BuilderT>> void setupTermsAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TBucket> tBucketDeserializer) {
        MultiBucketAggregateBase.setupMultiBucketAggregateBaseDeserializer(op, tBucketDeserializer);
        op.add(AbstractBuilder::docCountErrorUpperBound, JsonpDeserializer.longDeserializer(), "doc_count_error_upper_bound");
        op.add(AbstractBuilder::sumOtherDocCount, JsonpDeserializer.longDeserializer(), "sum_other_doc_count");
    }

    public static abstract class AbstractBuilder<TBucket, BuilderT extends AbstractBuilder<TBucket, BuilderT>>
    extends MultiBucketAggregateBase.AbstractBuilder<TBucket, BuilderT> {
        @Nullable
        private Long docCountErrorUpperBound;
        @Nullable
        private Long sumOtherDocCount;

        public final BuilderT docCountErrorUpperBound(@Nullable Long value) {
            this.docCountErrorUpperBound = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT sumOtherDocCount(@Nullable Long value) {
            this.sumOtherDocCount = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

