/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.RuntimeFieldsType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class RuntimeFieldTypes
extends Base {
    private final List<RuntimeFieldsType> fieldTypes;
    public static final JsonpDeserializer<RuntimeFieldTypes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RuntimeFieldTypes::setupRuntimeFieldTypesDeserializer);

    private RuntimeFieldTypes(Builder builder) {
        super(builder);
        this.fieldTypes = ApiTypeHelper.unmodifiableRequired(builder.fieldTypes, (Object)this, "fieldTypes");
    }

    public static RuntimeFieldTypes of(Function<Builder, ObjectBuilder<RuntimeFieldTypes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<RuntimeFieldsType> fieldTypes() {
        return this.fieldTypes;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.fieldTypes)) {
            generator.writeKey("field_types");
            generator.writeStartArray();
            for (RuntimeFieldsType item0 : this.fieldTypes) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRuntimeFieldTypesDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::fieldTypes, JsonpDeserializer.arrayDeserializer(RuntimeFieldsType._DESERIALIZER), "field_types");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<RuntimeFieldTypes> {
        private List<RuntimeFieldsType> fieldTypes;

        public final Builder fieldTypes(List<RuntimeFieldsType> list) {
            this.fieldTypes = Builder._listAddAll(this.fieldTypes, list);
            return this;
        }

        public final Builder fieldTypes(RuntimeFieldsType value, RuntimeFieldsType ... values) {
            this.fieldTypes = Builder._listAdd(this.fieldTypes, value, values);
            return this;
        }

        public final Builder fieldTypes(Function<RuntimeFieldsType.Builder, ObjectBuilder<RuntimeFieldsType>> fn) {
            return this.fieldTypes(fn.apply(new RuntimeFieldsType.Builder()).build(), new RuntimeFieldsType[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RuntimeFieldTypes build() {
            this._checkSingleUse();
            return new RuntimeFieldTypes(this);
        }
    }
}

