/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.schedule;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.dto.JobTaskBatchReason;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.schedule.AbstractSchedule;
import com.aizuda.snailjob.server.common.triple.Pair;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.JobBatchSummaryResponseDO;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobSummaryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobSummary;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowJobSummarySchedule
extends AbstractSchedule
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(WorkflowJobSummarySchedule.class);
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final JobSummaryMapper jobSummaryMapper;
    private final SystemProperties systemProperties;

    public String lockName() {
        return "workflowJobSummarySchedule";
    }

    public String lockAtMost() {
        return "PT1M";
    }

    public String lockAtLeast() {
        return "PT20S";
    }

    protected void doExecute() {
        try {
            for (int i = 0; i < this.systemProperties.getSummaryDay(); ++i) {
                LocalDateTime todayFrom = LocalDateTime.of(LocalDate.now(), LocalTime.MIN).plusDays(-i);
                LocalDateTime todayTo = LocalDateTime.of(LocalDate.now(), LocalTime.MAX).plusDays(-i);
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().between(WorkflowTaskBatch::getCreateDt, (Object)todayFrom, (Object)todayTo)).groupBy(WorkflowTaskBatch::getNamespaceId, new SFunction[]{WorkflowTaskBatch::getGroupName, WorkflowTaskBatch::getWorkflowId, WorkflowTaskBatch::getTaskBatchStatus, WorkflowTaskBatch::getOperationReason});
                List summaryWorkflowResponseDOList = this.jobTaskBatchMapper.selectWorkflowTaskBatchSummaryList((Wrapper)wrapper);
                if (CollUtil.isEmpty((Collection)summaryWorkflowResponseDOList)) continue;
                List<JobSummary> jobSummaryList = this.jobSummaryList(todayFrom, summaryWorkflowResponseDOList);
                List jobSummaries = this.jobSummaryMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobSummary::getTriggerAt, (Object)todayFrom)).eq(JobSummary::getSystemTaskType, (Object)SyetemTaskTypeEnum.WORKFLOW.getType())).in(JobSummary::getBusinessId, (Collection)StreamUtils.toSet(jobSummaryList, JobSummary::getBusinessId)));
                Map summaryMap = StreamUtils.toIdentityMap((Collection)jobSummaries, jobSummary -> Pair.of((Object)jobSummary.getBusinessId(), (Object)jobSummary.getTriggerAt()));
                ArrayList waitInserts = Lists.newArrayList();
                ArrayList waitUpdates = Lists.newArrayList();
                for (JobSummary jobSummary2 : jobSummaryList) {
                    if (Objects.isNull(summaryMap.get(Pair.of((Object)jobSummary2.getBusinessId(), (Object)jobSummary2.getTriggerAt())))) {
                        waitInserts.add(jobSummary2);
                        continue;
                    }
                    waitUpdates.add(jobSummary2);
                }
                int updateTotalJobSummary = 0;
                if (CollUtil.isNotEmpty((Collection)waitUpdates)) {
                    updateTotalJobSummary = this.jobSummaryMapper.updateBatch((List)waitUpdates);
                }
                int insertTotalJobSummary = 0;
                if (CollUtil.isNotEmpty((Collection)waitInserts)) {
                    insertTotalJobSummary = this.jobSummaryMapper.insertBatch((List)waitInserts);
                }
                SnailJobLog.LOCAL.debug("workflow job summary dashboard success todayFrom:[{}] todayTo:[{}] updateTotalJobSummary:[{}] insertTotalJobSummary:[{}]", new Object[]{todayFrom, todayTo, updateTotalJobSummary, insertTotalJobSummary});
            }
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("workflow job summary dashboard log error", new Object[]{e});
        }
    }

    private List<JobSummary> jobSummaryList(LocalDateTime triggerAt, List<JobBatchSummaryResponseDO> summaryResponseDOList) {
        ArrayList<JobSummary> jobSummaryList = new ArrayList<JobSummary>();
        Map<Long, List<JobBatchSummaryResponseDO>> jobIdListMap = summaryResponseDOList.parallelStream().collect(Collectors.groupingBy(JobBatchSummaryResponseDO::getJobId));
        for (Map.Entry<Long, List<JobBatchSummaryResponseDO>> job : jobIdListMap.entrySet()) {
            JobSummary jobSummary = new JobSummary();
            jobSummary.setBusinessId(job.getKey());
            jobSummary.setTriggerAt(triggerAt);
            jobSummary.setNamespaceId(job.getValue().get(0).getNamespaceId());
            jobSummary.setGroupName(job.getValue().get(0).getGroupName());
            jobSummary.setSystemTaskType(SyetemTaskTypeEnum.WORKFLOW.getType());
            jobSummary.setSuccessNum(Integer.valueOf(job.getValue().stream().mapToInt(JobBatchSummaryResponseDO::getSuccessNum).sum()));
            jobSummary.setFailNum(Integer.valueOf(job.getValue().stream().mapToInt(JobBatchSummaryResponseDO::getFailNum).sum()));
            jobSummary.setStopNum(Integer.valueOf(job.getValue().stream().mapToInt(JobBatchSummaryResponseDO::getStopNum).sum()));
            jobSummary.setCancelNum(Integer.valueOf(job.getValue().stream().mapToInt(JobBatchSummaryResponseDO::getCancelNum).sum()));
            jobSummary.setFailReason(JsonUtil.toJsonString(this.jobTaskBatchReasonList(JobTaskBatchStatusEnum.FAIL.getStatus(), job.getValue())));
            jobSummary.setStopReason(JsonUtil.toJsonString(this.jobTaskBatchReasonList(JobTaskBatchStatusEnum.STOP.getStatus(), job.getValue())));
            jobSummary.setCancelReason(JsonUtil.toJsonString(this.jobTaskBatchReasonList(JobTaskBatchStatusEnum.CANCEL.getStatus(), job.getValue())));
            jobSummaryList.add(jobSummary);
        }
        return jobSummaryList;
    }

    private List<JobTaskBatchReason> jobTaskBatchReasonList(int jobTaskBatchStatus, List<JobBatchSummaryResponseDO> jobBatchSummaryResponseDOList) {
        ArrayList<JobTaskBatchReason> jobTaskBatchReasonArrayList = new ArrayList<JobTaskBatchReason>();
        List summaryResponseDOList = jobBatchSummaryResponseDOList.stream().filter(i -> jobTaskBatchStatus == i.getTaskBatchStatus()).collect(Collectors.toList());
        for (JobBatchSummaryResponseDO jobBatchSummaryResponseDO : summaryResponseDOList) {
            JobTaskBatchReason jobTaskBatchReason = new JobTaskBatchReason();
            jobTaskBatchReason.setReason(jobBatchSummaryResponseDO.getOperationReason());
            jobTaskBatchReason.setTotal(jobBatchSummaryResponseDO.getOperationReasonTotal());
            jobTaskBatchReasonArrayList.add(jobTaskBatchReason);
        }
        return jobTaskBatchReasonArrayList;
    }

    public void start() {
        this.taskScheduler.scheduleAtFixedRate(() -> ((WorkflowJobSummarySchedule)this).execute(), Duration.parse("PT1M"));
    }

    public void close() {
    }

    public WorkflowJobSummarySchedule(JobTaskBatchMapper jobTaskBatchMapper, JobSummaryMapper jobSummaryMapper, SystemProperties systemProperties) {
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.jobSummaryMapper = jobSummaryMapper;
        this.systemProperties = systemProperties;
    }
}

