/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.util;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.exception.SnailJobAuthenticationException;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class UserSessionUtils {
    public static UserSessionVO currentUserSession() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        return (UserSessionVO)request.getAttribute("currentUser");
    }

    public static List<String> getGroupNames(String groupNameQuery) {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        if (userSessionVO.isAdmin()) {
            if (StrUtil.isNotBlank((CharSequence)groupNameQuery)) {
                return Lists.newArrayList((Object[])new String[]{groupNameQuery});
            }
            return Collections.emptyList();
        }
        List<String> groupNames = userSessionVO.getGroupNames();
        Assert.notEmpty(groupNames, () -> new SnailJobAuthenticationException("\u666e\u901a\u7528\u6237\u7ec4\u6743\u9650\u4e3a\u7a7a"));
        if (StrUtil.isNotBlank((CharSequence)groupNameQuery) && groupNames.contains(groupNameQuery)) {
            return Lists.newArrayList((Object[])new String[]{groupNameQuery});
        }
        return groupNames;
    }
}

