/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.ArraySwap;
import com.ql.util.express.InstructionSet;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.OperateData;
import com.ql.util.express.exception.QLException;

public final class RunEnvironment {
    private static int INIT_DATA_LENTH = 15;
    private boolean isTrace = false;
    private int point = -1;
    protected int programPoint = 0;
    private OperateData[] dataContainer;
    private ArraySwap arraySwap = new ArraySwap();
    private boolean isExit = false;
    private Object returnValue = null;
    private InstructionSet instructionSet;
    private InstructionSetContext context;

    public RunEnvironment(InstructionSet aInstructionSet, InstructionSetContext aContext, boolean aIsTrace) {
        this.dataContainer = new OperateData[INIT_DATA_LENTH];
        this.instructionSet = aInstructionSet;
        this.context = aContext;
        this.isTrace = aIsTrace;
    }

    public void initial(InstructionSet aInstructionSet, InstructionSetContext aContext, boolean aIsTrace) {
        this.instructionSet = aInstructionSet;
        this.context = aContext;
        this.isTrace = aIsTrace;
    }

    public void clear() {
        this.isTrace = false;
        this.point = -1;
        this.programPoint = 0;
        this.isExit = false;
        this.returnValue = null;
        this.instructionSet = null;
        this.context = null;
    }

    public InstructionSet getInstructionSet() {
        return this.instructionSet;
    }

    public InstructionSetContext getContext() {
        return this.context;
    }

    public void setContext(InstructionSetContext aContext) {
        this.context = aContext;
    }

    public boolean isExit() {
        return this.isExit;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(Object value) {
        this.returnValue = value;
    }

    public void quitExpress(Object aReturnValue) {
        this.isExit = true;
        this.returnValue = aReturnValue;
    }

    public void quitExpress() {
        this.isExit = true;
        this.returnValue = null;
    }

    public boolean isTrace() {
        return this.isTrace;
    }

    public int getProgramPoint() {
        return this.programPoint;
    }

    public void programPointAddOne() {
        ++this.programPoint;
    }

    public void gotoLastWhenReturn() {
        this.programPoint = this.instructionSet.getInstructionLength();
    }

    public int getDataStackSize() {
        return this.point + 1;
    }

    public void push(OperateData data) {
        ++this.point;
        if (this.point >= this.dataContainer.length) {
            this.ensureCapacity(this.point + 1);
        }
        this.dataContainer[this.point] = data;
    }

    public OperateData peek() {
        if (this.point < 0) {
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u5806\u6808\u6307\u9488\u9519\u8bef");
        }
        return this.dataContainer[this.point];
    }

    public OperateData pop() {
        if (this.point < 0) {
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u5806\u6808\u6307\u9488\u9519\u8bef");
        }
        OperateData result = this.dataContainer[this.point];
        --this.point;
        return result;
    }

    public void clearDataStack() {
        this.point = -1;
    }

    public void gotoWithOffset(int aOffset) {
        this.programPoint += aOffset;
    }

    public ArraySwap popArray(InstructionSetContext context, int len) throws Exception {
        int start = this.point - len + 1;
        this.arraySwap.swap(this.dataContainer, start, len);
        this.point -= len;
        return this.arraySwap;
    }

    public OperateData[] popArrayOld(InstructionSetContext context, int len) throws Exception {
        int start = this.point - len + 1;
        OperateData[] result = new OperateData[len];
        System.arraycopy(this.dataContainer, start, result, 0, len);
        this.point -= len;
        return result;
    }

    public OperateData[] popArrayBackUp(InstructionSetContext context, int len) throws Exception {
        int start = this.point - len + 1;
        if (start < 0) {
            throw new QLException("\u5806\u6808\u6ea2\u51fa\uff0c\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u662f\u5426\u9519\u8bef");
        }
        OperateData[] result = new OperateData[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.dataContainer[start + i];
            if (!Void.TYPE.equals(result[i].getType(context))) continue;
            throw new QLException("void \u4e0d\u80fd\u53c2\u4e0e\u4efb\u4f55\u64cd\u4f5c\u8fd0\u7b97,\u8bf7\u68c0\u67e5\u4f7f\u7528\u5728\u8868\u8fbe\u5f0f\u4e2d\u4f7f\u7528\u4e86\u6ca1\u6709\u8fd4\u56de\u503c\u7684\u51fd\u6570,\u6216\u8005\u5206\u652f\u4e0d\u5b8c\u6574\u7684if\u8bed\u53e5");
        }
        this.point -= len;
        return result;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.dataContainer.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            OperateData[] tempList = new OperateData[newCapacity];
            System.arraycopy(this.dataContainer, 0, tempList, 0, oldCapacity);
            this.dataContainer = tempList;
        }
    }
}

