/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.match;

import com.ql.util.express.exception.QLCompileException;
import com.ql.util.express.match.INodeType;
import com.ql.util.express.match.INodeTypeManager;
import com.ql.util.express.match.MatchMode;
import com.ql.util.express.match.QLPattern;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QLPatternNode {
    private static final Log log = LogFactory.getLog(QLPatternNode.class);
    INodeTypeManager nodeTypeManager;
    String name;
    String orgiContent;
    MatchMode matchMode = MatchMode.NULL;
    boolean isChildMode = false;
    int level = 0;
    protected boolean isTreeRoot = false;
    protected int minMatchNum = 1;
    protected int maxMatchNum = 1;
    protected INodeType nodeType;
    protected INodeType targetNodeType;
    protected INodeType rootNodeType;
    protected boolean isSkip = false;
    protected boolean blame = false;
    List<QLPatternNode> children = new ArrayList<QLPatternNode>();

    public boolean canMergeDetail() {
        return QLPattern.optimizeStackDepth && this.matchMode == MatchMode.DETAIL && this.name.equals("ANONY_PATTERN") && this.nodeType.getPatternNode() != null && !this.isSkip && !this.blame && !this.isChildMode && !this.isTreeRoot && this.minMatchNum == 1 && this.maxMatchNum == 1;
    }

    protected QLPatternNode(INodeTypeManager aManager, String aName, String aOrgiContent) throws Exception {
        this(aManager, aName, aOrgiContent, false, 1);
    }

    protected QLPatternNode(INodeTypeManager aManager, String aName, String aOrgiContent, boolean aIsChildMode, int aLevel) throws Exception {
        this.nodeTypeManager = aManager;
        this.name = aName;
        this.orgiContent = aOrgiContent;
        this.isChildMode = aIsChildMode;
        this.level = aLevel;
        this.splitChild();
        for (int i = 0; i < this.children.size(); ++i) {
            QLPatternNode t = this.children.get(i);
            if (!t.canMergeDetail()) continue;
            this.children.set(i, t.getNodeType().getPatternNode());
            if (t.getNodeType().getPatternNode().getNodeType() != null) continue;
            t.getNodeType().getPatternNode().nodeType = t.getNodeType();
        }
    }

    public void splitChild() throws Exception {
        int index;
        String orgStr;
        if (log.isTraceEnabled()) {
            String str = "";
            for (int i = 0; i < this.level; ++i) {
                str = str + "  ";
            }
        }
        if ((orgStr = this.orgiContent).equals("(") || orgStr.equals(")") || orgStr.equals("|") || orgStr.equals("||") || orgStr.equals("/**") || orgStr.equals("**/") || orgStr.equals("*")) {
            this.matchMode = MatchMode.DETAIL;
            this.nodeType = this.nodeTypeManager.findNodeType(orgStr);
            return;
        }
        String tempStr = "";
        int count = 0;
        for (int i = 0; i < orgStr.length(); ++i) {
            if (orgStr.charAt(i) == '(') {
                tempStr = tempStr + orgStr.charAt(i);
                ++count;
                continue;
            }
            if (orgStr.charAt(i) == ')') {
                tempStr = tempStr + orgStr.charAt(i);
                --count;
                continue;
            }
            if (count > 0) {
                tempStr = tempStr + orgStr.charAt(i);
                continue;
            }
            if (orgStr.charAt(i) == '$') {
                if (this.matchMode != MatchMode.NULL && this.matchMode != MatchMode.AND) {
                    throw new QLCompileException("\u4e0d\u6b63\u786e\u7684\u6a21\u5f0f\u4e32,\u5728\u4e00\u4e2a\u5339\u914d\u6a21\u5f0f\u4e2d\u4e0d\u80fd|,$\u5e76\u5b58,\u8bf7\u4f7f\u7528\u5b57\u4e32\u6a21\u5f0f:" + orgStr);
                }
                this.children.add(new QLPatternNode(this.nodeTypeManager, "ANONY_PATTERN", tempStr, false, this.level + 1));
                this.matchMode = MatchMode.AND;
                tempStr = "";
                continue;
            }
            if (orgStr.charAt(i) == '|') {
                if (this.matchMode != MatchMode.NULL && this.matchMode != MatchMode.OR) {
                    throw new QLCompileException("\u4e0d\u6b63\u786e\u7684\u6a21\u5f0f\u4e32,\u5728\u4e00\u4e2a\u5339\u914d\u6a21\u5f0f\u4e2d\u4e0d\u80fd|,$\u5e76\u5b58,\u8bf7\u4f7f\u7528\u5b57\u4e32\u6a21\u5f0f:" + orgStr);
                }
                this.children.add(new QLPatternNode(this.nodeTypeManager, "ANONY_PATTERN", tempStr, false, this.level + 1));
                this.matchMode = MatchMode.OR;
                tempStr = "";
                continue;
            }
            if (orgStr.charAt(i) == '#') {
                this.rootNodeType = this.nodeTypeManager.findNodeType(orgStr.substring(i + 1));
                break;
            }
            tempStr = tempStr + orgStr.charAt(i);
        }
        if (count > 0) {
            throw new QLCompileException("\u4e0d\u6b63\u786e\u7684\u6a21\u5f0f\u4e32,(\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684):" + orgStr);
        }
        if (this.children.size() > 0) {
            this.children.add(new QLPatternNode(this.nodeTypeManager, "ANONY_PATTERN", tempStr, false, this.level + 1));
            tempStr = "";
        }
        if (tempStr.endsWith("*") && tempStr.length() > 1) {
            this.minMatchNum = 0;
            this.maxMatchNum = Integer.MAX_VALUE;
            tempStr = tempStr.substring(0, tempStr.length() - 1);
        }
        if (tempStr.endsWith("}") && (index = tempStr.lastIndexOf("{")) > 0) {
            String numStr = tempStr.substring(index + 1, tempStr.length() - 1);
            int index2 = numStr.indexOf(58);
            if (index2 > 0) {
                this.minMatchNum = Integer.parseInt(numStr.substring(0, index2));
                this.maxMatchNum = Integer.parseInt(numStr.substring(index2 + 1));
            } else {
                this.minMatchNum = Integer.parseInt(numStr);
                this.maxMatchNum = Integer.parseInt(numStr);
            }
            tempStr = tempStr.substring(0, index);
        }
        if (tempStr.endsWith("^") && tempStr.length() > 1) {
            this.isTreeRoot = true;
            tempStr = tempStr.substring(0, tempStr.length() - 1);
        }
        if (tempStr.endsWith("~") && tempStr.length() > 1) {
            this.isSkip = true;
            tempStr = tempStr.substring(0, tempStr.length() - 1);
        }
        if (tempStr.endsWith("@") && tempStr.length() > 1) {
            this.blame = true;
            tempStr = tempStr.substring(0, tempStr.length() - 1);
        }
        if (tempStr.length() > 2 && tempStr.charAt(0) == '(' && tempStr.charAt(tempStr.length() - 1) == ')') {
            this.isChildMode = true;
            this.children.add(new QLPatternNode(this.nodeTypeManager, "ANONY_PATTERN", tempStr.substring(1, tempStr.length() - 1), false, this.level + 1));
            this.matchMode = MatchMode.AND;
            tempStr = "";
        }
        if ((index = tempStr.indexOf("->")) > 0) {
            this.targetNodeType = this.nodeTypeManager.findNodeType(tempStr.substring(index + 2));
            tempStr = tempStr.substring(0, index);
        }
        if (tempStr.length() > 0) {
            this.matchMode = MatchMode.DETAIL;
            this.nodeType = this.nodeTypeManager.findNodeType(tempStr);
        }
    }

    public List<QLPatternNode> getChildren() {
        return this.children;
    }

    public INodeType getNodeType() {
        return this.nodeType;
    }

    public boolean isDetailMode() {
        return this.matchMode == MatchMode.DETAIL;
    }

    public boolean isAndMode() {
        return this.matchMode == MatchMode.AND;
    }

    public String toString() {
        String result = "";
        result = this.matchMode == MatchMode.AND ? this.joinStringList(this.children, "$") : (this.matchMode == MatchMode.OR ? this.joinStringList(this.children, "|") : this.nodeType.getName());
        if (this.targetNodeType != null) {
            result = result + "->" + this.targetNodeType.getName();
        }
        if (this.isChildMode) {
            result = "(" + result + ")";
        }
        if (this.isSkip) {
            result = result + '~';
        }
        if (this.blame) {
            result = result + '@';
        }
        if (this.isTreeRoot) {
            result = result + '^';
        }
        if (this.minMatchNum == 0 && this.maxMatchNum == Integer.MAX_VALUE) {
            result = result + '*';
        } else if (this.minMatchNum == this.maxMatchNum && this.maxMatchNum > 1) {
            result = result + "{" + this.maxMatchNum + "}";
        } else if (this.minMatchNum != this.maxMatchNum) {
            result = result + "{" + this.minMatchNum + ":" + this.maxMatchNum + "}";
        }
        if (this.rootNodeType != null) {
            result = result + '#' + this.rootNodeType.getName();
        }
        return result;
    }

    public String joinStringList(List<QLPatternNode> list, String splitChar) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                buffer.append(splitChar);
            }
            buffer.append(list.get(i));
        }
        return buffer.toString();
    }
}

