/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.annotation;

import com.ql.util.express.ExpressUtil;
import com.ql.util.express.annotation.QLAlias;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.PropertyUtils;

public class QLAliasUtils {
    private static final QLAliasUtils instance = new QLAliasUtils();
    public static Map<String, Object> fieldsCache = new ConcurrentHashMap<String, Object>();

    protected static QLAliasUtils getInstance() {
        return instance;
    }

    public static Class<?> getPropertyClass(Object bean, String name) {
        Field f = QLAliasUtils.findQLAliasFieldsWithCache(bean.getClass(), name);
        if (f != null) {
            name = f.getName();
        }
        try {
            return PropertyUtils.getPropertyDescriptor((Object)bean, (String)name).getPropertyType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getProperty(Object bean, String name) {
        try {
            Field f = QLAliasUtils.findQLAliasFieldsWithCache(bean.getClass(), name);
            if (f != null) {
                name = f.getName();
            }
            return PropertyUtils.getProperty((Object)bean, (String)name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setProperty(Object bean, Object name, Object value) {
        try {
            Field f = QLAliasUtils.findQLAliasFieldsWithCache(bean.getClass(), name.toString());
            if (f != null) {
                name = f.getName();
            }
            Class filedClass = PropertyUtils.getPropertyType((Object)bean, (String)name.toString());
            PropertyUtils.setProperty((Object)bean, (String)name.toString(), (Object)ExpressUtil.castObject(value, filedClass, false));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Field findQLAliasFieldsWithCache(Class baseClass, String propertyName) {
        String key = baseClass + "#" + propertyName;
        Object result = fieldsCache.get(key);
        if (result == null) {
            result = QLAliasUtils.findQLAliasFields(baseClass, propertyName);
            if (result == null) {
                fieldsCache.put(key, Void.TYPE);
            } else {
                fieldsCache.put(key, result);
            }
        } else if (result == Void.TYPE) {
            result = null;
        }
        return (Field)result;
    }

    public static Field findQLAliasFields(Class baseClass, String propertyName) {
        Field f;
        Field[] fields;
        for (Field f2 : fields = baseClass.getDeclaredFields()) {
            if (propertyName.equals(f2.getName())) {
                return f2;
            }
            QLAlias[] qlAliases = (QLAlias[])f2.getAnnotationsByType(QLAlias.class);
            if (qlAliases == null) continue;
            for (QLAlias alias : qlAliases) {
                if (alias.value().length <= 0) continue;
                for (int i = 0; i < alias.value().length; ++i) {
                    if (!propertyName.equals(alias.value()[i])) continue;
                    return f2;
                }
            }
        }
        Class superclass = baseClass.getSuperclass();
        if (superclass != null && (f = QLAliasUtils.findQLAliasFields(superclass, propertyName)) != null) {
            return f;
        }
        return null;
    }
}

