/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.match;

import com.ql.util.express.exception.QLCompileException;
import com.ql.util.express.match.IDataNode;
import com.ql.util.express.match.INodeType;
import com.ql.util.express.match.INodeTypeManager;
import com.ql.util.express.match.MatchMode;
import com.ql.util.express.match.QLMatchResult;
import com.ql.util.express.match.QLMatchResultTree;
import com.ql.util.express.match.QLPatternNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QLPattern {
    private static final Log log = LogFactory.getLog(QLPattern.class);
    public static boolean optimizeStackDepth = true;
    public static boolean printStackDepth = false;

    public static QLPatternNode createPattern(INodeTypeManager nodeTypeManager, String name, String pattern) throws Exception {
        return new QLPatternNode(nodeTypeManager, name, pattern);
    }

    public static QLMatchResult findMatchStatement(INodeTypeManager aManager, QLPatternNode pattern, List<? extends IDataNode> nodes, int point) throws Exception {
        AtomicLong maxMatchPoint = new AtomicLong();
        AtomicLong maxDeep = new AtomicLong(1L);
        QLMatchResultCache resultCache = new QLMatchResultCache(5);
        ArrayListCache arrayListCache = new ArrayListCache(50);
        MatchParamsPack staticParams = new MatchParamsPack(aManager, nodes, maxDeep, maxMatchPoint, resultCache, arrayListCache);
        QLMatchResult result = QLPattern.findMatchStatementWithAddRootOptimizeStack(staticParams, pattern, point, true, 1);
        if (printStackDepth) {
            log.warn((Object)("\u9012\u5f52\u5806\u6808\u6df1\u5ea6:" + maxDeep.longValue() + "  \u91cd\u7528QLMatchResult\u6b21\u6570:" + resultCache.fetchCount + "  \u65b0\u5efaQLMatchResult\u6b21\u6570:" + resultCache.newCount + "  \u65b0\u5efaArrayList\u6570\u91cf:" + arrayListCache.newCount));
        }
        if (result == null || result.getMatchSize() == 0) {
            throw new QLCompileException("\u7a0b\u5e8f\u9519\u8bef\uff0c\u4e0d\u6ee1\u8db3\u8bed\u6cd5\u89c4\u8303\uff0c\u6ca1\u6709\u5339\u914d\u5230\u5408\u9002\u7684\u8bed\u6cd5,\u6700\u5927\u5339\u914d\u81f4[0:" + (maxMatchPoint.longValue() - 1L) + "]");
        }
        if (result != null && result.getMatchSize() != 1) {
            throw new QLCompileException("\u7a0b\u5e8f\u9519\u8bef\uff0c\u4e0d\u6ee1\u8db3\u8bed\u6cd5\u89c4\u8303\uff0c\u5fc5\u987b\u6709\u4e00\u4e2a\u6839\u8282\u70b9\uff1a" + pattern + ",\u6700\u5927\u5339\u914d\u81f4[0:" + (maxMatchPoint.longValue() - 1L) + "]");
        }
        return result;
    }

    private static QLMatchResult findMatchStatementWithAddRootOptimizeStack(MatchParamsPack staticParams, QLPatternNode pattern, int point, boolean isRoot, int deep) throws Exception {
        List<QLMatchResultTree> tempList;
        QLMatchResult result;
        List<? extends IDataNode> nodes;
        block59: {
            INodeTypeManager aManager = staticParams.aManager;
            nodes = staticParams.nodes;
            AtomicLong maxMatchPoint = staticParams.maxMatchPoint;
            AtomicLong maxDeep = staticParams.maxDeep;
            if ((long)(++deep) > maxDeep.longValue()) {
                maxDeep.set(deep);
            }
            result = null;
            tempList = null;
            int count = 0;
            int lastPoint = point;
            do {
                QLMatchResult tempResult = null;
                if (pattern.matchMode == MatchMode.DETAIL) {
                    int pointDetail = lastPoint;
                    QLMatchResult resultDetail = null;
                    if (pattern.nodeType == aManager.findNodeType("EOF") && pointDetail == nodes.size()) {
                        resultDetail = staticParams.resultCache.fetch().setMatchLastIndex(pointDetail + 1);
                    } else if (pattern.nodeType == aManager.findNodeType("EOF") && pointDetail < nodes.size() && nodes.get(pointDetail).getValue().equals("}")) {
                        resultDetail = staticParams.resultCache.fetch().setMatchLastIndex(pointDetail);
                    } else if (pointDetail == nodes.size() && pattern.nodeType.getPatternNode() != null) {
                        resultDetail = QLPattern.findMatchStatementWithAddRootOptimizeStack(staticParams, pattern.nodeType.getPatternNode(), pointDetail, false, deep);
                    } else if (pointDetail < nodes.size()) {
                        INodeType tempNodeType = null;
                        if (pattern.nodeType.equals(nodes.get(pointDetail).getTreeType())) {
                            tempNodeType = nodes.get(pointDetail).getTreeType();
                        } else if (pattern.nodeType.equals(nodes.get(pointDetail).getNodeType())) {
                            tempNodeType = nodes.get(pointDetail).getNodeType();
                        }
                        if (tempNodeType != null) {
                            resultDetail = staticParams.resultCache.fetch();
                            resultDetail.addQLMatchResultTree(new QLMatchResultTree(tempNodeType, nodes.get(pointDetail), pattern.targetNodeType));
                            resultDetail.setMatchLastIndex(++pointDetail);
                            QLPattern.traceLog(pattern, resultDetail, nodes, pointDetail - 1, 1);
                        } else if (pattern.nodeType.getPatternNode() != null) {
                            resultDetail = QLPattern.findMatchStatementWithAddRootOptimizeStack(staticParams, pattern.nodeType.getPatternNode(), pointDetail, false, deep);
                            if (pattern.targetNodeType != null && resultDetail != null && resultDetail.getMatchSize() > 0) {
                                if (resultDetail.getMatchSize() > 1) {
                                    throw new QLCompileException("\u8bbe\u7f6e\u4e86\u7c7b\u578b\u8f6c\u6362\u7684\u8bed\u6cd5\uff0c\u53ea\u80fd\u6709\u4e00\u4e2a\u6839\u8282\u70b9");
                                }
                                resultDetail.getMatchs().get((int)0).targetNodeType = pattern.targetNodeType;
                            }
                        }
                        if (pattern.blame) {
                            if (resultDetail == null) {
                                resultDetail = staticParams.resultCache.fetch();
                                resultDetail.addQLMatchResultTree(new QLMatchResultTree(tempNodeType, nodes.get(pointDetail), null));
                                resultDetail.setMatchLastIndex(++pointDetail);
                            } else {
                                resultDetail = null;
                            }
                        }
                    }
                    if (resultDetail != null && (long)resultDetail.getMatchLastIndex() > maxMatchPoint.longValue()) {
                        maxMatchPoint.set(resultDetail.getMatchLastIndex());
                    }
                    tempResult = resultDetail;
                } else if (pattern.matchMode == MatchMode.AND) {
                    int orgiPoint = lastPoint;
                    int pointAnd = lastPoint;
                    QLMatchResultTree root = null;
                    int matchCount = 0;
                    List<QLMatchResultTree> tempListAnd = null;
                    boolean isBreak = false;
                    for (QLPatternNode item : pattern.children) {
                        if (pointAnd > nodes.size()) {
                            isBreak = true;
                            break;
                        }
                        QLMatchResult tempResultAnd = QLPattern.findMatchStatementWithAddRootOptimizeStack(staticParams, item, pointAnd, false, deep);
                        if (tempResultAnd != null) {
                            if (tempResultAnd.getMatchSize() > 0) {
                                ++matchCount;
                            }
                            if (tempListAnd == null) {
                                tempListAnd = staticParams.arrayListCache.fetch();
                            }
                            pointAnd = tempResultAnd.getMatchLastIndex();
                            if (item.isTreeRoot && tempResultAnd.getMatchSize() > 0) {
                                if (tempResultAnd.getMatchSize() > 1) {
                                    throw new QLCompileException("\u6839\u8282\u70b9\u7684\u6570\u91cf\u5fc5\u987b\u662f1");
                                }
                                if (root == null) {
                                    QLMatchResultTree tempTree = tempResultAnd.getMatchs().get(0);
                                    while (tempTree.getLeft() != null && tempTree.getLeft().size() > 0) {
                                        tempTree = tempTree.getLeft().get(0);
                                    }
                                    tempTree.addLeftAll(tempListAnd);
                                    tempListAnd.clear();
                                } else {
                                    tempResultAnd.getMatchs().get(0).addLeft(root);
                                }
                                root = tempResultAnd.getMatchs().get(0);
                            } else if (root != null) {
                                root.addRightAll(tempResultAnd.getMatchs());
                            } else {
                                tempListAnd.addAll(tempResultAnd.getMatchs());
                            }
                            if (tempResultAnd == null) continue;
                            staticParams.resultCache.sendBack(tempResultAnd);
                            tempResultAnd = null;
                            continue;
                        }
                        isBreak = true;
                        break;
                    }
                    if (root != null) {
                        tempListAnd.add(root);
                    }
                    if (!isBreak) {
                        tempResult = staticParams.resultCache.fetch().addQLMatchResultTreeList(tempListAnd);
                        tempResult.setMatchLastIndex(pointAnd);
                        QLPattern.traceLog(pattern, tempResult, nodes, orgiPoint, matchCount);
                    } else {
                        tempResult = null;
                    }
                    if (tempListAnd != null) {
                        staticParams.arrayListCache.sendBack(tempListAnd);
                    }
                } else if (pattern.matchMode == MatchMode.OR) {
                    QLPatternNode item;
                    Iterator<QLPatternNode> iterator = pattern.children.iterator();
                    while (iterator.hasNext() && (tempResult = QLPattern.findMatchStatementWithAddRootOptimizeStack(staticParams, item = iterator.next(), lastPoint, false, deep)) == null) {
                    }
                } else {
                    throw new QLCompileException("\u4e0d\u6b63\u786e\u7684\u7c7b\u578b\uff1a" + pattern.matchMode.toString());
                }
                if (tempResult == null) {
                    if (count >= pattern.minMatchNum && count <= pattern.maxMatchNum) {
                        result = staticParams.resultCache.fetch();
                        if (tempList != null) {
                            result.addQLMatchResultTreeList(tempList);
                        }
                        result.setMatchLastIndex(lastPoint);
                    } else {
                        result = null;
                    }
                    break block59;
                }
                if (tempList == null) {
                    tempList = staticParams.arrayListCache.fetch();
                }
                lastPoint = tempResult.getMatchLastIndex();
                if (pattern.isTreeRoot) {
                    if (tempResult.getMatchSize() > 1) {
                        throw new QLCompileException("\u6839\u8282\u70b9\u7684\u6570\u91cf\u5fc5\u987b\u662f1");
                    }
                    if (tempList.size() == 0) {
                        tempList.addAll(tempResult.getMatchs());
                    } else {
                        tempResult.getMatchs().get(0).addLeftAll(tempList);
                        tempList = staticParams.arrayListCache.fetch();
                        tempList.addAll(tempResult.getMatchs());
                    }
                } else {
                    tempList.addAll(tempResult.getMatchs());
                }
                if (tempResult == null) continue;
                staticParams.resultCache.sendBack(tempResult);
                tempResult = null;
            } while (++count != pattern.maxMatchNum);
            result = staticParams.resultCache.fetch();
            if (tempList != null) {
                result.addQLMatchResultTreeList(tempList);
            }
            result.setMatchLastIndex(lastPoint);
        }
        if (result != null && pattern.isSkip) {
            result.getMatchs().clear();
        }
        if (result != null && result.getMatchSize() > 0 && pattern.rootNodeType != null) {
            QLMatchResultTree tempTree = new QLMatchResultTree(pattern.rootNodeType, nodes.get(0).createExpressNode(pattern.rootNodeType, null));
            tempTree.addLeftAll(result.getMatchs());
            result.getMatchs().clear();
            result.getMatchs().add(tempTree);
        }
        if (tempList != null) {
            staticParams.arrayListCache.sendBack(tempList);
        }
        return result;
    }

    public static void traceLog(QLPatternNode pattern, QLMatchResult result, List<? extends IDataNode> nodes, int point, int matchCount) {
        if (log.isTraceEnabled() && (pattern.matchMode == MatchMode.DETAIL || pattern.matchMode == MatchMode.AND && matchCount > 1 && !pattern.name.equals("ANONY_PATTERN"))) {
            log.trace((Object)("\u5339\u914d--" + pattern.name + "[" + point + ":" + (result.getMatchLastIndex() - 1) + "]:" + pattern));
        }
    }

    public static class ArrayListCache<T> {
        public int newCount = 0;
        public int fetchCount = 0;
        private List<T>[] cache;
        private int len = 50;
        private int point = 49;

        public ArrayListCache(int aLen) {
            this.len = aLen;
            this.point = this.len - 1;
            this.cache = new List[this.len];
            for (int i = 0; i < this.len; ++i) {
                this.cache[i] = new ArrayList<T>();
            }
        }

        public List<T> fetch() {
            List<Object> result = null;
            if (this.point >= 0) {
                result = this.cache[this.point];
                this.cache[this.point] = null;
                --this.point;
                ++this.fetchCount;
            } else {
                result = new ArrayList();
                ++this.newCount;
            }
            return result;
        }

        public void sendBack(List<T> result) {
            if (this.point < this.len - 1) {
                ++this.point;
                this.cache[this.point] = result;
                this.cache[this.point].clear();
            }
        }
    }

    public static class QLMatchResultCache {
        public int newCount = 0;
        public int fetchCount = 0;
        private QLMatchResult[] cache;
        private int len = 10;
        private int point = 9;

        public QLMatchResultCache(int aLen) {
            this.len = aLen;
            this.point = this.len - 1;
            this.cache = new QLMatchResult[this.len];
            for (int i = 0; i < this.len; ++i) {
                this.cache[i] = new QLMatchResult();
            }
        }

        public QLMatchResult fetch() {
            QLMatchResult result = null;
            if (this.point >= 0) {
                result = this.cache[this.point];
                this.cache[this.point] = null;
                --this.point;
                ++this.fetchCount;
            } else {
                result = new QLMatchResult();
                ++this.newCount;
            }
            return result;
        }

        public void sendBack(QLMatchResult result) {
            if (this.point < this.len - 1) {
                ++this.point;
                this.cache[this.point] = result;
                this.cache[this.point].clear();
            }
        }
    }

    public static class MatchParamsPack {
        INodeTypeManager aManager;
        List<? extends IDataNode> nodes;
        AtomicLong maxDeep;
        AtomicLong maxMatchPoint;
        QLMatchResultCache resultCache;
        ArrayListCache arrayListCache;

        public MatchParamsPack(INodeTypeManager aManager, List<? extends IDataNode> nodes, AtomicLong maxDeep, AtomicLong maxMatchPoint, QLMatchResultCache aResultCache, ArrayListCache aArrayListCache) {
            this.aManager = aManager;
            this.nodes = nodes;
            this.maxDeep = maxDeep;
            this.maxMatchPoint = maxMatchPoint;
            this.resultCache = aResultCache;
            this.arrayListCache = aArrayListCache;
        }
    }
}

