/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.parse;

import com.ql.util.express.ExpressUtil;
import com.ql.util.express.IExpressResourceLoader;
import com.ql.util.express.exception.QLCompileException;
import com.ql.util.express.match.QLMatchResult;
import com.ql.util.express.match.QLPattern;
import com.ql.util.express.parse.ExpressNode;
import com.ql.util.express.parse.ExpressPackage;
import com.ql.util.express.parse.NodeType;
import com.ql.util.express.parse.NodeTypeKind;
import com.ql.util.express.parse.NodeTypeManager;
import com.ql.util.express.parse.Word;
import com.ql.util.express.parse.WordSplit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpressParse {
    private static final Log log = LogFactory.getLog(ExpressParse.class);
    NodeTypeManager nodeTypeManager;
    IExpressResourceLoader expressResourceLoader;
    private boolean ignoreConstChar = false;
    private boolean isPrecise = false;

    public boolean isIgnoreConstChar() {
        return this.ignoreConstChar;
    }

    public void setIgnoreConstChar(boolean ignoreConstChar) {
        this.ignoreConstChar = ignoreConstChar;
    }

    public ExpressParse(NodeTypeManager aNodeTypeManager, IExpressResourceLoader aLoader, boolean aIsPrecise) {
        this.nodeTypeManager = aNodeTypeManager;
        this.expressResourceLoader = aLoader;
        this.isPrecise = aIsPrecise;
    }

    protected Word[] getExpressByName(String expressFileName) throws Exception {
        String express = this.expressResourceLoader.loadExpress(expressFileName);
        return WordSplit.parse(this.nodeTypeManager.splitWord, express);
    }

    protected Word[] dealInclude(Word[] wordObjects) throws Exception {
        boolean isInclude = false;
        StringBuffer includeFileName = new StringBuffer();
        ArrayList<Word> result = new ArrayList<Word>();
        for (int point = 0; point < wordObjects.length; ++point) {
            if (wordObjects[point].word.equals("include")) {
                isInclude = true;
                includeFileName.setLength(0);
                continue;
            }
            if (isInclude && wordObjects[point].word.equals(";")) {
                isInclude = false;
                Word[] childExpressWord = this.getExpressByName(includeFileName.toString());
                childExpressWord = this.dealInclude(childExpressWord);
                for (int i = 0; i < childExpressWord.length; ++i) {
                    result.add(childExpressWord[i]);
                }
                continue;
            }
            if (isInclude) {
                includeFileName.append(wordObjects[point].word);
                continue;
            }
            result.add(wordObjects[point]);
        }
        return result.toArray(new Word[0]);
    }

    public List<ExpressNode> transferWord2ExpressNode(ExpressPackage aRootExpressPackage, Word[] wordObjects, Map<String, String> selfClassDefine, boolean dealJavaClass) throws Exception {
        int point;
        ArrayList<ExpressNode> result = new ArrayList<ExpressNode>();
        ExpressPackage tmpImportPackage = null;
        if (dealJavaClass) {
            tmpImportPackage = new ExpressPackage(aRootExpressPackage);
            boolean isImport = false;
            StringBuffer importName = new StringBuffer();
            for (point = 0; point < wordObjects.length; ++point) {
                if (wordObjects[point].word.equals("import")) {
                    isImport = true;
                    importName.setLength(0);
                    continue;
                }
                if (wordObjects[point].word.equals(";")) {
                    isImport = false;
                    tmpImportPackage.addPackage(importName.toString());
                    continue;
                }
                if (!isImport) break;
                importName.append(wordObjects[point].word);
            }
        }
        String orgiValue = null;
        Object objectValue = null;
        NodeType treeNodeType = null;
        Word tmpWordObject = null;
        while (point < wordObjects.length) {
            NodeType tempType;
            tmpWordObject = wordObjects[point];
            String tempWord = wordObjects[point].word;
            char firstChar = tempWord.charAt(0);
            char lastChar = tempWord.substring(tempWord.length() - 1).toLowerCase().charAt(0);
            if (firstChar >= '0' && firstChar <= '9') {
                if (result.size() > 0 && ((ExpressNode)result.get(result.size() - 1)).getValue().equals("-") && (result.size() == 1 || result.size() >= 2 && (((ExpressNode)result.get(result.size() - 2)).isTypeEqualsOrChild("OP_LIST") || ((ExpressNode)result.get(result.size() - 2)).isTypeEqualsOrChild(",") || ((ExpressNode)result.get(result.size() - 2)).isTypeEqualsOrChild("return") || ((ExpressNode)result.get(result.size() - 2)).isTypeEqualsOrChild("?") || ((ExpressNode)result.get(result.size() - 2)).isTypeEqualsOrChild(":")) && !((ExpressNode)result.get(result.size() - 2)).isTypeEqualsOrChild(")") && !((ExpressNode)result.get(result.size() - 2)).isTypeEqualsOrChild("]"))) {
                    result.remove(result.size() - 1);
                    tempWord = "-" + tempWord;
                }
                if (lastChar == 'd') {
                    tempType = this.nodeTypeManager.findNodeType("CONST_DOUBLE");
                    tempWord = tempWord.substring(0, tempWord.length() - 1);
                    objectValue = this.isPrecise ? new BigDecimal(tempWord) : Double.valueOf(tempWord);
                } else if (lastChar == 'f') {
                    tempType = this.nodeTypeManager.findNodeType("CONST_FLOAT");
                    tempWord = tempWord.substring(0, tempWord.length() - 1);
                    objectValue = this.isPrecise ? new BigDecimal(tempWord) : Float.valueOf(tempWord);
                } else if (tempWord.indexOf(".") >= 0) {
                    tempType = this.nodeTypeManager.findNodeType("CONST_DOUBLE");
                    objectValue = this.isPrecise ? new BigDecimal(tempWord) : Double.valueOf(tempWord);
                } else if (lastChar == 'l') {
                    tempType = this.nodeTypeManager.findNodeType("CONST_LONG");
                    tempWord = tempWord.substring(0, tempWord.length() - 1);
                    objectValue = Long.valueOf(tempWord);
                } else {
                    long tempLong = Long.parseLong(tempWord);
                    if (tempLong <= Integer.MAX_VALUE && tempLong >= Integer.MIN_VALUE) {
                        tempType = this.nodeTypeManager.findNodeType("CONST_INTEGER");
                        objectValue = (int)tempLong;
                    } else {
                        tempType = this.nodeTypeManager.findNodeType("CONST_LONG");
                        objectValue = tempLong;
                    }
                }
                treeNodeType = this.nodeTypeManager.findNodeType("CONST");
                ++point;
            } else if (firstChar == '\"') {
                if (lastChar != '\"' || tempWord.length() < 2) {
                    throw new QLCompileException("\u6ca1\u6709\u5173\u95ed\u7684\u5b57\u7b26\u4e32\uff1a" + tempWord);
                }
                tempWord = tempWord.substring(1, tempWord.length() - 1);
                tempType = this.nodeTypeManager.findNodeType("CONST_STRING");
                objectValue = tempWord;
                treeNodeType = this.nodeTypeManager.findNodeType("CONST");
                ++point;
            } else if (firstChar == '\'') {
                if (lastChar != '\'' || tempWord.length() < 2) {
                    throw new QLCompileException("\u6ca1\u6709\u5173\u95ed\u7684\u5b57\u7b26\uff1a" + tempWord);
                }
                tempWord = tempWord.substring(1, tempWord.length() - 1);
                treeNodeType = this.nodeTypeManager.findNodeType("CONST");
                if (tempWord.length() == 1 && !this.ignoreConstChar) {
                    tempType = this.nodeTypeManager.findNodeType("CONST_CHAR");
                    objectValue = Character.valueOf(tempWord.charAt(0));
                } else {
                    tempType = this.nodeTypeManager.findNodeType("CONST_STRING");
                    objectValue = tempWord;
                }
                ++point;
            } else if (tempWord.equals("true") || tempWord.equals("false")) {
                tempType = this.nodeTypeManager.findNodeType("CONST_BOOLEAN");
                treeNodeType = this.nodeTypeManager.findNodeType("CONST");
                objectValue = Boolean.valueOf(tempWord);
                ++point;
            } else {
                tempType = this.nodeTypeManager.isExistNodeTypeDefine(tempWord);
                if (tempType != null && tempType.getKind() != NodeTypeKind.KEYWORD) {
                    tempType = null;
                }
                if (tempType == null) {
                    boolean isClass = false;
                    String tmpStr = "";
                    Class<?> tmpClass = null;
                    if (dealJavaClass) {
                        for (int j = point; j < wordObjects.length; j += 2) {
                            tmpClass = tmpImportPackage.getClass(tmpStr = tmpStr + wordObjects[j].word);
                            if (tmpClass != null) {
                                point = j + 1;
                                isClass = true;
                                break;
                            }
                            if (j >= wordObjects.length - 1 || !wordObjects[j + 1].word.equals(".")) break;
                            tmpStr = tmpStr + wordObjects[j + 1].word;
                        }
                    }
                    if (isClass) {
                        tempWord = ExpressUtil.getClassName(tmpClass);
                        orgiValue = tmpStr;
                        tempType = this.nodeTypeManager.findNodeType("CONST_CLASS");
                        objectValue = tmpClass;
                    } else if (this.nodeTypeManager.isFunction(tempWord)) {
                        tempType = this.nodeTypeManager.findNodeType("FUNCTION_NAME");
                        ++point;
                    } else if (selfClassDefine != null && selfClassDefine.containsKey(tempWord)) {
                        tempType = this.nodeTypeManager.findNodeType("VClass");
                        ++point;
                    } else {
                        tempType = this.nodeTypeManager.findNodeType("ID");
                        ++point;
                    }
                } else {
                    ++point;
                }
            }
            result.add(new ExpressNode(tempType, tempWord, orgiValue, objectValue, treeNodeType, tmpWordObject.line, tmpWordObject.col, tmpWordObject.index));
            treeNodeType = null;
            objectValue = null;
            orgiValue = null;
        }
        return result;
    }

    public static void printTreeNode(StringBuilder builder, ExpressNode node, int level) {
        List<ExpressNode> rightChildren;
        int i;
        builder.append(level + ":");
        for (i = 0; i < level; ++i) {
            builder.append("   ");
        }
        builder.append(node);
        if (builder.length() < 100) {
            for (i = 0; i < 100 - builder.length(); ++i) {
                builder.append("   ");
            }
        }
        builder.append("\t" + node.getTreeType().getName()).append("\n");
        List<ExpressNode> leftChildren = node.getLeftChildren();
        if (leftChildren != null && leftChildren.size() > 0) {
            for (ExpressNode item : leftChildren) {
                ExpressParse.printTreeNode(builder, item, level + 1);
            }
        }
        if ((rightChildren = node.getRightChildren()) != null && rightChildren.size() > 0) {
            for (ExpressNode item : rightChildren) {
                ExpressParse.printTreeNode(builder, item, level + 1);
            }
        }
    }

    public static void printTreeNode(ExpressNode node, int level) {
        StringBuilder builder = new StringBuilder();
        ExpressParse.printTreeNode(builder, node, level);
        System.out.println(builder.toString());
    }

    public static void resetParent(ExpressNode node, ExpressNode parent) {
        List<ExpressNode> rightChildren;
        node.setParent(parent);
        List<ExpressNode> leftChildren = node.getLeftChildren();
        if (leftChildren != null && leftChildren.size() > 0) {
            for (ExpressNode item : leftChildren) {
                ExpressParse.resetParent(item, node);
            }
        }
        if ((rightChildren = node.getRightChildren()) != null && rightChildren.size() > 0) {
            for (ExpressNode item : rightChildren) {
                ExpressParse.resetParent(item, node);
            }
        }
    }

    public static void fetchSelfDefineClass(Word[] words, Map<String, String> selfDefineClass) {
        for (int i = 0; i < words.length - 1; ++i) {
            if (!"class".equals(words[i].word)) continue;
            selfDefineClass.put(words[i + 1].word, words[i + 1].word);
        }
    }

    public ExpressNode parse(ExpressPackage rootExpressPackage, String express, boolean isTrace, Map<String, String> selfDefineClass) throws Exception {
        Word[] words = this.splitWords(rootExpressPackage, express, isTrace, selfDefineClass);
        return this.parse(rootExpressPackage, words, express, isTrace, selfDefineClass);
    }

    public Word[] splitWords(ExpressPackage rootExpressPackage, String express, boolean isTrace, Map<String, String> selfDefineClass) throws Exception {
        Object[] words = WordSplit.parse(this.nodeTypeManager.splitWord, express);
        if (isTrace && log.isDebugEnabled()) {
            log.debug((Object)("\u6267\u884c\u7684\u8868\u8fbe\u5f0f:" + express));
            log.debug((Object)("\u5355\u8bcd\u5206\u89e3\u7ed3\u679c:" + WordSplit.getPrintInfo(words, ",")));
        }
        words = this.dealInclude((Word[])words);
        if (isTrace && log.isDebugEnabled()) {
            log.debug((Object)("\u9884\u5904\u7406\u540e\u7ed3\u679c:" + WordSplit.getPrintInfo(words, ",")));
        }
        if (selfDefineClass == null) {
            selfDefineClass = new HashMap<String, String>();
        }
        ExpressParse.fetchSelfDefineClass((Word[])words, selfDefineClass);
        for (int i = 0; i < words.length; ++i) {
            ((Word)words[i]).index = i;
        }
        return words;
    }

    public ExpressNode parse(ExpressPackage rootExpressPackage, Word[] words, String express, boolean isTrace, Map<String, String> selfDefineClass) throws Exception {
        return this.parse(rootExpressPackage, words, express, isTrace, selfDefineClass, false);
    }

    public ExpressNode parse(ExpressPackage rootExpressPackage, Word[] words, String express, boolean isTrace, Map<String, String> selfDefineClass, boolean mockRemoteJavaClass) throws Exception {
        QLMatchResult result;
        List<ExpressNode> tempList = this.transferWord2ExpressNode(rootExpressPackage, words, selfDefineClass, true);
        if (isTrace && log.isDebugEnabled()) {
            log.debug((Object)("\u5355\u8bcd\u5206\u6790\u7ed3\u679c:" + ExpressParse.printInfo(tempList, ",")));
        }
        if (mockRemoteJavaClass) {
            ArrayList<ExpressNode> tempList2 = new ArrayList<ExpressNode>();
            for (int i = 0; i < tempList.size(); ++i) {
                ExpressNode node = tempList.get(i);
                if (node.getValue().equals("new") && node.getNodeType().getKind() == NodeTypeKind.KEYWORD && i + 1 < tempList.size() && !"CONST_CLASS".equals(tempList.get(i + 1).getNodeType().getName())) {
                    tempList2.add(node);
                    int end = i + 1;
                    String configClass = tempList.get(end).getValue();
                    ++end;
                    while (!tempList.get(end).getValue().equals("(")) {
                        configClass = configClass + tempList.get(end).getValue();
                        ++end;
                    }
                    NodeType nodeType = this.nodeTypeManager.findNodeType("VClass");
                    ExpressNode vClassNode = new ExpressNode(nodeType, configClass);
                    tempList2.add(vClassNode);
                    i = end - 1;
                    continue;
                }
                tempList2.add(node);
            }
            tempList = tempList2;
            if (isTrace && log.isDebugEnabled()) {
                log.debug((Object)("\u4fee\u6b63\u540e\u5355\u8bcd\u5206\u6790\u7ed3\u679c:" + ExpressParse.printInfo(tempList, ",")));
            }
        }
        if ((result = QLPattern.findMatchStatement(this.nodeTypeManager, this.nodeTypeManager.findNodeType("PROGRAM").getPatternNode(), tempList, 0)) == null) {
            throw new QLCompileException("\u8bed\u6cd5\u5339\u914d\u5931\u8d25");
        }
        if (result.getMatchLastIndex() < tempList.size()) {
            int maxPoint = result.getMatchLastIndex();
            ExpressNode tempNode = tempList.get(maxPoint);
            throw new QLCompileException("\u8fd8\u6709\u5355\u8bcd\u6ca1\u6709\u5b8c\u6210\u8bed\u6cd5\u5339\u914d\uff1a" + result.getMatchLastIndex() + "[" + tempNode.getValue() + ":line=" + tempNode.getLine() + ",col=" + tempNode.getCol() + "] \u4e4b\u540e\u7684\u5355\u8bcd \n" + express);
        }
        result.getMatchs().get(0).buildExpressNodeTree();
        ExpressNode root = (ExpressNode)result.getMatchs().get(0).getRef();
        ExpressParse.resetParent(root, null);
        if (isTrace && log.isDebugEnabled()) {
            log.debug((Object)"\u6700\u540e\u7684\u8bed\u6cd5\u6811:");
            ExpressParse.printTreeNode(root, 1);
        }
        return root;
    }

    public static String printInfo(List<ExpressNode> list, String splitOp) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                buffer.append(splitOp);
            }
            buffer.append(list.get(i));
        }
        return buffer.toString();
    }
}

