/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.dubbo.actuate.endpoint.mvc;

import com.alibaba.boot.dubbo.actuate.endpoint.DubboEndpoint;
import com.alibaba.boot.dubbo.util.DubboUtils;
import com.alibaba.dubbo.config.AbstractConfig;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ConsumerConfig;
import com.alibaba.dubbo.config.MethodConfig;
import com.alibaba.dubbo.config.ModuleConfig;
import com.alibaba.dubbo.config.MonitorConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.ProviderConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.ServiceConfig;
import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.dubbo.config.spring.ReferenceBean;
import com.alibaba.dubbo.config.spring.ServiceBean;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import com.alibaba.dubbo.registry.support.AbstractRegistryFactory;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.async.DeferredResult;

public class DubboMvcEndpoint
extends EndpointMvcAdapter
implements ApplicationContextAware,
EnvironmentAware {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ApplicationContext applicationContext;
    private ConfigurableEnvironment environment;

    public DubboMvcEndpoint(DubboEndpoint dubboEndpoint) {
        super((Endpoint)dubboEndpoint);
    }

    @RequestMapping(value={"/shutdown"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public DeferredResult shutdown() throws Exception {
        DeferredResult result = new DeferredResult();
        LinkedHashMap<String, Integer> shutdownCountData = new LinkedHashMap<String, Integer>();
        int registriesCount = AbstractRegistryFactory.getRegistries().size();
        int protocolsCount = this.getProtocolConfigsBeanMap().size();
        ProtocolConfig.destroyAll();
        shutdownCountData.put("registries", registriesCount);
        shutdownCountData.put("protocols", protocolsCount);
        Map<String, ServiceBean> serviceBeansMap = this.getServiceBeansMap();
        if (!serviceBeansMap.isEmpty()) {
            for (ServiceBean serviceBean : serviceBeansMap.values()) {
                serviceBean.destroy();
            }
        }
        shutdownCountData.put("services", serviceBeansMap.size());
        ReferenceAnnotationBeanPostProcessor beanPostProcessor = this.getReferenceAnnotationBeanPostProcessor();
        int referencesCount = beanPostProcessor.getReferenceBeans().size();
        beanPostProcessor.destroy();
        shutdownCountData.put("references", referencesCount);
        TreeMap<String, LinkedHashMap<String, Integer>> shutdownData = new TreeMap<String, LinkedHashMap<String, Integer>>();
        shutdownData.put("shutdown.count", shutdownCountData);
        result.setResult(shutdownData);
        return result;
    }

    @RequestMapping(value={"/configs"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, Map<String, Map<String, Object>>> configs() {
        LinkedHashMap<String, Map<String, Map<String, Object>>> configsMap = new LinkedHashMap<String, Map<String, Map<String, Object>>>();
        this.addDubboConfigBeans(ApplicationConfig.class, configsMap);
        this.addDubboConfigBeans(ConsumerConfig.class, configsMap);
        this.addDubboConfigBeans(MethodConfig.class, configsMap);
        this.addDubboConfigBeans(ModuleConfig.class, configsMap);
        this.addDubboConfigBeans(MonitorConfig.class, configsMap);
        this.addDubboConfigBeans(ProtocolConfig.class, configsMap);
        this.addDubboConfigBeans(ProviderConfig.class, configsMap);
        this.addDubboConfigBeans(ReferenceConfig.class, configsMap);
        this.addDubboConfigBeans(RegistryConfig.class, configsMap);
        this.addDubboConfigBeans(ServiceConfig.class, configsMap);
        return configsMap;
    }

    @RequestMapping(value={"/services"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, Map<String, Object>> services() {
        Map<String, ServiceBean> serviceBeansMap = this.getServiceBeansMap();
        LinkedHashMap<String, Map<String, Object>> servicesMetadata = new LinkedHashMap<String, Map<String, Object>>(serviceBeansMap.size());
        for (Map.Entry<String, ServiceBean> entry : serviceBeansMap.entrySet()) {
            String serviceBeanName = entry.getKey();
            ServiceBean serviceBean = entry.getValue();
            Map<String, Object> serviceBeanMetadata = this.resolveBeanMetadata(serviceBean);
            Object service = this.resolveServiceBean(serviceBeanName, serviceBean);
            if (service != null) {
                serviceBeanMetadata.put("serviceClass", service.getClass().getName());
            }
            servicesMetadata.put(serviceBeanName, serviceBeanMetadata);
        }
        return servicesMetadata;
    }

    @RequestMapping(value={"/references"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, Map<String, Object>> references() {
        LinkedHashMap<String, Map<String, Object>> referencesMetadata = new LinkedHashMap<String, Map<String, Object>>();
        Map<InjectionMetadata.InjectedElement, ReferenceBean<?>> injectedElementReferenceBeanMap = this.resolveInjectedElementReferenceBeanMap();
        for (Map.Entry<InjectionMetadata.InjectedElement, ReferenceBean<?>> entry : injectedElementReferenceBeanMap.entrySet()) {
            InjectionMetadata.InjectedElement injectedElement = entry.getKey();
            ReferenceBean<?> referenceBean = entry.getValue();
            Map<String, Object> beanMetadata = this.resolveBeanMetadata(referenceBean);
            beanMetadata.put("invoker", this.resolveBeanMetadata(referenceBean.get()));
            referencesMetadata.put(String.valueOf(injectedElement.getMember()), beanMetadata);
        }
        return referencesMetadata;
    }

    @RequestMapping(value={"/properties"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public SortedMap<String, Object> properties() {
        return DubboUtils.filterDubboProperties((ConfigurableEnvironment)this.environment);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setEnvironment(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            this.environment = (ConfigurableEnvironment)environment;
        }
    }

    private Map<String, ServiceBean> getServiceBeansMap() {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ServiceBean.class);
    }

    private void addDubboConfigBeans(Class<? extends AbstractConfig> dubboConfigClass, Map<String, Map<String, Map<String, Object>>> configsMap) {
        Map dubboConfigBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, dubboConfigClass);
        String name = dubboConfigClass.getSimpleName();
        TreeMap<String, Map<String, Object>> beansMetadata = new TreeMap<String, Map<String, Object>>();
        for (Map.Entry entry : dubboConfigBeans.entrySet()) {
            String beanName = (String)entry.getKey();
            AbstractConfig configBean = (AbstractConfig)entry.getValue();
            Map<String, Object> configBeanMeta = this.resolveBeanMetadata(configBean);
            beansMetadata.put(beanName, configBeanMeta);
        }
        configsMap.put(name, beansMetadata);
    }

    private ReferenceAnnotationBeanPostProcessor getReferenceAnnotationBeanPostProcessor() {
        return (ReferenceAnnotationBeanPostProcessor)this.applicationContext.getBean("referenceAnnotationBeanPostProcessor", ReferenceAnnotationBeanPostProcessor.class);
    }

    private Map<InjectionMetadata.InjectedElement, ReferenceBean<?>> resolveInjectedElementReferenceBeanMap() {
        LinkedHashMap injectedElementReferenceBeanMap = new LinkedHashMap();
        ReferenceAnnotationBeanPostProcessor processor = this.getReferenceAnnotationBeanPostProcessor();
        ConcurrentMap injectionMetadataCache = this.getFieldValue(processor, "injectionMetadataCache", ConcurrentMap.class);
        ConcurrentMap referenceBeansCache = this.getFieldValue(processor, "referenceBeansCache", ConcurrentMap.class);
        for (InjectionMetadata metadata : injectionMetadataCache.values()) {
            Set checkedElements = this.getFieldValue(metadata, "checkedElements", Set.class);
            Collection injectedElements = this.getFieldValue(metadata, "injectedElements", Collection.class);
            Collection actualInjectedElements = checkedElements != null ? checkedElements : injectedElements;
            for (InjectionMetadata.InjectedElement injectedElement : actualInjectedElements) {
                ReferenceBean<?> referenceBean = this.resolveReferenceBean(injectedElement, referenceBeansCache);
                injectedElementReferenceBeanMap.put(injectedElement, referenceBean);
            }
        }
        return injectedElementReferenceBeanMap;
    }

    private ReferenceBean<?> resolveReferenceBean(InjectionMetadata.InjectedElement injectedElement, ConcurrentMap<String, ReferenceBean<?>> referenceBeansCache) {
        Member member = injectedElement.getMember();
        Class<?> beanClass = null;
        Reference reference = this.getFieldValue(injectedElement, "reference", Reference.class);
        if (member instanceof Field) {
            Field field = (Field)member;
            beanClass = field.getType();
        } else if (member instanceof Method) {
            Method method = (Method)member;
            beanClass = ((Method)member).getReturnType();
        } else {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("What's wrong with Member? Member should not be Field or Method");
            }
            throw new IllegalStateException("What's wrong with Member? Member should not be Field or Method");
        }
        String referenceBeanCacheKey = DubboMvcEndpoint.generateReferenceBeanCacheKey(reference, beanClass);
        return (ReferenceBean)referenceBeansCache.get(referenceBeanCacheKey);
    }

    private static String generateReferenceBeanCacheKey(Reference reference, Class<?> beanClass) {
        String interfaceName = DubboMvcEndpoint.resolveInterfaceName(reference, beanClass);
        String key = reference.group() + "/" + interfaceName + ":" + reference.version();
        return key;
    }

    private static String resolveInterfaceName(Reference reference, Class<?> beanClass) throws IllegalStateException {
        String interfaceName;
        if (!"".equals(reference.interfaceName())) {
            interfaceName = reference.interfaceName();
        } else if (!Void.TYPE.equals(reference.interfaceClass())) {
            interfaceName = reference.interfaceClass().getName();
        } else if (beanClass.isInterface()) {
            interfaceName = beanClass.getName();
        } else {
            throw new IllegalStateException("The @Reference undefined interfaceClass or interfaceName, and the property type " + beanClass.getName() + " is not a interface.");
        }
        return interfaceName;
    }

    private <T> T getFieldValue(Object object, String fieldName, Class<T> fieldType) {
        Field field = ReflectionUtils.findField(object.getClass(), (String)fieldName, fieldType);
        ReflectionUtils.makeAccessible((Field)field);
        return (T)ReflectionUtils.getField((Field)field, (Object)object);
    }

    private Map<String, Object> resolveBeanMetadata(Object bean) {
        LinkedHashMap<String, Object> beanMetadata = new LinkedHashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method readMethod = propertyDescriptor.getReadMethod();
                if (readMethod == null || !DubboMvcEndpoint.isSimpleType(propertyDescriptor.getPropertyType())) continue;
                String name = Introspector.decapitalize(propertyDescriptor.getName());
                Object value = readMethod.invoke(bean, new Object[0]);
                beanMetadata.put(name, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return beanMetadata;
    }

    private Object resolveServiceBean(String serviceBeanName, ServiceBean serviceBean) {
        int index = serviceBeanName.indexOf("#");
        if (index > -1) {
            Class interfaceClass = serviceBean.getInterfaceClass();
            String serviceName = serviceBeanName.substring(index + 1);
            if (this.applicationContext.containsBean(serviceName)) {
                return this.applicationContext.getBean(serviceName, interfaceClass);
            }
        }
        return null;
    }

    private static boolean isSimpleType(Class<?> type) {
        return ClassUtils.isPrimitiveOrWrapper(type) || type == String.class || type == BigDecimal.class || type == BigInteger.class || type == Date.class || type == URL.class || type == Class.class;
    }

    private Map<String, ProtocolConfig> getProtocolConfigsBeanMap() {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ProtocolConfig.class);
    }
}

