/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.ConfigResource;
import com.alibaba.antx.config.ConfigRuntime;
import com.alibaba.antx.config.ConfigSettings;
import com.alibaba.antx.config.descriptor.ConfigDescriptor;
import com.alibaba.antx.config.entry.ConfigEntry;
import com.alibaba.antx.config.entry.ConfigEntryFactory;
import com.alibaba.antx.config.entry.ConfigEntryFactoryImpl;
import com.alibaba.antx.config.props.PropertiesResource;
import com.alibaba.antx.config.props.PropertiesSet;
import com.alibaba.antx.config.wizard.text.ConfigWizardLoader;
import com.alibaba.antx.util.CharsetUtil;
import com.alibaba.antx.util.PatternSet;
import com.alibaba.antx.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class ConfigRuntimeImpl
implements ConfigRuntime {
    private BufferedReader in;
    private PrintWriter out;
    private PrintWriter err;
    private String charset;
    private String mode;
    private String interactiveMode = "auto";
    private String type;
    private PatternSet descriptorPatterns;
    private PatternSet packagePatterns;
    private String[] dests;
    private String[] outputs;
    private File[] destFiles;
    private File[] outputFiles;
    private PropertiesSet props;
    private boolean verbose;
    private File tempdir;
    private ConfigEntryFactory configEntryFactory = new ConfigEntryFactoryImpl(this);

    public ConfigRuntimeImpl() {
        this(System.in, System.out, System.err, null);
    }

    public ConfigRuntimeImpl(InputStream inputStream, OutputStream outStream, OutputStream errStream, String charset) {
        boolean charsetSpecified = !StringUtil.isEmpty(charset);
        this.charset = charsetSpecified ? charset : CharsetUtil.detectedSystemCharset();
        try {
            this.in = new BufferedReader(new InputStreamReader(inputStream, this.charset));
            this.out = new PrintWriter((Writer)new OutputStreamWriter(outStream, this.charset), true);
            this.err = new PrintWriter((Writer)new OutputStreamWriter(errStream, this.charset), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigException(e);
        }
        if (!charsetSpecified) {
            this.out.println("Detected system charset encoding: " + this.charset);
            this.out.println("If your can't read the following text, specify correct one like this: ");
            this.out.println("  autoconfig -c mycharset");
            this.out.println();
        }
    }

    public BufferedReader getIn() {
        return this.in;
    }

    public PrintWriter getOut() {
        return this.out;
    }

    public PrintWriter getErr() {
        return this.err;
    }

    public String getCharset() {
        return this.charset;
    }

    public PatternSet getDescriptorPatterns() {
        return this.descriptorPatterns;
    }

    public PatternSet getPackagePatterns() {
        return this.packagePatterns;
    }

    public String getInteractiveMode() {
        return this.interactiveMode;
    }

    public String getMode() {
        return this.mode;
    }

    public File[] getDestFiles() {
        return this.destFiles;
    }

    public File[] getOutputFiles() {
        return this.outputFiles;
    }

    public PropertiesSet getPropertiesSet() {
        if (this.props == null) {
            this.props = new PropertiesSet(this.getIn(), this.getOut());
        }
        return this.props;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ConfigEntryFactory getConfigEntryFactory() {
        return this.configEntryFactory;
    }

    public void setDescriptorPatterns(String includes, String excludes) {
        this.descriptorPatterns = new PatternSet(includes, excludes);
    }

    public void setDescriptorPatterns(String[] includes, String[] excludes) {
        this.descriptorPatterns = new PatternSet(includes, excludes);
    }

    public void setPackagePatterns(String includes, String excludes) {
        this.packagePatterns = new PatternSet(includes, excludes);
    }

    public void setPackagePatterns(String[] includes, String[] excludes) {
        this.packagePatterns = new PatternSet(includes, excludes);
    }

    public void setInteractiveMode(String mode) {
        if ("auto".equals(mode) || "on".equals(mode) || "off".equals(mode)) {
            this.interactiveMode = mode;
        }
    }

    public void setGuiMode() {
        this.mode = "gui";
    }

    public void setTextMode() {
        this.mode = "text";
    }

    public void setDests(String[] dests) {
        this.dests = dests;
    }

    public void setDestFiles(File[] destFiles) {
        this.destFiles = (File[])destFiles.clone();
    }

    public void setOutputs(String[] outputs) {
        this.outputs = outputs;
    }

    public void setOutputFiles(File[] outputFiles) {
        this.outputFiles = (File[])outputFiles.clone();
    }

    public void setUserPropertiesFile(String userPropertiesFile, String charset) {
        PropertiesSet props = this.getPropertiesSet();
        props.setUserPropertiesFile(userPropertiesFile);
        props.getUserPropertiesFile().setCharset(charset);
    }

    public void setSharedPropertiesFiles(String[] sharedPropertiesFiles, String name, String charset) {
        PropertiesResource[] resources;
        this.getPropertiesSet().setSharedPropertiesFiles(sharedPropertiesFiles);
        this.getPropertiesSet().setSharedPropertiesFilesName(name);
        for (PropertiesResource resource : resources = this.getPropertiesSet().getSharedPropertiesFiles()) {
            resource.setCharset(charset);
        }
        if (!StringUtil.isEmpty(name) || sharedPropertiesFiles != null && sharedPropertiesFiles.length > 0) {
            this.interactiveMode = "on";
        }
    }

    public void setVerbose() {
        this.verbose = true;
    }

    private void init() {
        int i;
        if (this.tempdir == null) {
            this.tempdir = new File("");
        }
        this.tempdir = this.tempdir.getAbsoluteFile();
        if (this.dests != null && this.dests.length > 0) {
            this.destFiles = new File[this.dests.length];
            for (i = 0; i < this.dests.length; ++i) {
                this.destFiles[i] = new File(this.dests[i]).getAbsoluteFile();
            }
        } else {
            this.destFiles = new File[0];
        }
        if (this.outputs != null && this.outputs.length > 0) {
            this.outputFiles = new File[this.outputs.length];
            for (i = 0; i < this.outputs.length; ++i) {
                if (this.outputs[i] == null) continue;
                this.outputFiles[i] = new File(this.outputs[i]).getAbsoluteFile();
            }
        } else {
            this.outputFiles = new File[this.destFiles.length];
        }
        if (this.outputFiles.length != this.destFiles.length) {
            throw new IllegalArgumentException("Mismatched output files and dest files");
        }
        this.getPropertiesSet().init();
        this.info("User-defined properties: " + this.getPropertiesSet().getUserPropertiesFile().getURI() + "\n");
    }

    public void debug(String message) {
        if (this.verbose) {
            this.getOut().println(message);
        }
    }

    public void info(String message) {
        this.getOut().println(message);
    }

    public void warn(String message) {
        this.getOut().println(message);
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(Throwable cause) {
        this.error(null, cause);
    }

    public void error(String message, Throwable cause) {
        if (StringUtil.isBlank(message) && cause != null) {
            message = "ERROR: " + cause.getMessage();
        }
        this.getErr().println(message);
        if (this.verbose) {
            cause.printStackTrace(this.getErr());
            this.getErr().println();
        }
    }

    public boolean start() {
        return this.start(null);
    }

    public boolean start(ConfigDescriptor inlineDescriptor) {
        this.init();
        if (inlineDescriptor == null && "gui".equals(this.mode)) {
            throw new UnsupportedOperationException("GUI mode currently unsupported");
        }
        if (inlineDescriptor == null) {
            List entries = this.scan(false);
            if (entries.isEmpty() && !"on".equals(this.interactiveMode)) {
                this.info("Nothing to configure");
                return true;
            }
            ConfigWizardLoader wizard = new ConfigWizardLoader((ConfigSettings)this, entries);
            wizard.loadAndStart();
            boolean allSuccess = true;
            for (ConfigEntry entry : entries) {
                allSuccess &= entry.generate();
            }
            return allSuccess;
        }
        ConfigWizardLoader wizard = new ConfigWizardLoader((ConfigSettings)this, inlineDescriptor);
        wizard.loadAndStart();
        return true;
    }

    public List scan(boolean includeEmptyEntries) {
        ArrayList<ConfigEntry> entries = new ArrayList<ConfigEntry>(this.destFiles.length);
        for (int i = 0; i < this.destFiles.length; ++i) {
            File destFile = this.destFiles[i];
            File outputFile = this.outputFiles[i];
            ConfigEntry entry = this.getConfigEntryFactory().create(new ConfigResource(destFile), outputFile, this.type);
            entry.scan();
            if (!includeEmptyEntries && entry.isEmpty()) continue;
            entries.add(entry);
        }
        return entries;
    }
}

