/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.descriptor;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.ConfigResource;
import com.alibaba.antx.config.descriptor.ConfigDescriptor;
import com.alibaba.antx.config.descriptor.ConfigGenerate;
import com.alibaba.antx.config.descriptor.ConfigGroup;
import com.alibaba.antx.config.descriptor.ConfigProperty;
import com.alibaba.antx.config.descriptor.ConfigValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.plugins.PluginCreateRule;
import org.apache.commons.digester.plugins.PluginDeclarationRule;
import org.apache.commons.digester.plugins.PluginRules;

public class ConfigDescriptorLoader {
    public synchronized ConfigDescriptor load(ConfigResource descriptorResource, InputStream istream) {
        Digester digester = this.getDigester();
        digester.push(new ConfigDescriptor(descriptorResource));
        try {
            return (ConfigDescriptor)digester.parse(istream);
        }
        catch (Exception e) {
            throw new ConfigException("Failed to load config descriptor: " + descriptorResource.getURL(), e);
        }
    }

    public synchronized Map loadValidatorClasses() {
        Digester digester = this.loadValidatorPlugins();
        return (Map)digester.pop();
    }

    protected Digester getDigester() {
        Digester digester = this.loadValidatorPlugins();
        digester.addSetProperties("config");
        digester.addObjectCreate("config/group", ConfigGroup.class);
        digester.addSetProperties("config/group");
        digester.addSetNext("config/group", "addGroup");
        digester.addObjectCreate("config/group/property", ConfigProperty.class);
        digester.addSetProperties("config/group/property");
        digester.addCallMethod("config/group/property", "afterPropertiesSet");
        digester.addSetNext("config/group/property", "addProperty");
        PluginCreateRule pcr = new PluginCreateRule(ConfigValidator.class);
        pcr.setPluginIdAttribute(null, "name");
        digester.addRule("config/group/property/validator", pcr);
        digester.addSetNext("config/group/property/validator", "addValidator");
        digester.addObjectCreate("config/script/generate", ConfigGenerate.class);
        digester.addSetProperties("config/script/generate");
        digester.addSetNext("config/script/generate", "addGenerate");
        digester.clear();
        return digester;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Digester loadValidatorPlugins() {
        Digester digester;
        block7: {
            digester = new Digester();
            digester.setRules(new PluginRules());
            digester.addObjectCreate("config-property-validators", HashMap.class);
            digester.addCallMethod("config-property-validators/validator", "put", 2);
            digester.addCallParam("config-property-validators/validator", 0, "id");
            digester.addCallParam("config-property-validators/validator", 1, "class");
            digester.addRule("config-property-validators/validator", new PluginDeclarationRule());
            InputStream istream = this.getClass().getResourceAsStream("validators.xml");
            try {
                try {
                    digester.push(digester.parse(istream));
                }
                catch (Exception e) {
                    throw new ConfigException("Failed to load validators", e);
                }
                Object var5_3 = null;
                if (istream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (istream == null) throw throwable;
                try {
                    istream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            istream.close();
        }
        digester.getRules().clear();
        return digester;
    }
}

