/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.descriptor.validator;

import com.alibaba.antx.config.descriptor.ConfigValidator;
import com.alibaba.antx.config.descriptor.ConfigValidatorException;
import com.alibaba.antx.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChoiceValidator
extends ConfigValidator {
    private static final Logger log = LoggerFactory.getLogger(ChoiceValidator.class);
    private String[] choices;

    public Logger getLogger() {
        return log;
    }

    public String[] getAllChoices() {
        return this.choices;
    }

    public void setChoice(String choice) {
        this.choices = StringUtil.split(choice);
    }

    public boolean validate(String value) {
        String[] choices = this.getAllChoices();
        if (choices == null || choices.length == 0) {
            throw new ConfigValidatorException("You must define an attribute called 'choice' for choice validator");
        }
        if (value == null) {
            return true;
        }
        if (StringUtil.isEmpty(value = value.trim())) {
            return true;
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Validating value with choice[");
            for (int i = 0; i < choices.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(choices[i]);
            }
            buffer.append("]: ").append(value);
            this.getLogger().debug(buffer.toString());
        }
        for (String choice : choices) {
            if (!value.equals(choice)) continue;
            return true;
        }
        return false;
    }

    protected String getDefaultMessage() {
        StringBuffer buffer = new StringBuffer("\u60a8\u5fc5\u987b\u5728\u4e0b\u5217\u503c\u4e2d\u9009\u62e9\uff1a");
        String[] choices = this.getAllChoices();
        for (int i = 0; i < choices.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(choices[i]);
        }
        return buffer.toString();
    }
}

